/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : speeds.c                                         */
/* contenu       : menu used to set up speeds                       */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <string.h>
#include <stdio.h>

#include "advanced.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "menu.h"
#include "rules.h"
#include "sound.h"
#include "time.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static void write_cis_setting (DIALOG *d)
{
 char *str;

 str=d->dp;
 sprintf (str,"Cursor x%d",CONFIG_CURSOR_INCREASE_SPEED+1);
}

/*------------------------------------------------------------------*/
static int slider_cis (void *dp3, int d2)
{
 DIALOG *d;

 d=dp3;

 CONFIG_CURSOR_INCREASE_SPEED=d2;
 write_cis_setting (d);
 my_textbox_proc (MSG_DRAW, d, 0);

 play_click ();

 return 0;
}

/*------------------------------------------------------------------*/
static void write_fps_setting (DIALOG *d)
{
 char *str;

 str=d->dp;
 if (DISPLAY_DELAY_MIN[CONFIG_FRAMES_PER_SEC_LIMIT]!=0)
   {
     sprintf (str,"%d frames/s",
	      1000/(DISPLAY_DELAY_MIN[CONFIG_FRAMES_PER_SEC_LIMIT]));
   }
 else
   {
     sprintf(str,"No fps limit");
   }
}

/*------------------------------------------------------------------*/
static int slider_fps (void *dp3, int d2)
{
 DIALOG *d;

 d=dp3;

 CONFIG_FRAMES_PER_SEC_LIMIT=d2;
 write_fps_setting (d);
 my_textbox_proc (MSG_DRAW, d, 0);

 play_click ();

 return 0;
}

/*------------------------------------------------------------------*/
static void write_rps_setting (DIALOG *d)
{
 char *str;

 str=d->dp;
 if (LOGIC_DELAY_MIN[CONFIG_ROUNDS_PER_SEC_LIMIT]!=0)
   {
     sprintf (str,"%d rounds/s",
	      1000/(LOGIC_DELAY_MIN[CONFIG_ROUNDS_PER_SEC_LIMIT]));
   }
 else
   {
     sprintf(str,"No rps limit");
   }
}

/*------------------------------------------------------------------*/
static int slider_rps (void *dp3, int d2)
{
 DIALOG *d;

 d=dp3;

 CONFIG_ROUNDS_PER_SEC_LIMIT=d2;
 write_rps_setting (d);
 my_textbox_proc (MSG_DRAW, d, 0);

 play_click ();

 return 0;
}

/*------------------------------------------------------------------*/
int speeds_options (void)
{
  int *temp;
  DIALOG d[11];
  int i,choix=4,retour=0;
  char cis_buffer[30];
  char fps_buffer[30];
  char rps_buffer[30];
  
  for (i=0; i<3; ++i)
      {
       standard_button (d+i+4,0,i,2,3);
       d[i+4].proc=my_textbox_proc;
      }
  for (i=0; i<3; ++i)
      {
       standard_button (d+i+7,1,i,2,3);
       d[i+7].proc=my_slider_proc;
      }

  quick_buttons(d);
  d[4].dp=cis_buffer;
  d[5].dp=fps_buffer;
  d[6].dp=rps_buffer;
  d[7].d1=2;
  d[8].d1=8;
  d[9].d1=8;
  d[7].dp3=&CONFIG_CURSOR_INCREASE_SPEED;
  d[8].dp3=&CONFIG_FRAMES_PER_SEC_LIMIT;
  d[9].dp3=&CONFIG_ROUNDS_PER_SEC_LIMIT;
  for (i=0;i<3;++i)
      {
       d[i+7].dp=NULL;
       d[i+7].dp2=slider_int;
       temp=d[i+7].dp3;
       d[i+7].d2=*temp;
       d[i+7].dp3=d+i+4;
      }

  d[7].dp2=slider_cis; 
  d[8].dp2=slider_fps; 
  d[9].dp2=slider_rps; 

  write_cis_setting(d+4);
  write_fps_setting(d+5);
  write_rps_setting(d+6);

  d[10].proc=0;

  while (retour==0)
        {
          choix=my_do_dialog (d,choix);
          switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_SPEEDS);
                  break;
             }
        }

  if (retour>0)
    retour--;

 return retour;
}

