/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* name          : netmap.c                                         */
/* content       : functions to transmit maps over the network      */
/* last update   : June 30th 2001                                   */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <stdlib.h>

#include "netmap.h"
#include "log.h"
#include "sock2gen.h"

/*==================================================================*/
/* constants                                                        */
/*==================================================================*/

#define LW_NETMAP_CHUNK_SIZE 64

/*==================================================================*/
/* types                                                            */
/*==================================================================*/

/*==================================================================*/
/* static functions declaration                                     */
/*==================================================================*/

/*==================================================================*/
/* functions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/*
 * Sends a map over the network
 */
int lw_netmap_send(int sock,void *netmap)
{
  int result=0;
  int *int_ptr;
  char *char_ptr;
  int size;
  int sent;
  int to_send;

  char_ptr=(char *) netmap;
  if (lw_sock_send_buffer(sock,char_ptr,8))
    {
      int_ptr=(int *) char_ptr;
      size=int_ptr[0];

      result=1;
      sent=0;
      while (sent<size && result)
	{
	  to_send=size-sent;
	  if (to_send>LW_NETMAP_CHUNK_SIZE)
	    {
	      to_send=LW_NETMAP_CHUNK_SIZE;
	    }
	  if (lw_sock_send_buffer(sock,char_ptr+8+sent,to_send))
	    {
	      sent+=to_send;
	    }
	  else
	    {
	      result=0;
	    }
	}
    }

  return result;
}

/*------------------------------------------------------------------*/
/*
 * Receives a map from the network
 */
int lw_netmap_recv(int sock,void **netmap)
{
  int result=0;
  char buffer[8];
  int size;
  short w,h;
  int *int_ptr;
  short *short_ptr;
  char *char_ptr;
  int received;
  int to_receive;

  char_ptr=(char *) (*netmap);
  if (char_ptr!=NULL)
    {
      free(char_ptr);
    }

  if (lw_sock_recv_buffer(sock,buffer,8))
    {
      int_ptr=(int *) buffer;
      short_ptr=(short *) buffer;
      size=int_ptr[0];
      w=short_ptr[2];
      h=short_ptr[3];

      char_ptr=malloc(size+8);
      if (char_ptr!=NULL)
	{
	  memcpy(char_ptr,buffer,8);

	  result=1;
	  received=0;
	  while (received<size && result)
	    {
	      to_receive=size-received;
	      if (to_receive>LW_NETMAP_CHUNK_SIZE)
		{
		  to_receive=LW_NETMAP_CHUNK_SIZE;
		}

	      if (lw_sock_recv_buffer(sock,char_ptr+8+received,to_receive))
		{
		  received+=to_receive;
		}
	      else
		{
		  result=0;
		}
	    }
	}
    }

  (*netmap)=(void *) char_ptr;

  return result;
}





