/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : init.c                                           */
/* contenu       : installation d'allegro                           */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "config.h"
#include "gfxmode.h"
#include "init.h"
#include "joystick.h"
#include "log.h"
#include "startup.h"
#include "ticker.h"
#include "sockgen.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
void display_success (int success)
{
 if (success)
     log_println_str (" - success!");
 else
   log_println_str (" - failed...");  
   log_flush();
/* delay (100);*/
}

/*------------------------------------------------------------------*/
int init_all ()
{
 int result=0;
 int config=1,timer=1,keyboard=1,mouse=1,sound=1,joystick=1,network=1;

 allegro_init ();
 #ifdef ALLEGRO_DOS
 set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
 #endif
 log_println_str ("Starting Allegro by Shawn Hargreaves.");
 log_println();
 log_print_str("Platform : ");
 log_println_str(ALLEGRO_PLATFORM_STR);
 log_println();
 
 set_startup();
 log_print_str("Loading config options from \"");
 log_print_str(STARTUP_CFG_PATH);
 log_print_str("\"");
 
 display_success (config=load_config_options());

 log_print_str("Installing timer");

 display_success (timer=!install_timer ());

 start_ticker();

 log_print_str ("Installing keyboard");
 display_success (keyboard=!install_keyboard ());

 log_print_str ("Installing mouse");
 display_success (mouse=install_mouse () != -1);

 if (STARTUP_DIGI_CARD != DIGI_NONE)
     {
     log_print_str ("Installing sound");
     display_success (sound=!install_sound
                     (STARTUP_DIGI_CARD,
                     MIDI_NONE,
                     ""));
     }
 if (STARTUP_JOYSTICK_ON)
    {
     log_print_str ("Installing joystick");
     if (STARTUP_JOYSTICK_ON)
        display_success (joystick=!my_initialise_joystick ());
    }

 log_print_str("Setting up network");
 display_success(network=lw_sock_init());

 set_color_conversion (COLORCONV_TOTAL);

 result= timer&&keyboard&&mouse
         &&(sound||!STARTUP_CHECK)
         &&(joystick||!STARTUP_CHECK);

 return (result);
}

/*------------------------------------------------------------------*/
int start_graphic (void)
{
 int retour;

 retour= (!set_resolution (CONFIG_GFX_MENU,0));

 return retour;
}



