/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : advanced.c                                       */
/* contenu       : choix des options de jeu avancees                */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "advanced.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "time.h"
#include "menu.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int advanced_options (void)
{
  int *temp;
  DIALOG d[15];
  int i,retour=0,choix=4;
  static int y_pos[5]={0,1,2,4,6};

  for (i=0; i<5; ++i)
      {
       standard_button (d+i+4,0,y_pos[i],2,7);
       d[i+4].proc=my_textbox_proc;
      }
  for (i=0; i<5; ++i)
      {
       standard_button (d+i+9,1,y_pos[i],2,7);
       d[i+9].proc=my_slider_proc;
      }

  quick_buttons(d);
  d[4].dp="Attack";
  d[5].dp="Defense";
  d[6].dp="Base health";
  d[7].dp="Winner help";
  d[8].dp="Cpu strength";
  d[9].d1=d[10].d1=d[11].d1=d[12].d1=16;
  d[13].d1=4;
  d[9].dp3=&CONFIG_FIGHTER_ATTACK;
  d[10].dp3=&CONFIG_FIGHTER_DEFENSE;
  d[11].dp3=&CONFIG_FIGHTER_NEW_HEALTH;
  d[12].dp3=&CONFIG_NUMBER_INFLUENCE;
  d[13].dp3=&CONFIG_CPU_ADVANTAGE;
  for (i=9;i<14;++i)
      {
       d[i].dp=NULL;
       d[i].dp2=slider_int;
       temp=d[i].dp3;
       d[i].d2=*temp;
      }
  d[14].proc=0;

  while (retour==0)
        {
          choix=my_do_dialog (d,choix);
          switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_ADVANCED);
                  break;
             }
        }

  if (retour>0)
    retour--;

 return retour;
}



