/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : keyboard.c                                       */
/* contenu       : gestion du clavier                               */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "config.h"
#include "joystick.h"
#include "keyboard.h"
#include "mouse.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

static char ALLOWED_KEYBOARD_KEY[128]=
{
1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1,
1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1,
1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1,
1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1,
1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1,
1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1,
1,1,1,1, 1,1,1,1, 1,1,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
};

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int is_touched_key (int i)
{
 int retval=0;
 int found=0;

 if (CONFIG_JOYSTICK_ON)
 switch (i)
        {
         case KEY_JOY1_UP : found=1;
                            retval=joy_up;
                            break;
         case KEY_JOY1_RIGHT : found=1;
                               retval=joy_right;
                               break;
         case KEY_JOY1_DOWN : found=1;
                              retval=joy_down;
                              break;
         case KEY_JOY1_LEFT : found=1;
                              retval=joy_left;
                              break;

         case KEY_JOY1_B1 : found=1;
                            retval=joy_b1;
                            break;
         case KEY_JOY1_B2 : found=1;
                            retval=joy_b2;
                            break;

         case KEY_JOY2_UP : found=1;
                            retval=joy2_up;
                            break;
         case KEY_JOY2_RIGHT : found=1;
                               retval=joy2_right;
                               break;
         case KEY_JOY2_DOWN : found=1;
                              retval=joy2_down;
                              break;
         case KEY_JOY2_LEFT : found=1;
                              retval=joy2_left;
                              break;

         case KEY_JOY2_B1 : found=1;
                            retval=joy2_b1;
                            break;
         case KEY_JOY2_B2 : found=1;
                            retval=joy2_b2;
                            break;
        }

 if (!found)
 switch (i)
        {
         case KEY_MOUSE_UP :  retval=MOUSE_CONTROL_UP;
                              break;
         case KEY_MOUSE_RIGHT : retval=MOUSE_CONTROL_RIGHT;
                                break;
         case KEY_MOUSE_DOWN : retval=MOUSE_CONTROL_DOWN;
                               break;
         case KEY_MOUSE_LEFT : retval=MOUSE_CONTROL_LEFT;
                               break;
         default:

         
                 if (i>128)
                    {
                    i-=128;
                    retval= (key[i]&KB_EXTENDED)
                            && ALLOWED_KEYBOARD_KEY[i];
                    }
                 else
                     retval= (key[i]&KB_NORMAL)
                             && ALLOWED_KEYBOARD_KEY[i];
 
       }
 

 return retval ? 1 : 0;
}

/*------------------------------------------------------------------*/
void wait_no_key (void)
{
 int touched,i;

 reset_mouse_control ();
 do
       {
        touched=0;
        update_mouse_control ();
        my_poll_joystick ();
        for (i=0;i<256;++i)
            if (is_touched_key(i))
                touched=1;
       }
 while (touched);
}

/*------------------------------------------------------------------*/
int wait_key_pressed (void)
{
 int touched=0,i,result=0;

 reset_mouse_control ();
 while (!touched)
       {
         update_mouse_control ();
         my_poll_joystick ();
         for (i=0;i<256 && !touched;++i)
            if (is_touched_key(i))
               {
                touched=1;
                result=i;
               }
       }

 return result;
}


