/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : glouglou.s                                       */
/* contenu       : affichage avec vagues accelere                   */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

.equ BMP_W,                 0
.equ BMP_H,                 4
.equ BMP_CLIP,              8
.equ BMP_CL,                12
.equ BMP_CR,                16
.equ BMP_CT,                20
.equ BMP_CB,                24
.equ BMP_VTABLE,            28
.equ BMP_WBANK,             32
.equ BMP_RBANK,             36
.equ BMP_DAT,               40
.equ BMP_ID,                44
.equ BMP_EXTRA,             48
.equ BMP_LINEOFS,           52
.equ BMP_SEG,               56
.equ BMP_LINE,              60

.equ ARG_NEXT_SCREEN,            8
.equ ARG_CURRENT_AREA_W,        12
.equ ARG_H,                     16
.equ ARG_X,                     20
.equ ARG_FP_Y,                  24
.equ ARG_IP_Y,                  28
.equ ARG_FP_X,                  32
.equ ARG_IP_X,                  36
.equ ARG_LIM_H,                 40
.equ ARG_LIM_W,                 44
.equ ARG_FP_Y0,                 48
.equ ARG_X_CORRES,              52
.equ ARG_WAVE_SHAPE_HY,         56
.equ ARG_WAVE_SHAPE_Y_CORRES,   60
.equ ARG_SRC,                   64
.equ ARG_MODE_X,                68
.equ ARG_TEMP1,                 72            # y
.equ ARG_TEMP2,                 76            # pointeur sur fc aff
.equ ARG_TEMP3,                 80
.equ ARG_TEMP4,                 84
.equ ARG_TEMP5,                 88

.text


/*==================================================================*/
/* affichage de jolies distorsions                                  */
/*==================================================================*/

/*------------------------------------------------------------------*/
/* void draw_distor_line (BITMAP *next_screen,                      */
/*                          int current_area_w,                     */
/*                          int w,                                  */
/*                          int y,                                  */
/*                          int fp_x,                               */
/*                          int ip_x,                               */
/*                          int fp_y,                               */
/*                          int ip_y,                               */
/*                          int lim_w,                              */
/*                          int lim_h,                              */
/*                          int *fp_x0,                             */
/*                          int *y_corres,                          */
/*                          int *WAVE_SHAPE_WX,                     */
/*                          int **WAVE_SHAPE_X_CORRES,              */
/*                          char *src,                              */
/*                          int mode_x,                             */
/*                          int temp1,                              */
/*                          int temp2,                              */
/*                          int temp3,                              */
/*                          int temp4,                              */
/*                          int temp5);                             */
/*------------------------------------------------------------------*/
.globl _draw_distor_line
   .align 4
_draw_distor_line:
   pushl %ebp
   movl %esp, %ebp
   pushl %eax
   pushl %ebx
   pushl %ecx
   pushl %edx
   pushl %esi
   pushl %edi
   pushw %es
   pushw %fs

   mov   ARG_MODE_X(%ebp),%eax    # mode x ou pas
   cmp   $0,%eax
   jne   set_mode_x_fonc          # oui
   mov   $linear_putpixel8_for_distor_line,%eax
   jmp   skip_set_mode_x_fonc

set_mode_x_fonc:
   movl  ARG_NEXT_SCREEN(%ebp), %edx               # reload edx = bmp
   movw  BMP_SEG(%edx), %es
   movl  ARG_X(%ebp), %ecx               # ecx = d
   movl  $0x102, %eax             # set the write plane
   andb  $3, %cl
   shlb  %cl, %ah
   movl  $0x3C4, %edx
   outw  %ax, %dx
   mov   $x_putpixel_for_distor_line,%eax
 
skip_set_mode_x_fonc:
   mov   %eax,ARG_TEMP2(%ebp)

   mov   ARG_SRC(%ebp),%esi
   mov   ARG_CURRENT_AREA_W(%ebp),%edi

   xor   %ecx,%ecx                # ecx va servir pour stocker y
main_loop:
   mov   %ecx,ARG_TEMP1(%ebp)     # y dans temp1

   call  ARG_TEMP2(%ebp)          # affiche le point

   mov   ARG_TEMP1(%ebp),%ecx     # ecx=y
   mov   ARG_WAVE_SHAPE_Y_CORRES(%ebp),%eax #eax=wave_shape_y_corres
   mov   %ds:(%eax,%ecx,4),%eax   # eax=wave_shape_y_corres[y]
   mov   ARG_X(%ebp),%ebx         # ebx=x
   mov   %ds:(%eax,%ebx,4),%eax   # eax=wave_shape_y_corres[y][x]
   mov   ARG_FP_Y0(%ebp),%ebx     # ebx=arg_fp_y0
   mov   %ds:(%ebx,%ecx,4),%edx   # edx=arg_fp_y0[y]
   add   %eax,%edx                # edx+=eax
   mov   %edx,%ds:(%ebx,%ecx,4)   # on memorise en ram
   neg   %edx

   # a ce stade edx contient -reste_y

   mov   ARG_FP_Y(%ebp),%eax              # eax=fp_y
   mov   ARG_WAVE_SHAPE_HY(%ebp),%ebx     # ebx=wave_shape_hy
   add   %ds:(%ebx,%ecx,4),%eax           # fp_y+=wave_shape_hy[y]

   mov   ARG_LIM_H(%ebp),%ebx             # ebx=lim_h
loop_while_1:
   cmp   %edx,%eax                        # fp_y<-reste_y
   jnl   exit_while_1
   add   %ebx,%eax                        # fp_y+=lim_h
   sub   %edi,%esi                        # src-=current_area_w
   jmp   loop_while_1
exit_while_1:

   add   %ebx,%edx
loop_while_2:
   cmp   %edx,%eax                        # fp_y>=-reste_y+lim_h
   jnge  exit_while_2
   sub   %ebx,%eax                        # fp_y-=lim_h
   add   %edi,%esi                        # src+=current_area_w
   jmp   loop_while_2
exit_while_2:

   mov   %eax,ARG_FP_Y(%ebp)               # on sauve fp_y

   mov   ARG_FP_X(%ebp),%eax               # eax=fp_x
   mov   ARG_X_CORRES(%ebp),%ebx           # ebx=x_corres
   add   %ds:(%ebx,%ecx,4),%eax            # fp_x+=x_corres[y]

   mov   ARG_LIM_W(%ebp),%ebx             # ebx=lim_w
loop_while_3:
   cmp   $0,%eax                          # fp_x<0
   jnl   exit_while_3
   add   %ebx,%eax                        # fp_y+=lim_w
   dec   %esi                             # src--
   jmp   loop_while_3
exit_while_3:

loop_while_4:
   cmp   %ebx,%eax                        # fp_x>=lim_w
   jnge  exit_while_4
   sub   %ebx,%eax                        # fp_x-=lim_w
   inc   %esi                             # src++
   jmp   loop_while_4
exit_while_4:

   mov   %eax,ARG_FP_X(%ebp)               # on sauve fp_x

   mov   ARG_TEMP1(%ebp),%ecx    # ecx=y
   incl  %ecx                    # y++
   cmp   ARG_H(%ebp),%ecx        # y!=h ?
   je    the_end
   jmp   main_loop

the_end:

   popw %fs
   popw %es
   popl %edi
   popl %esi
   popl %edx
   popl %ecx
   popl %ebx
   popl %eax
/*   movl %ebp, %esp*/
   popl %ebp
   ret                              # retour au c

/*------------------------------------------------------------------*/
/* affichage pour bitmap en mode x, golee dans allegro              */
/*------------------------------------------------------------------*/
x_putpixel_for_distor_line:

   movl ARG_NEXT_SCREEN(%ebp), %edx               # edx = bmp
   movl ARG_X(%ebp), %ecx               # ecx = x
   movl ARG_TEMP1(%ebp), %ebx             #ebx= y
   movl BMP_LINE(%edx, %ebx, 4), %ebx

   movl %ds:(%esi),%eax                         # al = color

   shrl $2, %ecx                 # divide x by 4
   movb %al, %es:(%ebx, %ecx)    # store the pixel

   ret                           # end of _x_putpixel()

/*------------------------------------------------------------------*/
/* affichage pour bitmap lineaire, golee dans allegro               */
/*------------------------------------------------------------------*/
linear_putpixel8_for_distor_line:

   movl ARG_NEXT_SCREEN(%ebp), %edx               # edx = bmp
   movl ARG_X(%ebp), %ecx               # ecx = x
   movl ARG_TEMP1(%ebp), %eax               # eax = y

   movw BMP_SEG(%edx), %es       # segment selector

   movl %ds:(%esi),%ebx              # bl = color

#   movl ARG_NEXT_SCREEN(%ebp), %edx               # reload clobbered registers
   movl ARG_X(%ebp), %ecx
   movl ARG_TEMP1(%ebp), %eax

#   WRITE_BANK()                 #  select bank
/* Bank switching macros. These should be called with a pointer to the  */
/* bitmap structure in %edx, and the line number you want to access in  */
/* %eax. Registers will be unchanged, except %eax will return a pointer */
/* to the start of the selected scanline.                               */

   call BMP_WBANK(%edx)
   movb %bl, %es:(%eax, %ecx)    # store the pixel

   ret                           # end of _linear_putpixel8()


