/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : viewport.c                                       */
/* contenu       : gestion de l'aire de jeu et du page flipping     */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "area.h"
#include "alleg2.h"
#include "config.h"
#include "gfxmode.h"
#include "palette.h"
#include "viewport.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

#define VIEWPORT_SCALE_W 76800
#define VIEWPORT_SCALE_H 57600

int PAGE_FLIP_H=0;
BITMAP *NEXT_SCREEN=NULL;

static int VIEWPORT_X=0;
static int VIEWPORT_Y=0;
static int VIEWPORT_W=0;
static int VIEWPORT_H=0;

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
void rect_for_viewport (void)
{
 rect (screen,VIEWPORT_X-1,VIEWPORT_Y-1+PAGE_FLIP_H,
      VIEWPORT_X+VIEWPORT_W,
      VIEWPORT_Y+VIEWPORT_H+PAGE_FLIP_H,
      MENU_FG);
}

/*------------------------------------------------------------------*/
static void init_viewport_size (void)
{
 if (CONFIG_VIEWPORT_SIZE>=8)
    {
     VIEWPORT_W=VIEWPORT_SCALE_W;
     VIEWPORT_H=VIEWPORT_SCALE_H;
    }

 if (CONFIG_VIEWPORT_SIZE>0 && CONFIG_VIEWPORT_SIZE<8)
    {
     if (VIEWPORT_SCALE_W*CURRENT_AREA_H
        <VIEWPORT_SCALE_H*CURRENT_AREA_W)
        {
         VIEWPORT_W=(VIEWPORT_SCALE_W*(5+CONFIG_VIEWPORT_SIZE))/12;
         VIEWPORT_H=(VIEWPORT_W*CURRENT_AREA_H)/CURRENT_AREA_W;
        }
     else
        {
         VIEWPORT_H=(VIEWPORT_SCALE_H*(5+CONFIG_VIEWPORT_SIZE))/12;
         VIEWPORT_W=(VIEWPORT_H*CURRENT_AREA_W)/CURRENT_AREA_H;
        }
    }

 if (CONFIG_VIEWPORT_SIZE<=0)
    {
     VIEWPORT_W=CURRENT_AREA_W;
     VIEWPORT_H=CURRENT_AREA_H;
     while (VIEWPORT_W>SCREEN_W
           || VIEWPORT_H>SCREEN_H)
           {
            VIEWPORT_W/=2;
            VIEWPORT_H/=2;
           }
    }
 else
    {
     VIEWPORT_W*=SCREEN_W;
     VIEWPORT_H*=SCREEN_H;

     VIEWPORT_W/=VIEWPORT_SCALE_W;
     VIEWPORT_H/=VIEWPORT_SCALE_H;
    }

 VIEWPORT_X=((SCREEN_W-VIEWPORT_W)/8)*4;
 VIEWPORT_Y=(SCREEN_H-VIEWPORT_H)/2;
}

/*------------------------------------------------------------------*/
BITMAP *page_flip (void)
{
 int old_h,new_h;
 int flip_allowed=1;

 #ifdef ALLEGRO_WINDOWS
   flip_allowed=0;
 #endif
   
 if (CONFIG_PAGE_FLIP && flip_allowed && VIRTUAL_H>=(2*SCREEN_H))
   {
    if (NEXT_SCREEN)
       destroy_bitmap (NEXT_SCREEN);
    else
        init_viewport_size ();

    old_h=PAGE_FLIP_H;
    new_h=old_h ? 0 : SCREEN_H;

    scroll_screen (0,old_h);
    set_clip (screen,0,new_h,SCREEN_W-1,new_h+SCREEN_H-1);

    PAGE_FLIP_H=new_h;

    NEXT_SCREEN=create_sub_bitmap (screen, VIEWPORT_X,
                                           VIEWPORT_Y+new_h,
                                           VIEWPORT_W,
                                           VIEWPORT_H);
   }
 else
     {
	  PAGE_FLIP_H=0;
      if (!NEXT_SCREEN)
         {
		  if (flip_allowed){
			scroll_screen (0,0);
			set_clip (screen,0,0,SCREEN_W-1,SCREEN_H-1);
		  }
          init_viewport_size();
          NEXT_SCREEN=create_sub_bitmap (screen, VIEWPORT_X,
                                                 VIEWPORT_Y,
                                                 VIEWPORT_W,
                                                 VIEWPORT_H);
	  }
     }
 return (NEXT_SCREEN);
}

/*------------------------------------------------------------------*/
void last_flip (void)
{
 if (CONFIG_PAGE_FLIP)
 {
  set_clip (screen,0,0,SCREEN_W-1,SCREEN_H-1);
  if (!PAGE_FLIP_H)
     {
      blit (screen,screen,0,SCREEN_H,0,0,SCREEN_W,SCREEN_H);
      scroll_screen (0,0);
     }
  else
      PAGE_FLIP_H=0;
 }

 if (NEXT_SCREEN)
   {
    destroy_bitmap (NEXT_SCREEN);
    NEXT_SCREEN=NULL;
   }
}


