/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : rules.c                                          */
/* contenu       : choix des regles de jeu                          */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "advanced.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "menu.h"
#include "rules.h"
#include "sound.h"
#include "time.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static void write_time_setting (DIALOG *d)
{
 char *str;

 str=d->dp;
 start_play_time();
 write_time (TIME_LEFT,str+8);
}

/*------------------------------------------------------------------*/
static int slider_time (void *dp3, int d2)
{
 DIALOG *d;

 d=dp3;

 CONFIG_GAME_TIME=d2;
 write_time_setting (d);
 my_textbox_proc (MSG_DRAW, d, 0);

 play_click ();

 return 0;
}

/*------------------------------------------------------------------*/
int rules_options (void)
{
  int *temp;
  DIALOG d[12];
  int i,choix=4,retour=0;
  static int y_pos[4]={0,1,2,4};
  char time_str[14];
  
  strcpy(time_str,"Time    00:00");

  for (i=0; i<3; ++i)
      {
       standard_button (d+i+4,0,y_pos[i],2,5);
       d[i+4].proc=my_textbox_proc;
      }
  for (i=0; i<3; ++i)
      {
       standard_button (d+i+7,1,y_pos[i],2,5);
       d[i+7].proc=my_slider_proc;
      }

  standard_button (d+10,0,4,1,5);
  d[10].dp="Advanced";

  quick_buttons(d);
  d[4].dp="Cursor speed";
  d[5].dp="Army size";
  d[6].dp=time_str;
  d[7].d1=2;
  d[8].d1=32;
  d[9].d1=16;
  d[7].dp3=&CONFIG_CURSOR_INCREASE_SPEED;
  d[8].dp3=&CONFIG_FIGHTER_NUMBER;
  d[9].dp3=&CONFIG_GAME_TIME;
  for (i=7;i<10;++i)
      {
       d[i].dp=NULL;
       d[i].dp2=slider_int;
       temp=d[i].dp3;
       d[i].d2=*temp;
      }
  d[9].dp2=slider_time;
  d[9].dp3=d+6;
  write_time_setting (d+6);
 
  d[11].proc=0;

  while (retour==0)
        {
          choix=my_do_dialog (d,choix);
          switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_RULES);
                  break;
             case 10 :
                  retour=advanced_options();
                  break;
             }
        }

  if (retour>0)
    retour--;

 return retour;
}



