/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : gfxmode.c                                        */
/* contenu       : gestion des modes graphiques                     */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "disk.h"
#include "gfxmode.h"
#include "startup.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int need_to_change_mode(int res1,int res2,int flip){
	if (res1==res2 && !flip)
		return 0;
	else
		return !0;
}

/*------------------------------------------------------------------*/
int set_resolution (int res, int flip)
{
 int ret=1;
 int num_try;
 int nb_try;

 #ifdef ALLEGRO_DOS
	static int GFX_MODE_TYPE[]={GFX_MODEX,
								GFX_MODEX,
								GFX_AUTODETECT,
								GFX_AUTODETECT,
								GFX_AUTODETECT};
	static int GFX_MODE_W[]={320,320,640,800,1024};
	static int GFX_MODE_H[]={200,240,480,600,768};
 #endif

 #ifdef ALLEGRO_WINDOWS
	static int GFX_MODE_TYPE[]={GFX_DIRECTX_OVL,
								GFX_DIRECTX_SAFE,
								GFX_DIRECTX_ACCEL,
								GFX_DIRECTX_ACCEL,
								GFX_DIRECTX_ACCEL};
	static int GFX_MODE_W[]={640,640,800,1024,1280};
	static int GFX_MODE_H[]={480,480,600,768,1024};
 #endif

 #ifdef ALLEGRO_UNIX
	static int GFX_MODE_TYPE[]={GFX_SAFE,
								GFX_AUTODETECT,
								GFX_AUTODETECT,
								GFX_AUTODETECT,
								GFX_AUTODETECT};
	static int GFX_MODE_W[]={320,640,800,1024,1280};
	static int GFX_MODE_H[]={240,480,600,768,1024};
 #endif

 nb_try=0;
 while (nb_try<5 && ret){
 if (nb_try==0)
	num_try=res;
 else
	 num_try=nb_try-1;
 nb_try++;
 ret=set_gfx_mode(	GFX_MODE_TYPE[num_try],
					GFX_MODE_W[num_try],
					GFX_MODE_H[num_try],
					GFX_MODE_W[num_try],
					flip 
					?	GFX_MODE_H[num_try]*2
					:	GFX_MODE_H[num_try]);
 }

 if (!ret)
    {
     set_palette( black_palette);

     if (SCREEN_W>=640)
        {
         font=BIG_FONT;
         set_mouse_sprite (BIG_MOUSE_CURSOR);
        }
     else
         {
          font=SMALL_FONT;
          set_mouse_sprite (SMALL_MOUSE_CURSOR);
         }
    }

 return (ret);
}


