var button_about="data:image/png;base64,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";var button_close="data:image/png;base64,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";var button_debug="data:image/png;base64,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";var button_download="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAAAAADFHGIkAAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAHfSURBVBgZbcG/axNhGAfw7/O+z93lzmtMSlJbkia01F8dpFQUnYqCWNFkUkQ6dRDBqf9AB0EQhW51FRcXfw0ijnZxcKkILS5KaoOJTUxik1iSvHe516Ta4uDnQ/dAIEF9APQe8LoQhmH1GCwQ+J5qd5TyuwFrLdhyHHtoUGx3o1T/bkjSQTdgCDZtN5J+97JyiErh2Uz+J+muDyY2nYGEuD1ycWxUFDc+vLibyge+77Nky44Xl2Yz01GXdhrrrxZvTHlKCWYj5Dr3r86dtQCY0UQs9Hgp3GlLOW27iYej1y9Y2CWSVH5++VdHMRtWaWP+JC9+Rl9m7sSptZxtSpbSyifHh8Stc18AZK8hfjz9aaYmBLG9mjg6gOTKBJB9ZsI4nFolSQwa3kzZqoXI2/OTT1VLO8LdShbAhcpaq/q+4j0pGseMS97pGSu/xcsHWxSHsGJT43LwThHAmYUcvn38SgoCCGS9VmnurEwA2TfFZvVH3VQAA9CNmhOpNV9fmXy0XJCNatkFQHGAnOBIONRN3Yw+yAvVyPntAKA4ABYHRgxGGpvke6Vt2QFAMfSEQMOm1gTyykq20EMx9LEZSNuiTltJ5aOPYvjDFCAKoJXGLsZfCiBo7GPCPwj7eAz/9xv4dbL62zagSwAAAABJRU5ErkJggg==";var button_fullscreen="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABoAAAAYCAAAAADB6bIZAAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAHmSURBVBgZdcE/aBNRHAfw7++9d5e79JI2McVIFGzFhnaxoK0dRRCFTuoiuggi0km6Kjj5Z3DXOksXcRVUFNzEOjgUobSlaEzEUFLbJne5vHt/TFLs1s+HnuAgYpkRF47ruI5gsFolUiaJMsZCwDLuer7vuUM5Hm+247jdhjXWWAHijjcQ5I5Ul5b+js2M+hVB0Foby09x1w8Gj0fzPzPlydTay40LXGmjtbGCCzcdlBa/XJmd8LjaffPh9oOiUjKB4WfcdKb07uutO9OHMkF2ePxY9GLWJIlShk87QU4/u3x3hKHHH0mvfrzYkjJRzEmlso/PXju6uNAE8Hph+/y55veMKxgYF+52NDaF+3MNAA/nfnlXT7wPHAYIIZxGpkS40XhOwKWZAiaKy1JwsoLYwHr2pItHGNoBvk0Cbo55BGtE20QR7/zh6AvrACkWh3GixCsg4J86hL7VNVBSk0+bAAS6WpU8fe5cN8DbyunMTkMk6BIArA7rgyv1e3ng5vpUq7blSXTRMMB8XS6Os606UGatleoPP0SXAGAS+xuj2WoIxNmNzYofoocK6ErL4LBjCJbpTo1LhR4qoCdFlHcYjIl2udToowL6WApkDRGMtNgjsMe0wTkpbbFPEP4zBgBhnxjBQf4B4y7GP+XMWx4AAAAASUVORK5CYII=";var button_higher_quality="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAMAAADXqc3KAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAA3XAAAN1wFCKJt4AAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAcVQTFRFAAAAAQEBDw8PERERExMTFBQUFRUVFhYWFxcXGBgYGRkZGhoaGxsbHBwcHR0dHh4eHx8fICAgISEhJSUlJiYmJycnKCgoKSkpLCwsLS0tLy8vMDAwMjIyMzMzNTU1NjIyNjY2OTk5Ojo6Ozs7PT09Pj4+Pz8/QUFBQ0NDRERERUVFR0dHSEhITU1NTk5OUVFRUlJSVFRUVlZWV1dXWVlZWlpaW1tbXFxcXV1dXl5eX19fYGBgYWFhYmJiY2NjZGRkZWVlZmZmZ2dnaGhoaWlpampqa2trbGxsbm5ub29vcHBwcXFxc3NzdHR0dnZ2d3d3eHh4eXl5enp6e3t7fHx8fX19fn5+f39/gICAgoKCg4ODhISEhYWFhoaGh4ODh4eHiISEiIiIiYmJioaGioqKi4eHjIiIjYmJjoqKjo6Oj4uLkIyMkJCQkZGRkpKSk5OTmJiYmpqanp6en5+foaGho6OjpKSkpaWlpqamp6enq6urra2trq6usLCwsbGxs7OztbW1tra2t7e3wsLCw8PDysrKy8vLzc3Nzs7Oz8/P3Nzc3t7e4ODg4uLi6Ojo7e3t9vb2+Pj4+fn5+vr6+/v7/f39////TtIKPgAAAcRJREFUGBltwT1rU2EYBuD7ed6Pk3NykpyQNKWikVZFKDiJVVy6CCIu/gJdnfwjLs5CXSx06yyCYKFVqkMnpSYqBkRCmxKTpklzzvthYiE4eF30EAzBRMQEwDvvvbNwkPvMSisV6JwSsNlpOs6yNHNOOhJS5cJiMcIQEYb9/gjOWSfBUodxOfmwe1zBUeHmStAl74yVJFUQ19zTc7eWijj+9mXrcQ3WGiMu6DCutV6u3L9ajeNS/Uq6Ob8wNsaKehRVgherdyo5KVjq6Lx7dZvHNhMXw3x1vX63IvAX58qHuzdO0pSlDDuD5SL7hsMUJcvDTiglkyi05hal33i25jAlF6utgiBmwY1ySW1sY2/Ntd/+3LJJ0mDBElzsLPH6ewB7z+feXGptP4k/Fxmy09s33eblVQIw+IhHO69/dM2mzkT3oBdQ7noUTBR+ff/akurAHLU7EjDBsP1OW0x4lPPXmifiFJAAqD86LDlHAOOe2Rn18wBIAxzSvFYewINPTZO1/cgBpAFon0+EgAfBmd6AUgCkMBF6kQgPEOxvSyNMkMKUDIzSAjZL5dhgihTOaAZ7D5fiDCnMEDxmJOEfhBm5gP/7AwRHsyptXrMFAAAAAElFTkSuQmCC";var button_minimize="data:image/png;base64,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";var button_muted="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAAAAADFHGIkAAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAHmSURBVBgZbcE7aBRBHAfg38z8Z2/3NqdJ7i7kfJ8ogshFSEBEDKQQYymigoVYGQxYWYgSbAzYWCqijQgq+EAsBEOaKD5SqCgklaAxD18Qcg/v9nZudmdcYuzyfewKVkdTjBNJRzpScJg4amkV6ciAjOCUcj3PdbJrUF9UYUhNa21Mlgnp+W3d/sLEpNmze0v4Q8DaGKIkXT/TvvXTyIKzs1h+c6urTxljrCVGKS9TuKBOnNnOYWdujD0bhYm0ED2uv3bjpc6h8+tJCJEb8OcfHA4iaziXbu6tPnjaQ2KxlTo1KMbzniQunFR0Z++wROJjXwA51P84dKXkXKTmu3pySNzbNwtM927o/uo6RFykX7X1MjydnHgH8p4MX9v24sMOEgTe/rm4Cxi7CWQfjt4fLzUK7zOMk2oELc6a1gClu8eyLzubDa7DoMnycGzhwDr7+tGRc4O1qxJs6fksKRCg0/UvgnVc9/sjlMHszB9HARywvLZUVperF48C9Vqt8rssDEAAFP/ujByfHji5/2wtxuIvrgGwPIB0c5M7V+I4tPl2GFa/eQEAkQag02WR10pN6blK5acbWAAshwRzDXUIBhtXlQgtEiyHZSRtgnPoCMsI/0QR44LHLYsVxPCfMQAYVlARq/sLVV/Buo2dT7cAAAAASUVORK5CYII=";var button_pause="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAAYCAAAAAAw4umUAAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAGoSURBVBgZbcE/a1NRGAfg33vOe+7NvTfGxKaawajFQvEftGBbcDDgF1AcXC1EwclB0KGDOEg7OOkm1LGfwQ4FXRw6KBatKEKtRm0Kmja3TXJvzsk52kZw6fPQLPbBH5iVpzxmAdszXd3VxoCF9DNB4PuHcrTzK02STkKwLL0gPFDKfnuxlE6MHu+uS0HoyYkomz+5Mv3dPzMcL83lx7V1kOwHuaP342u3RoRztacLz2cIZOTFg+WHfnX6mGJWA5V8bf5qCikvld6/uXIvwB4+u/luZzQVIuPmxm97+IdvXFhshSF764XTJTz6gbuNZzhXDSpvV08Rh6+zY8D8MqbWHuNyVU4eXh4zIv/xyHn8R0ODtYi5rSVazgJIAOi0A92J+YGoPznhGgBeAfj0cnt1807COmp/9skAaALo1L/GmRQMETd/e4WyjDA8MNLd2thSFoxE/VSlyethI7xZwcpavQeABhGk5UKGsCdpfglbABWBKC3mFBwIurXhtx1ARYB8xwUprHPNVCQOABXxFyvnHIjIaOxi7DKGhISxDn1M6LMWAKGPh7CPP++inX6BDR0/AAAAAElFTkSuQmCC";var button_play="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAAYCAAAAAAw4umUAAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAGtSURBVBgZbcE/aBNRHAfw7++93927PzGmNtYo/itVBP9ABVtBsJGCm4M4FHcdBIujQweFUtSts9K14CoIOhR07VIQrRSVQo0lBqptrrnkLu/uPRuz9vOh59gHf2V2XMdlFjB51tVdnWVgIZXn+0odKlJrK02STkIwLF0/OFAp/PywnI6PnurWpSDkcjwslEZWZ36pC2ei5YXSmDYWkpVfPP4kmnpwTlhbe/n+3TMCZXLi4Ik5dW/mpMPsDFZLtcU7KaScrHxZuf3Yx398cftzazQVwrMLY49cAC+2APD9a0txEAi3PnC+gj0rN34D8KtH1wMlgrXCZfTY1eomIK8OffIcUVo7cgU9Bt8mNkDDh2shc1tLxBZADqxf/zjUge5EdEwM3jxtAbxZAu5Oprtvf6iEddj+rsgCOTD19HW2EXkpGCJq/nEtYHBr9lWWN3YcAxlaTgx3k/Tv2fn53aS+GdscDO03t+ERLk3PtZA0G0EMUBkI03LRwcPFHei4odoWoDJAyvKAdLS1zVQkFgCVsYcday2IKNPoYfRkGQmJzFj0MaHPGACEPh7GPv4Bgnmor3QiqDcAAAAASUVORK5CYII=";var button_stop="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAAAAADFHGIkAAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAG2SURBVBgZbcE/jAxRHAfw73vvN7Nv9p+9dRuLk9iIE1dRcAkFURDZamn0JHSiUepEoaVQX6tViCsoNHeJxhXHkTiy4XKx3JnZnZn33u+ZXZfT3OcjHmFvtCqJwiAMSMI7a/LcGMvsQZLCUhTpsDGl0s1Rmo5G8OzZUxDoSqXZ7i8tD2bnj5XXScA5x16d09V6J7n3pXbiVGlt4fMV4Rw7x54iXZ1ZWLrWndPKbr9YvPWgbW1uwOpy5eDL5Zu3z+6vVeutk0eGz7psjLWsuvX8ae9uR2Is6pQ/Ll6N89xYqcsP52/MYIe6dDFeqYUkQfr3cPYM8OQTChd6+vrbV3cCCVD4rXZYAM/fYKyHufZ7Q0p4WR7Uj4f4L5ySWsAzxYnKfijkmIgTYWWapMbS/ap6nQkMMPFhxfTzx38AEBB/bQo/xMTm6tZPMigQvEs29vlGKwBw1MT9QZSiQBhV1rVVp89XUXj3fWMrYhREC6FvHNLKAxDeJGuloUeBPLLyr/xAwAJeuqwfpIwxMQ2gJEQzkGAeblPmMCGmUZAlCM9CgDPsIIzxCEoJy4xdJPAPMwCBXdTB3v4CXaW5Fw2FHHQAAAAASUVORK5CYII=";var button_toggle_plugin="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABoAAAAYCAAAAADB6bIZAAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAHeSURBVBgZdcG/axNhGAfw7/O+b+5X7pqatkISjYMdOkhtHYoVFwf7NwjFTUFxcik41qWgSweLq4ujiyCI4uAiWuggoqJg5WqjSGmbS7jkLnfv+3ihRbv4+dAKCFQQBAIYbLgABtT3WMqSZdu2VZIEnQ/SQp5rsDIMaTmeFzTspD1STn92+oJZw7AyJC3HD+pqbSM9FsmZ6+M/iI3WDDnLthtUT72+e/rSldtnT/bX+Hyea6MZCqLklhtLWFyeIMxxZ/nlqwdplg1yyFlZDhrPw8V7PgEgZ0F/3LwYZxlDQJbK7afzdwQO0K0L62HFUqKgrMrDMzed+zOFxwDE0rlVzypJqViUktb0PFrvAeygMFl/21VCGEFCRs64wD885u8rKUgY0PFyxTCGVqamHmk9Vh5VxJDNbvtF5Bt3/R2AeHe3Mvj8ZvOL2YliGYXfdFwdbS5cvdH9AOBEsP91iz+F29sKgKbe72cuLk+gkEQ6zg0KioDEa9mTwByG+u2w5aUoUD0D3EGtFuDa9B7wZEP/2nJ6KFA9A+D3mp4z4gLotPuhE2OI6gMAwk2rPhGxQbxnpTmGqJGiQDYZ11Em7gnRxwFFGOJEqiQBIDONQwqHtAaEwRGKCH8x4QhVw//8AWnJxs5s3pbIAAAAAElFTkSuQmCC";var button_toggle_plugin_with_logo="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJIAAAAYCAYAAAARUKQwAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAA2rSURBVGje7ZmJc1VVEsbfH+ECCDqFSuECmqgII4sIQiAsCWYXQthJIIRNlrAIJoCAbJZgUEB2WRQQRXZBGDWIjhpHRK0ZVxx0HCkRwVHgzPc7886rw83NgjIIVblVXe/es3Z//XWfvvdFiouLj06dOtXUSI38VoFDkcmTJ5v09PRKJSMj4xwJ66tqjctBgnZWV6pa7/fqcqnjBociEyZMMCkpKRVKamqqSUtLi03injYnPPttla11KYtvZ2ZmZkyCjvT7gnj4a/1WbILY+s+XKnZwKDJmzBjTrVu3UHnggQesAQCWlZVlBWCdYS5yHKAsypzK1vOlonEXU5wu2AM5evToYXJyckzv3r2t9OzZ07Yh2dnZplevXradX57BxLfdx8wRsTrYBHXxseX5UsIsKHAoMnLkSJOUlFROkpOT7SBAAJBOnTpZ8aMUEP0oBSzmIW4N94sEieSPvRByvmu5/dEb/SFHXl6ele7du5sBAwaYoUOHmsGDB5tBgwaZgoICe09f//79TX5+vunbt6999p0NJrSxbpcuXSxuVdnrY8T8Bx980N7ziw/+H3hdKIFDEcDp3LlzOQEAlHakWfT002bts89agwAJ4Lt27WqmFBWZAgHqUi8L0x4U1mKMO/e5h6iMZy8n/hy/vSqpzrywMeyPoyARpEhR3/KlS81fS0vNOtk7ODfXEoqoy5LOTy5YYN5+4w2zecMGkycy4eh+/frZoAIbMHCZe/KkSaakpMQ0a9bMtofpFsQJTJib2L69eXbVKpPQtq3F32FVlZ0V9Yf5+EIJHIoQaYmJieWEKML5AAVxdm/bZgHESNI9YLWXsQfVtm7NGqs4DgkeYS79uahqe999VpgPGf1I8+f6JHMKs4efLd28YLbjmbH+vOD6/jzsGzhwoMkVIX4+dcqcOX3aHHjtNXP8++8N16oVK0y+stR/fv7ZnP71V1O6f7858cMPtm+FSMd8iOiChPtu2vfIkSOmc0KCPQIdkVyQOjvC9AGXnsL9B+0PsVnTjQnaEAzWsH72xJ9hfr4QAocipOgEGRuUDh06WIMhEsRxRIIAPGMsALZr184uBljuiHN1BsI9cxyY7xw8aF5+6SUb/ezNGgDl1mNtN88B6IDinjZ0Qtx+bn3mOZK77Ig457Am/a62ccdynz59TJLAPn7smHl93z6TrvEQK0Pkn/LII8ZdO4VBRrQvVb9zZs2y7fnR49DpgK47d+40GcpgHH+sz14uMHCwO76Yg7gjzNVq/LZu3dra6+vqajV+XTnhMmHQRheo7ImP8GmYr30huzK+qnG+4McIhSNkCArZBiY74jgiOWI5I+6PZhgUZy2OAdifochIl6AUIMNaxpSJSKzVRYYh7dq0saTK1RFigVYbcxM7dowRw0W627e99MOhpH2ciiGJAqmHwE7W3jgBXdwLAuugdwcZnal5nTSWMYCGk6l7CqQfV5p0GD16tK2NRo0aZXV7TzqfPXvWpEqvwsJC20ddgC7/OHzYvLhxo9UBO1nr9ttvt5KCPcKQPchS7s2PgEG/jrKR/bpKZ2xnL2xEEoR/R9nZSXgwljVo7yjdLT7RQHdFP2NYFxuz5BdnI7ZDUHwJkfBrmL8R9P/xxx/NQdmLDysaFxT2jsDgNnJmUNrKSRiKA1HUz0guojHk/XffNZtULwAC0Zet9q+/+CIWxZ9+/LF1Os4B7LK33jL+tWTxYkuyTBn/8QcfxNo5YmY++qhJExjMQ5IU6UtUq3H0cI0aMcKSYeK4cebUTz/F5u5RNkgWcAADQZPlpBLVNqdOnrT9kGL/nj32+BkyZIglzLRp0+yeAA45sRGbIM2q5cvNd0ePWoewHn04lqDZsmmTOSQMcBjk6iZM3lBWO3PmTMyOJx5/3HSTDujKmpB6qAj372++ien8t3fescTDTsg4QAThgvjokK69wePE8eMxG8ju2MCa7Ltk0SJ7/HKx/+4dO0yXaEBy5EEk/Brmb2w+Hl2bCzIxPmxsUOBQhKgihQblPmUZ0hbgMdAnEs+wH+U+fO89G5EYCxDHvvvOEmK0QB0/dqz56rPPLLEyFYkABJHeF2hjHnrISipFuOadPHHCfHLokMmnuJWTqLu45ur4gKCQYo2KTwBc/swzJldRkKSoyZEeXIA2RHPnzZljSbVl82brFEDe9Pzz5vQvv5jZjz1mcqQ/R9GXn35qhSNtkori6XIS8zgCiHxXNEMc9vvX119be/0+1qboPlxWZklFxoJwR7/80gyVzuw1QwT9Rc5dpjXIHsOHDzfDRF5L+F27TL7mjVSxWvb225YkEIKsN1AYcHUX/swhELAdsvSTDsOE5bvCsrdITZbb8fLLdp/p2q+nfApR//nVV+bvH31kEpQ18DO2QaSgr8HJJ5G73nzzTZvBwvjhC2tHAKVly5bl5N5777Vpy72C+sU2JHKvt0QjROKtZrjA48K5OAdxR8YgKUt1zzGxXTXSQyLR+PHjzQhllfUiDYVtihwxR0SYO3euJc/u7dvNryJAWvRD3Uml3c3RY4QsAnlXKltQ+BLxfGElK6xctsycVUQyL1v6cs0RiSAy+9nMoewG8I9IRz7zOyIRhe6N1B1/y5YssUQiA2O/64NUEIlgguhzZ8+22TJTfejHPthRpD0gAYHGvO+//dYW8wQpmRrskrXmt9oDLIcNG2byRFIuSJEmXCjyKeyxnSwKcfEPv71EWK6pqufA2NlIkDJvrHQhi3JckUF8PxMMYSRy14EDByz5wjjiBB5EOJubN29eTlq0aGHZxvGGAo5IPLvil4x1SNkFMDknOR5wBvPcR7y2UpxrokiDgyDSTkUPUYRxOOewHHFEUbxab0e+vPrKK3YuQHWWg7kABQdCbnQo1TGyV9kIY9iPqM+NOoFaYoSA5UrVWPdthr05wj6Q7ju2bLF6OCIBDH04CVsZvyyakcjSrnYgutn/BWW7DxVMtO8R8T9RNqaPPVyRn6RnLrIIRxHXSJGFff0PvhvWrzffKIuwVn/vaOsrey0O0ZcMfMYejtjjRESuLtRH0c8QrIn+1HAbtS5rkl1atWoV8zH3i5Th1q1bF5Nt8vNzzz13ThtBEcYRJ+gTqVevnrnyyisrlauuusoUKoMUT5xorr766lg79zOKi21qZgyOXLRwoalVq1ZszDV16phlyhDpAowxk0Wo+fPmxdbhd3pRkVmo1D1OCgelUNIkPt40atjQrpMgYvr7oxO6sbZrbysyMLaJCt5EOZ37u2677RybmDtLxHc2dZeDFqv+8u1zkqeoX6A6J9jHnhB1pjCgb6wywdyZM8uNi7vlFqsDR1+jm26y99QuwbUmiBBLRVrwa6NAZtydjRubVs2a2fvWclqYfzie6b/t5pvL2fi4SoOJWtfHpyIhWx3Tm+srCuC6detWOd4JHIpcd9111SJSkQCfragNEukJpfPxUUUpQKljfCLVveYas0EZq4ccxRg+XvLcJC4utvZQper1a9eaeDmbZ4S1sxTNeapRWA+QmNdJxPD3Ryd084Fqr4zI2KZ33GHibr3VPK8IG6EM4I+5W+Sk3dnUWxmAD65hRKKmWa6XgjAijdPRNF/HMffZOtLZt40i3R/TT9ma9ixlD2zhiOIY8te76cYbrT4blOEY42wgGOpfe63VbfKECefMqa1xrH+3sGQetZ+zkd/mTZva9mnaqyoiORK563zIBIci9evXrxaRZgnwtSIJgPfmvyhJQxn/jDLQFNUmjKFO2PLii+WItEtFZR/N4/meJk3MVh0nG5Qy85XqWwv0hjfcYI8IUnC2CMcb18MCjXn9RE7WhhA8c0z4RCpRpkA3H6jE+++3Y++5667/ZQ2RiGdqFYpZdNkkp9FWEs00uXprQa8wIo0VWTZK3zAiFWvNpU89ZfuuVWSuVs3Gd7JcZTH2GqOMulNHL3vl6ChjXopqF54fnTLFdFT9gT5rdJTTtktvnOBHO89NRXj26Ssy8jx7xgyb2XKU/deuXm2StYc9MRTM9D+sjM++4EY9Sds81YeVESlIovMlExyK3CAnVodIT+g4ovDypaVS7pqVK81jMs5mFhW/e/VaHSQSYwHWtTW9807zlI6y7XJcUTRa4hs1MouefNK8riKU8byFOBIxh37a+dLrE2mpMgW6+UB1VT3F2BaKSJ5raRzH0y6d/7S/tn+/dSKF+tJopilQ1tn36quhRJqkjLdN+oQRaeb06TYLuz6Ca7aOt7+odmMv9iTAuO8ve9w8yLDlhRdse2lpqVmlLFUi+/dF8aPeoe/PwsrN6amMt02B6mygRODIp7+O5hQoMHlBoZ/9ixTg/M1TMn9+hUSqiETnQyY4FGnQoEG10hdAVSYoCgDu3gfbjQk6gTafdLTVE/FI8xWt44/39apIV38+c1m7Tu3a5caE6R5cL9jn2+b38cweZNogTsF1G1x/vfmTji72X6zsvnvr1qrnaF3Wr0ifMBvD7KqtMdMVCAu1b2VCgV8ZN+BQpKEYfcUVV9TIRRZHCptN5FA+mXzx+edmfGHhZWcLHIrcrCK2xrEXX/hr5MOyMvOS6hg+jPIth88o9VW4Xm62wKHIrSpiaxx78bMR35C2bt5sXt+716zQq/vwggJby12O9sChSOPGjWuc+wcSCrnc7YBDEf6lrnFqjfwegUORuLi4o/Hx8aZGauS3Chz6L2VoYS4wR5X3AAAAAElFTkSuQmCC";var button_unmuted="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAAAAADFHGIkAAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAHOSURBVBgZbcE/aBNRHAfw73u/37t7l2u01UtpK/6JUAQRKxjQIghO6thNOohTRcHFRQrFSXB0FF3EQURwcBAsLgVFO6godBO0Ni2WQmjSkFzu73te2rr18xEPsTdeEpJZOcpRJGHyLEnjLM0M2JBkV3uedg7uQ6cRRxH3rLU5W0HK8wdG/LWFRXPuzLHoL8HaHHRaab88ePzH3Jpzstr89HS4FhtjrGXBrlcenY2nb41L2OXH828fwGQp0YT29x++f+DmvUNMRMElf/XVVJhZI6XSwef08oyHQiNxb1yh9xVPsSTHzZ5P3lYofK+FUDMXX0daKSnJXR2eCFB4cWEFQGly5Ld2mCWVPg6cFXizuPAFfXw++HaCiSEHf1ZPAfNPsEOOj34tC8lxN0yk6FmDviiE6Mo0Cnv8Do5dfzRmW+h7SRCbdTMXg3wYbRwd5t0kAWrdsPOrnicWErCyvdlsT33YuAt02u3WRpMMICqAg3I1EBDXlu9cz9FYaYkYEBUApd6RIS2Aq0efRdHWHy8EQCUAaalp8ySOl9J6q7WuQwtABCgIbXiIBGy+FVNkURABtrGyBSmRZtjG2JFlQpLME4tdLPCfMQAEdnEVe/sHCNC9rrYO6qEAAAAASUVORK5CYII=";var button_update="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAMAAADXqc3KAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAA3XAAAN1wFCKJt4AAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAfVQTFRFAAAAAQEBAgICAwMDBQUFCQkJDAwMDQ0NDg4ODw8PEREREhISExMTFBQUFRUVFhYWFxcXGBgYGRkZGhoaGxsbHBwcHR0dHh4eHx8fICAgISEhJCQkJSUlJiYmJycnKCgoKSkpLCwsLS0tLy8vMTExMjIyNTU1NjIyNjY2ODg4OTk5Ojo6Ozs7PT09Pj4+Pz8/QEBAQUFBQkJCRERERUVFRkZGR0dHSEhISUlJTU1NTk5OT09PUFBQUVFRUlJSVlZWV1dXWVlZWlpaW1tbXFxcXV1dXl5eX19fYGBgYmJiY2NjZGRkZWVlZmZmZ2dnaGhoampqa2trbGxsbm5ub29vcHBwcXFxc3NzdHR0dnZ2d3d3eHh4eXl5enp6e3t7fHx8fX19fn5+gICAgoKCg4ODhISEhYWFh4ODh4eHiISEiIiIiYmJioaGioqKi4eHjIiIjYmJjoqKjo6Oj4uLkIyMkJCQkZGRkpKSk5OTlJSUlpaWmJiYmZmZmpqanp6en5+foaGhoqKio6OjpKSkpaWlqampra2trq6usLCwsbGxs7OztbW1tra2t7e3uLi4w8PDysrKy8vLz8/P0NDQ3Nzc3t7e4ODg4uLi4+Pj5ubm6urq7e3t7u7u8PDw9vb29/f3+Pj4+fn5+vr6+/v7/f39/v7+////io8pTQAAAdZJREFUKM9tibtrU1Ecx7/nnN+5r+Qm1zz6SH0UohGDroUGB0E3/4q6uDg4uDk46uLi6NDi6qCD4NhVEEWFhFharGBIi02bJjG9Nzfn4WApGfwsHz582H1wCM4Y4wyANdZao2FAO5yTlNKVrhTQ08l0Mp1OlTFkGCfpeWHBQwIPydEogTXaEDhJPyhGHz8MS+jlVlf8Q2aN1sQEuUFFP1tqLEcY7LY3H1S6Wislqo6fWdjdaNytzUW5/IWaej2/lGilxWUvOOe9vHN7PuMI4fjZCnt3E6lSxIWMNm40SsI+3RGy+Ki8uvdqbSA4F+Ttj+qhALuXjI8LeZ6vj/c9EpyJsDNX9fAHC9fAv/yAXy13QsE4F7JdDj2sv8FD5/nyk7GTK7Wl4Bw8PMjwSf+TisWL3JruTljmIOSg3nBL9X+rpqr3AMRoZY/66q2bUhMUHH6txHi/YoHPuPJ9rx9sKRCg3HgYOLVvhaL41YpK28MTkQAEgA1GMrw+3pQi8R43e6NBBgDLAdxniwGdN9snV2+1WnHXxubfgGOzEZG8dLHzM54ORiwFwEIA8K2IyAIM6lizGGcD5CrpCug0pYnCzAAcDm4tTHradGqkAIPFGcQww0zQIv7PX8VSuBpdtiV/AAAAAElFTkSuQmCC";var header_background="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAYCAAAAAAaUhg7AAAAAXNCSVQI5gpbmQAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAAmSURBVAjXY2xjYGC5CMR/gfgfFP/FTzOKMjAwMaBilv9YxOQYGACA4w25ovZkiQAAAABJRU5ErkJggg==";var slider_background="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAADCAIAAADdv/LVAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAA3XAAAN1wFCKJt4AAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAABRJREFUCB1jqKltYNi4cTPD06fPACCdBj8ia2hqAAAAAElFTkSuQmCC";var slider_knob="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAUCAQAAADBqR7CAAAAAnNCSVQICFXsRgQAAAAJcEhZcwAADdcAAA3XAUIom3gAAAAZdEVYdFNvZnR3YXJlAHd3dy5pbmtzY2FwZS5vcmeb7jwaAAABrklEQVQoz22RMUsbARiGv7vL9Y5y9ojcUOkQoxBjGo7kBhHEonTo0BZBkbT9BVLqT2g3u7jYFJQgEqvg5CAUsYVmCKlDKDgVrYs4mErjJCTFFK9Ph5DrhZZne9+Hb3g/QRAEDZNeYiRJkyRGLyZau2sLEWyGmGKRXUrsssgUQ9hEOoqKTdbPXzXLLPGSJcpcNf08WWxURFAwSbYKR3hYJBglgYXHEa0CSUwUQcO5nq03B0iwT4MGDfZJMEC9eT2LgyboxC+LC0QpcxZQJsoCl0Xi6IJBql6ZYJKvXUwywY8KKQzBYLhWSZHjcxc5UtQqDGMIOrH62zlc3neRZo6LPDF0QcNpPV33bdbYDFjlFuv+rxwOqqBgce/gu8E8KwHPMTg4YxwLRRBM0t8+ZXgYuvIAj+OP3MXorNtz+OwFg+wE9DPP8QxWe11BkD2teHGDZUqUKPEGnY3anhJ+oyCnr0eYoUqVKo8Y4/RVpwmU8/i733184ZAqDpv++Z1/FMT7EOEJJ0wTwdv5m4eU7ON+VG6iEid7/78Kktm+jUYfma1w2qW4Ubfg/nRXXDuc/gE0j6y40AVJmAAAAABJRU5ErkJggg==";var css_data ="body div#top_content_boxdiv.dmpi_video_playerv4 div.linterna-magica,.linterna-magica{border:1px solid #36393E!important;background-color:#000000!important;color:black!important;text-align:center!important;position:relative!important;clear:left!important;}.linterna-magica p{color:#ffffff!important}.linterna-magica-web-log-header a,.linterna-magica a{outline:0!important;}body div#top_content_box div.dmpi_video_playerv4div.linterna-magica-header,.linterna-magica-header{text-align:left!important;color:#333333!important;background:gray url('"+header_background+"') 0 0 repeat-x!important;height:24px!important;line-height:24px!important;border:solid #666666!important;border-width:1px 0px!important;position:relative!important;}.linterna-magica-logo{position:absolute!important;display:block!important;width:120px!important;height:24px!important;top:0!important;right:0px!important;margin:0px!important;background:url('"+button_about+"') 0 0 no-repeat!important;line-height:3000px!important;overflow:hidden!important;cursor:help!important;}.linterna-magica-toggle-plugin{display:block!important;text-decoration:none!important;width:146px!important;height:24px!important;position:absolute!important;right:0px!important;background:url('"+button_toggle_plugin_with_logo+"') 0 0 no-repeat!important;line-height:3000px!important;overflow:hidden!important;}.linterna-magica-update-info-boxbody div#top_content_box div.dmpi_video_playerv4div.linterna-magica-about-box,.linterna-magica-about-box{background:#000000!important;font-size:12px!important;line-height:1.3em!important;padding-top:20px!important;font-family:'Liberation Sans','Arial',sans-serif!important;}.linterna-magica-update-info-box p,.linterna-magica-about-box p{margin:1px 5%!important;padding-top:8px!important;color:#ffffff!important;text-align:center!important;font-weight:normal!important;}.linterna-magica-update-info-box object,.linterna-magica-about-box object{height:70px!important;margin-left:25%!important;position:relative!important;display:block!important;}.linterna-magica-update-info-box p a,.linterna-magica-about-box p a{color:#bbbbbb!important;text-decoration:underline!important;font-style:none!important;}.linterna-magica-update-info-box p a:hover,.linterna-magica-about-box p a:hover{text-decoration:none!important;}body div#top_content_box div.dmpi_video_playerv4div.linterna-magica-controls,.linterna-magica-controls{background:gray url('"+header_background+"') 0 0 repeat-x!important;border-color:#666666!important;border-style:solid!important;border-width:1px 0px!important;color:black!important;height:24px!important;width:inherit!important;font-family:'Liberation Sans','Arial',sans-serif!important;font-size:10px!important;font-weight:normal!important;display:block!important;bottom:0px!important;position:absolute!important;text-align:center!important;color:#333333!important;}a.linterna-magica-controls-buttons{display:block!important;float:left!important;height:24px!important;width:21px!important;position:relative!important;text-decoration:none!important;padding:0px!important;overflow:hidden!important;line-height:3000px!important;outline:none!important;}a.linterna-magica-controls-buttons-play{background:url('"+button_play+"') 0 0 no-repeat!important;margin-left:1px!important;}a.linterna-magica-controls-buttons-pause{background:url('"+button_pause+"') 0 0 no-repeat!important;margin-left:1px!important;}a.linterna-magica-controls-buttons-stop{background:url('"+button_stop+"') 0 0 no-repeat!important;width:24px!important;}a.linterna-magica-controls-buttons-mute{background:url('"+button_unmuted+"') 0 0 no-repeat!important;width:24px!important;}a.linterna-magica-controls-buttons-unmute{background:url('"+button_muted+"') 0 0 no-repeat!important;width:24px!important;}a.linterna-magica-controls-buttons-fullscreen{background:url('"+button_fullscreen+"') 0 0 no-repeat!important;width:26px!important;}body div#top_content_box div.dmpi_video_playerv4div.linterna-magica-controls-horizontal-slider,.linterna-magica-controls-horizontal-slider{top:1px!important;line-height:22px!important;float:left!important;clear:none!important;height:22px!important;position:relative!important;color:#ffffff!important;margin-left:3px!important;background:url('"+slider_background+"') left bottom repeat-x!important;}.linterna-magica-controls-slider-knob{padding:0px!important;height:20px!important;width:17px!important;display:block!important;position:relative!important;top:0px!important;background:url('"+slider_knob+"') center top no-repeat!important;z-index:9999!important;}.linterna-magica-video-download-link{background:url('"+button_download+"') 0 0 no-repeat!important;height:24px!important;width:24px!important;position:relative!important;text-decoration:none!important;padding:0px!important;overflow:hidden!important;line-height:3000px!important;outline:none!important;display:block!important;float:left!important;}.linterna-magica-toggle-plugin-header{background:url('"+button_toggle_plugin+"') 0 0 no-repeat!important;height:24px!important;width:24px!important;position:relative!important;text-decoration:none!important;padding:0px!important;overflow:hidden!important;line-height:3000px!important;outline:none!important;display:block!important;float:left!important;}.linterna-magica-toggle-plugin-header{position:relative!important;text-decoration:none!important;padding:0px!important;overflow:hidden!important;line-height:3000px!important;outline:none!important;display:block!important;float:left!important;}.linterna-magica-controls-slider-text{top:-20px!important;padding:1px!important;display:block!important;float:left!important;position:relative!important;font-size:11px!important;overflow:hidden!important;cursor:default!important;background-color:transparent!important;}body.dm_page_html_videodiv#top_content_box div.dmpi_video_playerv4 divdiv.linterna-magica-hd-links-list,.linterna-magica-hd-links-list{width:16%!important;height:auto!important;bottom:-2px!important;left:100.5%!important;overflow-y:auto!important;overflow-x:hidden!important;background-color:#333333!important;border:solid #555555!important;border-width:1px 1px!important;position:absolute!important;font-size:13px!important;padding:0px 0!important;z-index:9999!important;}.linterna-magica-hd-links-list ul{padding:0!important;margin:0!important;list-style:none!important;}.linterna-magica-hd-links-list ul li{padding:0!important;margin:0!important;list-style:none!important;line-height:1.2em!important;}.linterna-magica-hd-links-list ul li a{padding:0!important;margin:0!important;color:#dddddd!important;padding:2px 5px!important;text-decoration:none!important;font-weight:bold!important;display:block!important;background:none!important;}.linterna-magica-hd-links-list ul li a:hover{background:#222222!important;color:#ffffff!important;}.linterna-magica-switch-hd{background:url('"+button_higher_quality+"') 0 0 no-repeat!important;height:24px!important;width:24px!important;position:relative!important;text-decoration:none!important;padding:0px!important;overflow:hidden!important;line-height:3000px!important;outline:none!important;display:block!important;float:left!important;}#videoPlayer,div.sectionContent,section,#video-wAd,bleeding,multimedia{overflow:visible!important;top:0px!important;padding:5px!important}.linterna-magica-update-notifier-link{background:url('"+button_update+"') 0 0 no-repeat!important;height:24px!important;width:24px!important;position:relative!important;text-decoration:none!important;padding:0px!important;overflow:hidden!important;line-height:3000px!important;outline:none!important;display:block!important;float:right!important;right:122px!important;}.linterna-magica-web-log-link{background:url('"+button_debug+"') 0 0 no-repeat!important;height:24px!important;width:24px!important;position:relative!important;text-decoration:none!important;padding:0px!important;overflow:hidden!important;line-height:3000px!important;outline:none!important;display:block!important;float:right!important;right:122px!important;}div.linterna-magica-web-log,.linterna-magica-web-log{display:inline!important;border:1px solid #36393E!important;background-color:#000000!important;color:black!important;text-align:left!important;position:relative!important;clear:left!important;position:fixed!important;float:right!important;right:10px!important;bottom:10px!important;width:450px!important;height:250px!important;z-index:10000000000000000!important;}.linterna-magica-web-log p{color:#ffffff!important;margin:0.5em 0!important;}.linterna-magica-web-log-header{text-align:left!important;line-height:10px!important;color:#333333!important;background:gray url('"+header_background+"') 0 0 repeat-x!important;height:24px!important;line-height:24px!important;border:solid #666666!important;border-width:1px 0px!important;position:relative!important;overflow:visible!important;vertical-align:middle!important;}.linterna-magica-web-log-header p{font-size:12px!important;position:relative!important;line-height:24px!important;padding:0!important;margin:0!important;letter-spacing:normal!important;font-family:'Liberation Sans','Arial',sans-serif!important;}.linterna-magica-web-log-header a{display:block!important;right:0!important;margin:0!important;top:0!important;position:relative!important;padding:0!important;color:#ffffff!important;width:24px!important;height:24px!important;float:right!important;text-decoration:none!important;overflow:hidden;background:url('"+button_close+"') 0 0 no-repeat!important;line-height:3000px;}.linterna-magica-web-log-header a.linterna-magica-web-log-show-hide-body{background:url('"+button_minimize+"') 0 0 no-repeat!important;}.linterna-magica-web-log-messages{height:215px!important;width:420px!important;overflow:auto!important;padding:5px 15px!important;line-height:1.35em;}.linterna-magica-web-log-clone{}.linterna-magica-web-log-clone-header{font-size:20px;margin:0.25em 0!important;}.linterna-magica-web-log-clone-header a{display:none!important;}.linterna-magica-web-log-clone-messages{overflow:auto!important;padding:5px 15px!important;line-height:1.35em!important;font-size:12px!important;font-weight:normal!important;text-align:left;}.linterna-magica-web-log-clone-messages p{margin:1em 0!important;}.linterna-magica-log-to-web-message span{display:block;}.linterna-magica-log-to-web-message{border-bottom:1px solid rgb(152,152,152)!important;border-left:1px solid rgb(152,152,152)!important;padding-left:3px!important;padding-bottom:3px!important;}.linterna-magica-remote-clip-buttons{position:relative!important;z-index:99999!important;margin-bottom:50px!important;}p.linterna-magica-remote-clip-buttons a{display:block!important;right:0!important;margin:0!important;top:0!important;position:relative!important;padding:0!important;color:#ffffff!important;height:24px!important;float:right!important;text-decoration:none!important;overflow:hidden;line-height:3000px;}a.linterna-magica-remote-clip-close-button{background:url('"+button_close+"') 0 0 no-repeat!important;width:24px!important;}";
