/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.SocketConnection;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.net.SocketException;
import sip4me.gov.nist.siplite.stack.SIPMessageStack;
import sip4me.gov.nist.siplite.stack.TCPMessageProcessor;

class IOHandler {
    private final SIPMessageStack sipStack;
    private static String TCP = "tcp";
    private final Hashtable socketTable;
    private final Hashtable outputStreamsTable;
    private final Hashtable inputStreamsTable;
    private final Hashtable dnsResolution;

    private String makeKey(String knownAddress, String socketAddress, int port) {
        String knownKey;
        String socketKey = this.makeKey(socketAddress, port);
        if (!socketKey.equals(knownKey = this.makeKey(knownAddress, port))) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(16, "Target address " + knownAddress + " does not match socket address " + socketAddress + ". Indexing this pair.");
            }
            this.dnsResolution.put(knownKey, socketKey);
        }
        return socketKey;
    }

    protected String makeKey(String addr, int port) {
        String alternative;
        if (addr == null) {
            addr = "null";
        }
        if ((alternative = this.sipStack.getNetworkLayer().getDNSresolution(addr)) != null) {
            addr = alternative;
        }
        return String.valueOf(addr) + ":" + port;
    }

    protected IOHandler(SIPMessageStack messageStack) {
        this.sipStack = messageStack;
        this.socketTable = new Hashtable(5);
        this.outputStreamsTable = new Hashtable(5);
        this.inputStreamsTable = new Hashtable(5);
        this.dnsResolution = new Hashtable(3);
    }

    protected void putSocket(String key, SocketConnection sock, OutputStream os, InputStream is) {
        if (key == null || sock == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "IOHandler NOT saving socket and IO streams because some value is null.\nKey: " + key + " socket " + sock + " IS " + is + " OS " + os);
            }
            return;
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "IOHandler saving socket and IO streams. Key: " + key + " socket " + sock + " IS " + is + " OS " + os);
        }
        if (this.socketTable.get(key) != null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(16, "There is already a socket: " + sock + "with key: " + key + ". Closing it.");
            }
            this.removeAndCloseSocket(key);
        }
        this.socketTable.put(key, sock);
        this.inputStreamsTable.put(sock, is);
        this.outputStreamsTable.put(sock, os);
    }

    protected SocketConnection getSocket(String key) {
        if (this.socketTable.containsKey(key)) {
            return (SocketConnection)this.socketTable.get(key);
        }
        if (this.dnsResolution.get(key) != null) {
            return (SocketConnection)this.socketTable.get(this.dnsResolution.get(key));
        }
        return null;
    }

    public OutputStream getSocketOutputStream(SocketConnection socket) {
        return (OutputStream)this.outputStreamsTable.get(socket);
    }

    public InputStream getSocketInputStream(SocketConnection socket) {
        return (InputStream)this.inputStreamsTable.get(socket);
    }

    protected void disposeSocket(SocketConnection sock, InputStream is, OutputStream os) {
        if (sock == null) {
            return;
        }
        try {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "IOHandler disposing socket and associated I/O streams: " + sock.getAddress() + " " + sock.getPort());
            }
            if (is != null) {
                is.close();
            }
            is = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (os != null) {
                os.close();
            }
            os = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            sock.close();
            sock = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAndCloseSocket(String key) {
        SocketConnection sock;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "IOHandler closing/removing socket and I/O streams with key: " + key);
        }
        if ((sock = (SocketConnection)this.socketTable.remove(key)) == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Socket was already null for key: " + key);
            }
            return;
        }
        InputStream is = (InputStream)this.inputStreamsTable.remove(sock);
        OutputStream os = (OutputStream)this.outputStreamsTable.remove(sock);
        this.disposeSocket(sock, is, os);
        if (this.sipStack.maxConnections != -1) {
            TCPMessageProcessor tcpProc = (TCPMessageProcessor)this.sipStack.getMessageProcessor(TCP);
            if (tcpProc == null) {
                return;
            }
            TCPMessageProcessor tCPMessageProcessor = tcpProc;
            synchronized (tCPMessageProcessor) {
                tcpProc.decreaseNumConnections();
                tcpProc.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(OutputStream outputStream, byte[] bytes, int length) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            int chunksize = 512;
            int p = 0;
            while (p < length) {
                int chunk = p + chunksize < length ? chunksize : length - p;
                outputStream.write(bytes, p, chunk);
                p += chunksize;
            }
            outputStream.flush();
        }
        bytes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public SocketConnection sendBytes(String receiverAddress, int receiverPort, String transport, byte[] bytes, boolean retry) throws IOException {
        int retry_count = 0;
        int max_retry = retry ? 2 : 1;
        int length = bytes.length;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "sendBytes START" + transport + " rcvrAddr " + receiverAddress + " port = " + receiverPort + " length = " + length);
        }
        if (transport.equalsIgnoreCase(TCP)) {
            String key = this.makeKey(receiverAddress, receiverPort);
            SocketConnection clientSock = null;
            clientSock = this.getSocket(key);
            while (retry_count < max_retry) {
                if (clientSock == null) {
                    TCPMessageProcessor tcpProc;
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(32, "No socket cached for rcvraddr = " + receiverAddress + " port = " + receiverPort);
                    }
                    if ((tcpProc = (TCPMessageProcessor)this.sipStack.getMessageProcessor(TCP)) == null) {
                        return null;
                    }
                    TCPMessageProcessor tCPMessageProcessor = tcpProc;
                    synchronized (tCPMessageProcessor) {
                        while (this.sipStack.maxConnections != -1 && tcpProc.getNumConnections() >= this.sipStack.maxConnections) {
                            try {
                                if (LogWriter.needsLogging) {
                                    LogWriter.logMessage(16, "Not enough sockets available. Waiting...");
                                }
                                System.out.println("Not enough sockets available. Waiting...");
                                tcpProc.wait();
                                if (this.sipStack.isAlive()) continue;
                                return null;
                            }
                            catch (InterruptedException ex) {
                                break;
                            }
                        }
                        tcpProc.increaseNumConnections();
                    }
                    try {
                        if (LogWriter.needsLogging) {
                            LogWriter.logMessage(32, "Creating socket for rcvraddr = " + receiverAddress + " port = " + receiverPort);
                        }
                        clientSock = this.sipStack.getNetworkLayer().createSocket(receiverAddress, receiverPort);
                        key = this.makeKey(receiverAddress, clientSock.getAddress(), clientSock.getPort());
                    }
                    catch (SocketException e) {
                        throw new IOException(e.getClass() + " ::: " + e.getMessage());
                    }
                    OutputStream outputStream = clientSock.openOutputStream();
                    InputStream inputStream = clientSock.openInputStream();
                    this.putSocket(key, clientSock, outputStream, inputStream);
                    this.writeChunks(outputStream, bytes, length);
                    break;
                }
                try {
                    OutputStream outputStream = (OutputStream)this.outputStreamsTable.get(clientSock);
                    this.writeChunks(outputStream, bytes, length);
                    break;
                }
                catch (IOException ex) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(16, "IOException occured writing to socket. RetryCount " + retry_count + " max " + max_retry);
                    }
                    this.removeAndCloseSocket(key);
                    clientSock = null;
                    ++retry_count;
                }
            }
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "sendBytes END" + transport + " rcvrAddr " + receiverAddress + " port = " + receiverPort + " length = " + length);
            }
            if (clientSock == null) {
                throw new IOException("Could not connect to " + receiverAddress + ":" + receiverPort);
            }
            return clientSock;
        }
        try {
            DatagramConnection datagramSock = this.sipStack.getNetworkLayer().createDatagramSocket(receiverAddress, receiverPort);
            Datagram dgPacket = datagramSock.newDatagram(bytes, length);
            datagramSock.send(dgPacket);
            datagramSock.close();
            return null;
        }
        catch (SocketException e) {
            throw new IOException(e.getClass() + " ::: " + e.getMessage());
        }
    }

    public void closeAll() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("IOHandler closing all connections!");
        }
        Enumeration keys = this.socketTable.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.removeAndCloseSocket(key);
        }
        this.dnsResolution.clear();
    }
}

