/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.util.Enumeration;
import java.util.Vector;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.siplite.SipStack;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.address.Router;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.header.RequestLine;
import sip4me.gov.nist.siplite.header.RouteHeader;
import sip4me.gov.nist.siplite.header.RouteList;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.message.Request;

public class DefaultRouter
implements Router {
    protected Hop defaultRoute;
    protected SipStack sipStack;

    public void setNextHop(String hopString) throws IllegalArgumentException {
        this.defaultRoute = new Hop(hopString);
        this.defaultRoute.setDefaultRouteFlag();
    }

    public Hop getNextHop(Request sipRequest) throws IllegalArgumentException {
        RequestLine requestLine = sipRequest.getRequestLine();
        if (requestLine == null) {
            return this.defaultRoute;
        }
        URI requestURI = requestLine.getUri();
        if (requestURI == null) {
            throw new IllegalArgumentException("Bad message: Null requestURI");
        }
        RouteList routes = sipRequest.getRouteHeaders();
        if (routes != null) {
            RouteHeader route = (RouteHeader)routes.getFirst();
            URI uri = route.getAddress().getURI();
            if (uri.isSipURI()) {
                SipURI sipUri = (SipURI)uri;
                if (!sipUri.hasLrParam()) {
                    this.fixStrictRouting(sipRequest);
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Route post processing fixed strict routing");
                    }
                }
                Hop hop = this.createHop(sipUri, sipRequest);
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("NextHop based on Route:" + hop);
                }
                return hop;
            }
            throw new IllegalArgumentException("First Route not a SIP URI");
        }
        if (requestURI.isSipURI() && ((SipURI)requestURI).getMAddrParam() != null) {
            Hop hop = this.createHop((SipURI)requestURI, sipRequest);
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("Using request URI maddr to route the request = " + hop.toString());
            }
            ((SipURI)requestURI).removeParameter("maddr");
            return hop;
        }
        if (this.defaultRoute != null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("Using outbound proxy to route the request = " + this.defaultRoute.toString());
            }
            return this.defaultRoute;
        }
        if (requestURI.isSipURI()) {
            Hop hop = this.createHop((SipURI)requestURI, sipRequest);
            if (hop != null && LogWriter.needsLogging) {
                LogWriter.logMessage("Used request-URI for nextHop = " + hop.toString());
            } else if (LogWriter.needsLogging) {
                LogWriter.logMessage("returning null hop -- loop detected");
            }
            return hop;
        }
        throw new IllegalArgumentException("Unexpected non-sip URI");
    }

    public Enumeration getNextHops(Request sipRequest) throws IllegalArgumentException {
        Vector<Hop> nextHops = new Vector<Hop>();
        nextHops.addElement(this.getNextHop(sipRequest));
        return nextHops.elements();
    }

    public Hop getOutboundProxy() {
        return this.defaultRoute;
    }

    public void setOutboundProxy(String outboundProxy) {
        this.defaultRoute = new Hop(outboundProxy);
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public void fixStrictRouting(Request req) {
        RouteList routes = req.getRouteHeaders();
        RouteHeader first = (RouteHeader)routes.getFirst();
        SipURI firstUri = (SipURI)first.getAddress().getURI();
        routes.removeFirst();
        Address addr = new Address();
        addr.setURI(req.getRequestURI());
        RouteHeader route = new RouteHeader(addr);
        routes.add(route);
        req.setRequestURI(firstUri);
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("post: fixStrictRouting" + req);
        }
    }

    private final Hop createHop(SipURI sipUri, Request request) {
        String transport;
        String string = transport = sipUri.isSecure() ? "tls" : sipUri.getTransportParam();
        if (transport == null) {
            ViaHeader via = (ViaHeader)request.getHeader("Via");
            transport = via.getTransport();
        }
        int port = sipUri.getPort() != -1 ? sipUri.getPort() : (transport.equalsIgnoreCase("tls") ? 5061 : 5060);
        String host = sipUri.getMAddrParam() != null ? sipUri.getMAddrParam() : sipUri.getHost();
        return new Hop(host, port, transport);
    }
}

