/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.parser;

import java.util.Hashtable;
import sip4me.gov.nist.core.LexerCore;

public class Lexer
extends LexerCore {
    public static String getHeaderName(String line) {
        if (line == null) {
            return null;
        }
        String headerName = null;
        try {
            int begin = line.indexOf(":");
            headerName = null;
            if (begin >= 1) {
                headerName = line.substring(0, begin);
            }
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return headerName;
    }

    public Lexer(String lexerName, String buffer) {
        super(lexerName, buffer);
        this.selectLexer(lexerName);
    }

    public static String getHeaderValue(String line) {
        if (line == null) {
            return null;
        }
        String headerValue = null;
        try {
            int begin = line.indexOf(":");
            headerValue = line.substring(begin + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return headerValue;
    }

    public void selectLexer(String lexerName) {
        this.currentLexer = (Hashtable)LexerCore.lexerTables.get(lexerName);
        this.currentLexerName = lexerName;
        if (this.currentLexer == null) {
            this.addLexer(lexerName);
            if (lexerName.equals("method_keywordLexer")) {
                this.addKeyword("REGISTER".toUpperCase(), 2052);
                this.addKeyword("ACK".toUpperCase(), 2054);
                this.addKeyword("OPTIONS".toUpperCase(), 2056);
                this.addKeyword("BYE".toUpperCase(), 2055);
                this.addKeyword("INVITE".toUpperCase(), 2053);
                this.addKeyword("SIP".toUpperCase(), 2051);
                this.addKeyword("SUBSCRIBE".toUpperCase(), 2101);
                this.addKeyword("NOTIFY".toUpperCase(), 2102);
            } else if (lexerName.equals("command_keywordLexer")) {
                this.addKeyword("From".toUpperCase(), 2062);
                this.addKeyword("To".toUpperCase(), 2063);
                this.addKeyword("Via".toUpperCase(), 2064);
                this.addKeyword("Route".toUpperCase(), 2070);
                this.addKeyword("Max-Forwards".toUpperCase(), 2079);
                this.addKeyword("Authorization".toUpperCase(), 2071);
                this.addKeyword("Proxy-Authorization".toUpperCase(), 2072);
                this.addKeyword("Date".toUpperCase(), 2080);
                this.addKeyword("Content-Length".toUpperCase(), 2084);
                this.addKeyword("Content-Type".toUpperCase(), 2086);
                this.addKeyword("Contact".toUpperCase(), 2087);
                this.addKeyword("Call-Id".toUpperCase(), 2088);
                this.addKeyword("Expires".toUpperCase(), 2090);
                this.addKeyword("Record-Route".toUpperCase(), 2092);
                this.addKeyword("CSeq".toUpperCase(), 2094);
                this.addKeyword("WWW-Authenticate".toUpperCase(), 2096);
                this.addKeyword("Proxy-Authenticate".toUpperCase(), 2082);
                this.addKeyword("Event".toUpperCase(), 2111);
                this.addKeyword("C".toUpperCase(), 2086);
                this.addKeyword("F".toUpperCase(), 2062);
                this.addKeyword("I".toUpperCase(), 2088);
                this.addKeyword("M".toUpperCase(), 2087);
                this.addKeyword("L".toUpperCase(), 2084);
                this.addKeyword("T".toUpperCase(), 2063);
                this.addKeyword("V".toUpperCase(), 2064);
                this.addKeyword("O".toUpperCase(), 2111);
            } else if (lexerName.equals("status_lineLexer")) {
                this.addKeyword("SIP".toUpperCase(), 2051);
            } else if (lexerName.equals("request_lineLexer")) {
                this.addKeyword("SIP".toUpperCase(), 2051);
            } else if (lexerName.equals("sip_urlLexer")) {
                this.addKeyword("TEL".toUpperCase(), 2105);
                this.addKeyword("SIP".toUpperCase(), 2051);
            }
        }
    }
}

