/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.parser;

import java.util.Calendar;
import java.util.TimeZone;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.siplite.header.ExtensionHeader;
import sip4me.gov.nist.siplite.header.Header;
import sip4me.gov.nist.siplite.parser.Lexer;
import sip4me.gov.nist.siplite.parser.Parser;

public class HeaderParser
extends Parser {
    protected int wkday() throws ParseException {
        this.dbg_enter("wkday");
        try {
            String tok = this.lexer.ttoken();
            String id = tok.toLowerCase();
            if (Utils.equalsIgnoreCase("MON", id)) {
                return 2;
            }
            if (Utils.equalsIgnoreCase("TUE", id)) {
                return 3;
            }
            if (Utils.equalsIgnoreCase("WED", id)) {
                return 4;
            }
            if (Utils.equalsIgnoreCase("THU", id)) {
                return 5;
            }
            if (Utils.equalsIgnoreCase("FRI", id)) {
                return 6;
            }
            if (Utils.equalsIgnoreCase("SAT", id)) {
                return 7;
            }
            if (Utils.equalsIgnoreCase("SUN", id)) {
                return 1;
            }
            throw this.createParseException("bad wkday");
        }
        finally {
            this.dbg_leave("wkday");
        }
    }

    protected Calendar date() throws ParseException {
        try {
            Calendar retval = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            String s1 = this.lexer.number();
            int day = Integer.parseInt(s1);
            if (day <= 0 || day > 31) {
                throw this.createParseException("Bad day ");
            }
            retval.set(5, day);
            this.lexer.match(32);
            String month = this.lexer.ttoken().toLowerCase();
            if (month.equals("jan")) {
                retval.set(2, 0);
            } else if (month.equals("feb")) {
                retval.set(2, 1);
            } else if (month.equals("mar")) {
                retval.set(2, 2);
            } else if (month.equals("apr")) {
                retval.set(2, 3);
            } else if (month.equals("may")) {
                retval.set(2, 4);
            } else if (month.equals("jun")) {
                retval.set(2, 5);
            } else if (month.equals("jul")) {
                retval.set(2, 6);
            } else if (month.equals("aug")) {
                retval.set(2, 7);
            } else if (month.equals("sep")) {
                retval.set(2, 8);
            } else if (month.equals("oct")) {
                retval.set(2, 9);
            } else if (month.equals("nov")) {
                retval.set(2, 10);
            } else if (month.equals("dec")) {
                retval.set(2, 11);
            }
            this.lexer.match(32);
            String s2 = this.lexer.number();
            int yr = Integer.parseInt(s2);
            retval.set(1, yr);
            return retval;
        }
        catch (Exception ex) {
            throw this.createParseException("bad date field");
        }
    }

    protected void time(Calendar calendar) throws ParseException {
        try {
            String s = this.lexer.number();
            int hour = Integer.parseInt(s);
            calendar.set(11, hour);
            this.lexer.match(58);
            s = this.lexer.number();
            int min = Integer.parseInt(s);
            calendar.set(12, min);
            this.lexer.match(58);
            s = this.lexer.number();
            int sec = Integer.parseInt(s);
            calendar.set(13, sec);
        }
        catch (Exception ex) {
            throw this.createParseException("error processing time ");
        }
    }

    protected HeaderParser() {
    }

    public void setHeaderToParse(String header) throws ParseException {
        if (this.lexer != null) {
            throw this.createParseException("header already set");
        }
        this.lexer = new Lexer("command_keywordLexer", header);
    }

    protected HeaderParser(String header) {
        this.lexer = new Lexer("command_keywordLexer", header);
    }

    protected HeaderParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("command_keywordLexer");
    }

    public Header parse() throws ParseException {
        String name = this.lexer.getNextToken(':');
        this.lexer.consume(1);
        String body = this.lexer.getLine().trim();
        ExtensionHeader retval = new ExtensionHeader(name, body);
        return retval;
    }

    protected void headerName(int tok) throws ParseException {
        this.lexer.match(tok);
        this.lexer.SPorHT();
        this.lexer.match(58);
        this.lexer.SPorHT();
    }
}

