/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite;

import java.io.IOException;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.siplite.ListeningPoint;
import sip4me.gov.nist.siplite.RequestEvent;
import sip4me.gov.nist.siplite.ResponseEvent;
import sip4me.gov.nist.siplite.SipListener;
import sip4me.gov.nist.siplite.SipProvider;
import sip4me.gov.nist.siplite.SipStack;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.ClientTransaction;
import sip4me.gov.nist.siplite.stack.Dialog;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.SIPServerException;
import sip4me.gov.nist.siplite.stack.SIPServerRequestInterface;
import sip4me.gov.nist.siplite.stack.SIPServerResponseInterface;
import sip4me.gov.nist.siplite.stack.ServerTransaction;
import sip4me.gov.nist.siplite.stack.Transaction;

public class NistSipMessageHandlerImpl
implements SIPServerRequestInterface,
SIPServerResponseInterface {
    protected Transaction transactionChannel;
    protected MessageChannel rawMessageChannel;
    protected ListeningPoint listeningPoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(Request sipRequest, MessageChannel incomingMessageChannel) throws SIPServerException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("PROCESSING INCOMING REQUEST " + sipRequest.getFirstLine());
        }
        if (this.listeningPoint == null) {
            if (!LogWriter.needsLogging) return;
            LogWriter.logMessage("Dropping message: No listening point registered!");
            return;
        }
        this.rawMessageChannel = incomingMessageChannel;
        SipStack sipStack = (SipStack)this.transactionChannel.getSIPStack();
        SipProvider sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (!LogWriter.needsLogging) return;
            LogWriter.logMessage("No provider - dropping !!");
            return;
        }
        SipListener sipListener = sipProvider.sipListener;
        Transaction transaction = this.transactionChannel;
        SipProvider sipProvider2 = sipProvider;
        synchronized (sipProvider2) {
            RequestEvent sipEvent;
            block69: {
                block68: {
                    Dialog dialog;
                    block63: {
                        block66: {
                            block67: {
                                String dialogId;
                                block64: {
                                    block65: {
                                        dialogId = sipRequest.getDialogId(true);
                                        dialog = sipStack.getDialog(dialogId);
                                        if (!sipRequest.getMethod().equals("ACK")) break block64;
                                        if (LogWriter.needsLogging) {
                                            LogWriter.logMessage("Processing ACK for dialog " + dialog);
                                        }
                                        if (dialog != null) break block65;
                                        if (LogWriter.needsLogging) {
                                            LogWriter.logMessage("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                                        }
                                        transaction = sipStack.findTransaction(sipRequest, true);
                                        break block63;
                                    }
                                    if (dialog.getLastAck() != null && dialog.getLastAck().equals(sipRequest)) {
                                        if (sipStack.isRetransmissionFilterActive()) {
                                            dialog.ackReceived(sipRequest);
                                            transaction.setDialog(dialog);
                                            if (!LogWriter.needsLogging) return;
                                            LogWriter.logMessage("Retransmission Filter enabled - dropping Ack retransmission");
                                            return;
                                        }
                                        if (LogWriter.needsLogging) {
                                            LogWriter.logMessage("ACK retransmission for 2XX response Sending ACK to the TU");
                                        }
                                        break block63;
                                    } else {
                                        Transaction tr = dialog.getLastTransaction();
                                        Response sipResponse = tr.getLastResponse();
                                        if (LogWriter.needsLogging) {
                                            LogWriter.logMessage("TRANSACTION:" + tr);
                                        }
                                        if (tr instanceof ServerTransaction && sipResponse != null && sipResponse.isSuccessfulResponse() && sipResponse.getCSeqHeader().getSequenceNumber() == sipRequest.getCSeqHeader().getSequenceNumber()) {
                                            transaction.setDialog(dialog);
                                            dialog.ackReceived(sipRequest);
                                            if (sipStack.isRetransmissionFilterActive() && tr.isAckSeen()) {
                                                if (!LogWriter.needsLogging) return;
                                                LogWriter.logMessage("ACK retransmission for 2XX response --- Dropping ");
                                                return;
                                            }
                                            tr.setAckSeen();
                                            LogWriter.logMessage("ACK retransmission for 2XX response --- sending to TU ");
                                            break block63;
                                        } else {
                                            if (LogWriter.needsLogging) {
                                                LogWriter.logMessage("ACK retransmission for non 2XX response Discarding ACK");
                                            }
                                            if (tr == null) {
                                                // empty if block
                                            }
                                            if ((transaction = tr) instanceof ClientTransaction) {
                                                if (!LogWriter.needsLogging) return;
                                                LogWriter.logMessage("Dropping late ACK");
                                                return;
                                            }
                                        }
                                    }
                                    break block63;
                                }
                                if (!sipRequest.getMethod().equals("BYE")) break block66;
                                transaction = this.transactionChannel;
                                if (transaction == null || !((ServerTransaction)transaction).isTransactionMapped()) break block67;
                                if (LogWriter.needsLogging) {
                                    LogWriter.logMessage("dialogId = " + dialogId);
                                }
                                if (dialog != null) {
                                    dialog.addTransaction(transaction);
                                    break block63;
                                } else {
                                    dialogId = sipRequest.getDialogId(false);
                                    if (LogWriter.needsLogging) {
                                        LogWriter.logMessage("dialogId = " + dialogId);
                                    }
                                    dialog = sipStack.getDialog(dialogId);
                                    if (LogWriter.needsLogging) {
                                        LogWriter.logMessage("dialog = " + dialog);
                                    }
                                    if (dialog != null) {
                                        dialog.addTransaction(transaction);
                                        break block63;
                                    } else {
                                        transaction = null;
                                    }
                                }
                                break block63;
                            }
                            if (transaction != null) {
                                if (dialog != null) {
                                    if (!LogWriter.needsLogging) return;
                                    LogWriter.logMessage("Dropping out of sequence BYE");
                                    return;
                                }
                                transaction = null;
                            }
                            break block63;
                        }
                        if (sipRequest.getRequestLine().getMethod().equals("CANCEL")) {
                            ServerTransaction serverTransaction = (ServerTransaction)sipStack.findInviteTransactionToCancel(sipRequest, true);
                            if (serverTransaction == null) {
                                if (LogWriter.needsLogging) {
                                    LogWriter.logMessage("INVITE transaction  does not exist for CANCEL " + sipRequest.getFirstLine() + "isServerTransaction = " + true);
                                }
                                try {
                                    Response resp = sipRequest.createResponse(481);
                                    transaction.sendMessage(resp);
                                    if (!LogWriter.needsLogging) return;
                                    LogWriter.logMessage("481 sent for non-matching CANCEL");
                                }
                                catch (IOException e) {
                                    if (!LogWriter.needsLogging) return;
                                    LogWriter.logMessage(2, "Could not send 481 response to non-matching CANCEL");
                                    LogWriter.logException(e);
                                }
                                return;
                            }
                            if (serverTransaction.getState() == 6) {
                                if (LogWriter.needsLogging) {
                                    LogWriter.logMessage(16, "Too late to cancel INVITE Transaction: " + serverTransaction.getBranchId());
                                }
                                try {
                                    transaction.sendMessage(sipRequest.createResponse(200));
                                }
                                catch (Exception ex) {
                                    if (!LogWriter.needsLogging) return;
                                    LogWriter.logMessage(2, "Could not send 200 OK response to late CANCEL");
                                    LogWriter.logException(ex);
                                }
                                return;
                            }
                            if (LogWriter.needsLogging) {
                                LogWriter.logMessage(16, "Cancelling INVITE Transaction: " + serverTransaction.getBranchId());
                            }
                            dialog = serverTransaction.getDialog();
                            transaction.setDialog(dialog);
                            try {
                                sipStack.addTransaction((ServerTransaction)transaction);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                InternalErrorHandler.handleException(e);
                            }
                        } else if (sipRequest.getRequestLine().getMethod().equals("INVITE") && dialog == null) {
                            try {
                                sipStack.addTransaction((ServerTransaction)transaction);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                InternalErrorHandler.handleException(ex);
                                return;
                            }
                        }
                    }
                    if (!(dialog == null || transaction == null || sipRequest.getMethod().equals("BYE") || sipRequest.getMethod().equals("CANCEL") || sipRequest.getMethod().equals("ACK"))) {
                        if (dialog.getRemoteSequenceNumber() >= sipRequest.getCSeqHeader().getSequenceNumber()) {
                            if (!LogWriter.needsLogging) return;
                            LogWriter.logMessage("Dropping out of sequence message " + dialog.getRemoteSequenceNumber() + " " + sipRequest.getCSeqHeader());
                            return;
                        }
                        try {
                            sipStack.addTransaction((ServerTransaction)transaction);
                            dialog.addTransaction(transaction);
                            dialog.addRoute(sipRequest);
                            transaction.setDialog(dialog);
                        }
                        catch (IOException ex) {
                            InternalErrorHandler.handleException(ex);
                            return;
                        }
                    }
                    sipEvent = null;
                    if (dialog != null || !sipRequest.getMethod().equals("NOTIFY")) break block68;
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("NOTIFY has no associated dialog.");
                    }
                    ClientTransaction ct = sipStack.findSubscribeTransaction(sipRequest);
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("NOTIFY has client transaction? " + ct);
                    }
                    if (ct != null) {
                        Dialog subscribeDialog = ct.getDialog();
                        transaction.setDialog(subscribeDialog);
                        if (subscribeDialog.getState() == -1) {
                            subscribeDialog.setRemoteTag(transaction.getRequest().getFromHeaderTag());
                            subscribeDialog.addTransaction(transaction);
                            subscribeDialog.setFirstTransaction(ct);
                            subscribeDialog.setLastTransaction(ct);
                            subscribeDialog.addRoute(sipRequest);
                            subscribeDialog.setDialogId(sipRequest.getDialogId(true));
                            subscribeDialog.setLocalTag(sipRequest.getToTag());
                            subscribeDialog.setRemoteTag(sipRequest.getFromHeaderTag());
                            subscribeDialog.setRemoteSequenceNumber(sipRequest.getCSeqHeaderNumber());
                            subscribeDialog.setLocalTag(sipRequest.getToTag());
                            subscribeDialog.setState(2);
                            sipStack.putDialog(subscribeDialog);
                        }
                        sipEvent = new RequestEvent(sipProvider, (ServerTransaction)transaction, sipRequest);
                        break block69;
                    } else {
                        if (LogWriter.needsLogging) {
                            LogWriter.logMessage("Trying to reply 481 to out-of-dialog NOTIFY");
                        }
                        try {
                            Response resp = sipRequest.createResponse(481);
                            transaction.getMessageChannel().sendMessage(resp);
                            if (!LogWriter.needsLogging) return;
                            LogWriter.logMessage("481 sent for out-of-dialog NOTIFY");
                        }
                        catch (IOException e) {
                            if (!LogWriter.needsLogging) return;
                            LogWriter.logMessage(2, "Could not send 481 response to out-of-dialog NOTIFY");
                            LogWriter.logException(e);
                        }
                        return;
                    }
                }
                if (transaction != null && sipRequest.getMethod().equals("CANCEL")) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(32, "Creating request event for CANCEL from transaction: " + transaction.getBranchId());
                    }
                    sipEvent = new RequestEvent(sipProvider, (ServerTransaction)transaction, sipRequest);
                } else if (transaction != null && ((ServerTransaction)transaction).isTransactionMapped()) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(32, "Creating request event from transaction: " + transaction.getBranchId());
                    }
                    sipEvent = new RequestEvent(sipProvider, (ServerTransaction)transaction, sipRequest);
                } else {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(32, "Creating request event with no transaction.");
                    }
                    sipEvent = new RequestEvent(sipProvider, null, sipRequest);
                }
            }
            sipProvider.handleEvent(sipEvent, transaction);
            return;
        }
    }

    public void processResponse(Response sipResponse, MessageChannel incomingMessageChannel) throws SIPServerException {
        try {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("PROCESSING INCOMING RESPONSE" + sipResponse.encode());
            }
            if (this.listeningPoint == null) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Dropping message: No listening point registered!");
                }
                return;
            }
            Transaction transaction = this.transactionChannel;
            SipProvider sipProvider = this.listeningPoint.getProvider();
            if (sipProvider == null) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Dropping message:  no provider");
                }
                return;
            }
            SipStack sipStack = sipProvider.sipStack;
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("Transaction = " + transaction);
            }
            if (this.transactionChannel == null) {
                String dialogId = sipResponse.getDialogId(false);
                Dialog dialog = sipStack.getDialog(dialogId);
                if (sipProvider.sipListener == null) {
                    return;
                }
                if (dialog != null) {
                    if (!sipResponse.isSuccessfulResponse()) {
                        return;
                    }
                    if (sipStack.isRetransmissionFilterActive() && sipResponse.getCSeqHeader().equals(dialog.getFirstTransaction().getRequest().getHeader("CSeq"))) {
                        dialog.resendAck();
                        return;
                    }
                }
                ResponseEvent sipEvent = new ResponseEvent(sipProvider, null, sipResponse);
                sipProvider.handleEvent(sipEvent, transaction);
                return;
            }
            this.rawMessageChannel = incomingMessageChannel;
            String method = sipResponse.getCSeqHeader().getMethod();
            ClientTransaction clientTransaction = (ClientTransaction)this.transactionChannel;
            Dialog dialog = null;
            if (transaction != null) {
                dialog = transaction.getDialog();
                if (LogWriter.needsLogging && dialog == null) {
                    LogWriter.logMessage("dialog not found for " + sipResponse.getFirstLine());
                }
            }
            SipListener sipListener = sipProvider.sipListener;
            ResponseEvent responseEvent = new ResponseEvent(sipProvider, (ClientTransaction)transaction, sipResponse);
            sipProvider.handleEvent(responseEvent, transaction);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    public MessageChannel getRequestChannel() {
        return this.transactionChannel;
    }

    public MessageChannel getResponseChannel() {
        if (this.transactionChannel != null) {
            return this.transactionChannel;
        }
        return this.rawMessageChannel;
    }

    public String getProcessingInfo() {
        return null;
    }
}

