/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.fields;

import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.fields.SDPField;

public class KeyField
extends SDPField {
    protected String type;
    protected String keyData;

    public Object clone() {
        KeyField retval = new KeyField();
        retval.type = this.type;
        retval.keyData = this.keyData;
        return retval;
    }

    public KeyField() {
        super("k=");
    }

    public String getType() {
        return this.type;
    }

    public String getKeyData() {
        return this.keyData;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setKeyData(String k) {
        this.keyData = k;
    }

    public String encode() {
        String encoded_string = "k=" + this.type;
        if (Utils.compareToIgnoreCase(this.type, "prompt") == 0) {
            if (Utils.compareToIgnoreCase(this.type, "URI") == 0) {
                encoded_string = String.valueOf(encoded_string) + ":";
                encoded_string = String.valueOf(encoded_string) + this.keyData;
            } else if (this.keyData != null) {
                encoded_string = String.valueOf(encoded_string) + ":";
                encoded_string = String.valueOf(encoded_string) + this.keyData;
            }
        }
        encoded_string = String.valueOf(encoded_string) + "\r\n";
        return encoded_string;
    }

    public String getMethod() throws SdpParseException {
        return this.type;
    }

    public void setMethod(String name) throws SdpException {
        this.type = name;
    }

    public boolean hasKey() throws SdpParseException {
        String key = this.getKeyData();
        return key != null;
    }

    public String getKey() throws SdpParseException {
        return this.getKeyData();
    }

    public void setKey(String key) throws SdpException {
        if (key == null) {
            throw new SdpException("The key is null");
        }
        this.setKeyData(key);
    }
}

