/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core;

import sip4me.gov.nist.core.Debug;
import sip4me.gov.nist.core.LexerCore;
import sip4me.gov.nist.core.NameValue;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Token;

public abstract class ParserCore {
    public static final boolean debug = Debug.parserDebug;
    protected static int nesting_level;
    protected LexerCore lexer;

    protected NameValue nameValue(char separator) throws ParseException {
        if (debug) {
            this.dbg_enter("nameValue");
        }
        try {
            this.lexer.match(4095);
            Token name = this.lexer.getNextToken();
            this.lexer.SPorHT();
            try {
                boolean quoted = false;
                char la = this.lexer.lookAhead(0);
                if (la == separator) {
                    this.lexer.consume(1);
                    this.lexer.SPorHT();
                    String str = null;
                    if (this.lexer.lookAhead(0) == '\"') {
                        str = this.lexer.quotedString();
                        quoted = true;
                    } else {
                        this.lexer.match(4095);
                        Token value = this.lexer.getNextToken();
                        str = value.tokenValue;
                    }
                    NameValue nv = new NameValue(name.tokenValue, str);
                    if (quoted) {
                        nv.setQuotedValue();
                    }
                    NameValue nameValue = nv;
                    return nameValue;
                }
                NameValue nameValue = new NameValue(name.tokenValue, null);
                return nameValue;
            }
            catch (ParseException ex) {
                NameValue nameValue = new NameValue(name.tokenValue, null);
                return nameValue;
            }
        }
        finally {
            if (debug) {
                this.dbg_leave("nameValue");
            }
        }
    }

    protected void dbg_enter(String rule) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < nesting_level) {
            stringBuffer.append(">");
            ++i;
        }
        if (debug) {
            System.out.println(stringBuffer + rule + "\nlexer buffer = \n" + this.lexer.getRest());
        }
        ++nesting_level;
    }

    protected void dbg_leave(String rule) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < nesting_level) {
            stringBuffer.append("<");
            ++i;
        }
        if (debug) {
            System.out.println(stringBuffer + rule + "\nlexer buffer = \n" + this.lexer.getRest());
        }
        --nesting_level;
    }

    protected NameValue nameValue() throws ParseException {
        return this.nameValue('=');
    }

    protected void peekLine(String rule) {
        if (debug) {
            Debug.println(String.valueOf(rule) + " " + this.lexer.peekLine());
        }
    }
}

