/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import java.util.Random;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.JitterBuffer;
import org.linphone.jortp.JitterBufferController;
import org.linphone.jortp.JitterBufferParams;
import org.linphone.jortp.JitterBufferStatistics;
import org.linphone.jortp.Logger;
import org.linphone.jortp.PayloadType;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpPacket;
import org.linphone.jortp.RtpPacketImpl;
import org.linphone.jortp.RtpProfile;
import org.linphone.jortp.RtpProfileImpl;
import org.linphone.jortp.RtpSession;
import org.linphone.jortp.RtpStatistics;
import org.linphone.jortp.RtpStatisticsImpl;
import org.linphone.jortp.RtpTransport;
import org.linphone.jortp.RtpTransportListener;
import org.linphone.jortp.SocketAddress;
import org.linphone.jortp.TimestampClock;

public class RtpSessionImpl
implements RtpSession {
    private SocketAddress mLocalAddr;
    private SocketAddress mRemoteAddr;
    private RtpProfile mProfile = RtpProfileImpl.createAVProfile();
    private RtpTransport mRtpTransport;
    private JitterBuffer mJitterBuffer = new JitterBuffer(){

        public void onDrop(RtpPacket p) {
            ++((RtpSessionImpl)RtpSessionImpl.this).mRecvStats.mLate;
        }
    };
    private JitterBufferController mJitterBufferController;
    private RtpStatisticsImpl mRecvStats;
    private RtpStatisticsImpl mSendStats;
    private PayloadType mRecvPtObj = null;
    private int mRecvPt = 0;
    private int mSendPt = 0;
    private int mSendSeq = 0;
    private int mRecvSSRC;
    private int mSentSSRC;
    private int mClockrate = 8000;
    private JitterBufferStatistics mJitterBufferStats = new JitterBufferStatistics();
    private TimestampClock mTsc;
    private static final Logger mLog = JOrtpFactory.instance().createLogger("jortp");

    RtpSessionImpl() {
        this.mJitterBufferController = new JitterBufferController(){

            public void onTimestampJump() {
                if (mLog.isLevelEnabled(28)) {
                    mLog.warn("Timestamp jump detected !");
                }
                RtpSessionImpl.this.mJitterBuffer.purge();
                ((RtpSessionImpl)RtpSessionImpl.this).mRecvStats.mCount = 0L;
            }
        };
        this.mRecvStats = new RtpStatisticsImpl();
        this.mSendStats = new RtpStatisticsImpl();
        this.mSentSSRC = new Random().nextInt();
        this.mRtpTransport = JOrtpFactory.instance().createDefaultTransport();
    }

    public JitterBufferParams getJitterBufferParams() {
        return this.mJitterBufferController.getParams();
    }

    public void setJitterBufferParams(JitterBufferParams params) {
        this.mJitterBufferController.setParams(params);
    }

    public JitterBufferStatistics getJitterBufferStatistics() {
        this.mJitterBufferStats.mDelay = (float)this.mJitterBuffer.getDelayTs() / (float)this.mClockrate;
        this.mJitterBufferStats.mSize = (float)this.mJitterBuffer.getTimestampDiff() / (float)this.mClockrate;
        return this.mJitterBufferStats;
    }

    private void updateRecvPt(int pt) {
        if (pt != this.mRecvPt) {
            PayloadType ptobj = this.mProfile.getPayloadType(pt);
            if (ptobj != null) {
                if (this.mRecvPtObj != null) {
                    mLog.warn("Incoming payload type changed to " + pt);
                }
                this.mRecvPtObj = ptobj;
                this.mClockrate = ptobj.getClockRate();
            }
            this.mRecvPt = pt;
        }
    }

    private void processIncomingPacket(RtpPacket p, int user_recvts) {
        if (p.getSocketAddress() != null) {
            this.mRemoteAddr = p.getSocketAddress();
        }
        ++this.mRecvStats.mCount;
        try {
            ((RtpPacketImpl)p).readHeader();
        }
        catch (RtpException e) {
            e.printStackTrace();
            return;
        }
        this.updateRecvPt(p.getPayloadType());
        this.mJitterBufferController.newIncomingPacket(p, user_recvts, this.mClockrate);
        this.mJitterBuffer.put(p);
    }

    private void readFromTransport(int user_recvts) throws RtpException {
        RtpPacket p;
        while ((p = this.mRtpTransport.recvfrom()) != null) {
            this.processIncomingPacket(p, user_recvts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpPacket recvPacket(int user_ts) throws RtpException {
        RtpPacket p;
        if (this.mTsc == null) {
            this.readFromTransport(user_ts);
        }
        JitterBuffer jitterBuffer = this.mJitterBuffer;
        synchronized (jitterBuffer) {
            int stream_ts = this.mJitterBufferController.convertTimestamp(user_ts);
            p = this.mJitterBuffer.get(stream_ts);
            if (p != null) {
                this.mRecvSSRC = p.getSSRC();
                this.mRecvPt = p.getPayloadType();
                ++this.mRecvStats.mPlayed;
            }
        }
        return p;
    }

    public void sendPacket(RtpPacket p, int timeStamp) throws RtpException {
        RtpPacketImpl pi = (RtpPacketImpl)p;
        pi.setTimestamp(timeStamp);
        pi.setSeqNumber(this.mSendSeq);
        pi.setPayloadType(this.mSendPt);
        pi.setSSRC(this.mSentSSRC);
        pi.writeHeader();
        pi.setSocketAddress(this.mRemoteAddr);
        this.mRtpTransport.sendto(p);
        ++this.mSendSeq;
        ++this.mSendStats.mCount;
    }

    public void setLocalAddr(SocketAddress addr) throws RtpException {
        this.mLocalAddr = addr;
        this.mRtpTransport.init(this.mLocalAddr);
    }

    public void setRemoteAddr(SocketAddress addr) throws RtpException {
        this.mRemoteAddr = addr;
    }

    public void setProfile(RtpProfile prof) {
        this.mProfile = prof;
    }

    public void setRecvPayloadTypeNumber(int pt) {
        this.updateRecvPt(pt);
    }

    public void setSendPayloadTypeNumber(int pt) {
        this.mSendPt = pt;
    }

    public void setTransport(RtpTransport rtpt) {
        this.mRtpTransport = rtpt;
        this.setup();
    }

    public void setSentSSRC(int ssrc) {
        this.mSentSSRC = ssrc;
    }

    public int getSentSSRC() {
        return this.mSentSSRC;
    }

    public int getRecvSSRC() {
        return this.mRecvSSRC;
    }

    public RtpStatistics getRecvStats() {
        int lost = (int)((long)(this.mJitterBufferController.getRelativeSeqNumber() + 1) - this.mRecvStats.mCount);
        this.mRecvStats.mLost = lost;
        return this.mRecvStats;
    }

    public RtpStatistics getSendStats() {
        return this.mSendStats;
    }

    public int getRecvPayloadTypeNumber() {
        return this.mRecvPt;
    }

    public void close() {
        this.mRtpTransport.close();
    }

    public RtpProfile getProfile() {
        return this.mProfile;
    }

    public int getSendPayloadTypeNumber() {
        return this.mSendPt;
    }

    public void setTimestampClock(TimestampClock tsc) {
        this.mTsc = tsc;
        this.setup();
    }

    private void setup() {
        if (this.mTsc != null) {
            this.mRtpTransport.setListener(new RtpTransportListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onPacketReceived(RtpPacket p) {
                    JitterBuffer jitterBuffer = RtpSessionImpl.this.mJitterBuffer;
                    synchronized (jitterBuffer) {
                        RtpSessionImpl.this.processIncomingPacket(p, RtpSessionImpl.this.mTsc.getCurrentTimestamp());
                    }
                }
            });
        }
    }
}

