/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.UDPDatagramConnection;
import net.rim.device.api.system.CoverageInfo;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.ListHead;
import org.linphone.jortp.Logger;
import org.linphone.jortp.Node;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpPacket;
import org.linphone.jortp.RtpTransport;
import org.linphone.jortp.RtpTransportListener;
import org.linphone.jortp.SocketAddress;

public class RtpBBTransport
implements RtpTransport,
Runnable {
    private DatagramConnection mConnection;
    private Thread mThread;
    private ListHead mRecvQueue = new ListHead();
    private SocketAddress mLastRecv;
    boolean mRunning;
    private static Logger sLogger = JOrtpFactory.instance().createLogger("RtpBBTransport");
    private Datagram mReceiveDataGram;
    private RtpTransportListener mListener;

    public void close() {
        this.mRunning = false;
        this.closeConnection();
    }

    public void init(SocketAddress local) throws RtpException {
        if (this.mRunning) {
            sLogger.error("Rtp BB trabnsport already initialized");
            return;
        }
        this.mThread = new Thread((Runnable)this, "BB RtpTransport thread");
        this.mThread.setPriority(10);
        try {
            this.mConnection = this.createDatagramCnx(local.getPort());
            this.mReceiveDataGram = this.mConnection.newDatagram(this.mConnection.getMaximumLength());
        }
        catch (IOException e) {
            sLogger.error("Could not create connection for port " + local.getPort(), e);
            throw new RtpException(e);
        }
        this.mRunning = true;
        this.mThread.start();
    }

    protected DatagramConnection createDatagramCnx(int port) throws IOException {
        String url = "datagram://:" + port;
        if ((CoverageInfo.getCoverageStatus((int)4, (boolean)true) & 1) == 1) {
            url = String.valueOf(url) + "/ ;interface=wifi";
        }
        return (DatagramConnection)Connector.open((String)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpPacket recvfrom() {
        RtpPacket rp = null;
        ListHead listHead = this.mRecvQueue;
        synchronized (listHead) {
            rp = (RtpPacket)((Object)this.mRecvQueue.popFront());
        }
        return rp;
    }

    public synchronized void sendto(RtpPacket p) {
        Datagram dg;
        if (this.mConnection == null) {
            sLogger.info("cannot send message because connection is null");
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("datagram://");
        sb.append(p.getSocketAddress().getHost());
        sb.append(':');
        sb.append(p.getSocketAddress().getPort());
        try {
            dg = this.mConnection.newDatagram(p.getBytes(), p.getRealLength(), sb.toString());
        }
        catch (IOException e) {
            sLogger.error("Could not create new Datagram for sending", e);
            return;
        }
        try {
            this.mConnection.send(dg);
        }
        catch (IOException e) {
            sLogger.error("Could not send datagram", e);
        }
    }

    private SocketAddress getSocketAddress(String url) {
        int index = "//".length();
        int colon = url.indexOf(58, index);
        String host = url.substring(index, colon);
        String portstr = url.substring(colon + 1, url.indexOf(";"));
        int port = Integer.parseInt(portstr);
        if (this.mLastRecv != null && this.mLastRecv.getHost().equals(host) && this.mLastRecv.getPort() == port) {
            return this.mLastRecv;
        }
        this.mLastRecv = JOrtpFactory.instance().createSocketAddress(host, port);
        return this.mLastRecv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (true) {
                    if (!this.mRunning) {
                        return;
                    }
                    RtpPacket rp = null;
                    try {
                        this.mConnection.receive(this.mReceiveDataGram);
                        rp = JOrtpFactory.instance().createRtpPacket(this.mReceiveDataGram.getLength());
                    }
                    catch (IOException e) {
                        if (!this.mRunning) {
                            sLogger.info("rtp session closed");
                            return;
                        }
                        sLogger.error("Could not receive datagram", e);
                        continue;
                    }
                    try {
                        System.arraycopy(this.mReceiveDataGram.getData(), this.mReceiveDataGram.getOffset(), rp.getBytes(), 0, this.mReceiveDataGram.getLength());
                        rp.setRealLength(this.mReceiveDataGram.getLength());
                    }
                    catch (RtpException e) {
                        sLogger.error("Could not setRealLength()", e);
                        continue;
                    }
                    if (sLogger.isLevelEnabled(31)) {
                        sLogger.debug("new rtp packet received at [" + System.currentTimeMillis() + "]");
                    }
                    if (this.mListener == null) {
                        ListHead listHead = this.mRecvQueue;
                        synchronized (listHead) {
                            this.mRecvQueue.pushBack((Node)((Object)rp));
                        }
                    }
                    this.mListener.onPacketReceived(rp);
                }
            }
            catch (Throwable e) {
                sLogger.error("Exiting [" + this + "]", e);
                this.closeConnection();
                return;
            }
        }
        finally {
            this.closeConnection();
        }
    }

    private synchronized void closeConnection() {
        if (this.mConnection != null) {
            try {
                sLogger.info("Closing rtp connection[" + this + "]");
                this.mConnection.close();
                this.mConnection = null;
            }
            catch (IOException e) {
                sLogger.warn("cannot close [" + this + "]");
            }
        }
    }

    public String toString() {
        try {
            return this.mConnection != null && ((UDPDatagramConnection)this.mConnection).getLocalAddress() != null ? String.valueOf(((UDPDatagramConnection)this.mConnection).getLocalAddress().toString()) + ":" + String.valueOf(((UDPDatagramConnection)this.mConnection).getLocalPort()) : "not set";
        }
        catch (Throwable e) {
            return "not set";
        }
    }

    public void setListener(RtpTransportListener l) {
        this.mListener = l;
    }
}

