/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.JitterBufferParams;
import org.linphone.jortp.JitterBufferParamsImpl;
import org.linphone.jortp.Logger;
import org.linphone.jortp.RtpPacket;

abstract class JitterBufferController {
    private JitterBufferParams mParams = new JitterBufferParamsImpl();
    private boolean mStarted = false;
    private double mDiffMean;
    private long mDiffCurrent;
    private double mJitter;
    private double mCurrentSize;
    private int mTsJump = 0;
    private int mFirstSeq;
    private int mLastSeq;
    private static double sSmoothFactor = 0.01;
    private static Logger sLogger = JOrtpFactory.instance().createLogger("jortp");

    JitterBufferController() {
    }

    public void setParams(JitterBufferParams params) {
        this.mParams = params;
    }

    public void resync() {
        this.mStarted = false;
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    public abstract void onTimestampJump();

    public void newIncomingPacket(RtpPacket p, int user_recvts, int clockrate) {
        long ldiff = p.getTimestamp() - user_recvts;
        double diff = ldiff;
        if (this.mStarted) {
            if (this.mParams.isAdaptive()) {
                this.mDiffMean = sSmoothFactor * diff + (1.0 - sSmoothFactor) * this.mDiffMean;
                double diff2 = diff - this.mDiffMean;
                this.mJitter = sSmoothFactor * diff2 + (1.0 - sSmoothFactor) * this.mJitter;
                double adapt = this.mDiffMean - (double)this.mDiffCurrent;
                if (adapt >= 160.0) {
                    this.mDiffCurrent += 160L;
                    if (sLogger.isLevelEnabled(30)) {
                        sLogger.info("mDiffCurrent=" + this.mDiffCurrent);
                    }
                } else if (adapt <= -160.0) {
                    this.mDiffCurrent -= 160L;
                    if (sLogger.isLevelEnabled(30)) {
                        sLogger.info("mDiffCurrent=" + this.mDiffCurrent);
                    }
                }
            }
            if (Math.abs(this.mDiffCurrent - ldiff) > (long)this.mTsJump) {
                this.onTimestampJump();
                this.mStarted = false;
            }
        }
        if (!this.mStarted) {
            this.mCurrentSize = this.mParams.getNominalSize() * clockrate / 1000;
            this.mTsJump = clockrate * 5;
            this.mDiffMean = diff;
            this.mDiffCurrent = ldiff;
            this.mFirstSeq = p.getSeqNumber();
            this.mStarted = true;
            if (sLogger.isLevelEnabled(30)) {
                sLogger.info("JitterBufferControl started, mCurrentSize=" + this.mCurrentSize + " mDiffCurrent=" + this.mDiffCurrent);
            }
        }
        this.mLastSeq = p.getSeqNumber();
    }

    public int convertTimestamp(int user_ts) {
        return (int)((long)user_ts + this.mDiffCurrent - (long)((int)this.mCurrentSize));
    }

    public int getCurrentSize() {
        return (int)this.mCurrentSize;
    }

    public JitterBufferParams getParams() {
        return this.mParams;
    }

    public int getRelativeSeqNumber() {
        return this.mLastSeq - this.mFirstSeq;
    }
}

