/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.media.jsr135;

import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.RecordControl;
import net.rim.device.api.media.control.AudioPathControl;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpPacket;
import org.linphone.jortp.RtpSession;

public class SendStream
implements PlayerListener {
    private static Logger sLogger = JOrtpFactory.instance().createLogger("SendStream");
    private RtpSession mSession;
    private boolean mRunning;
    private Player mPlayer;
    private int mTs = 0;
    private int mFrameSize = 32;
    boolean isStarted = false;
    boolean mSkipHeader = true;
    private OutputStream mOutput = new OutputStream(){

        public void close() throws IOException {
            sLogger.info("close()");
        }

        public void flush() throws IOException {
        }

        public void write(byte[] buffer, int offset, int count) {
            try {
                if (sLogger.isLevelEnabled(31)) {
                    sLogger.debug("Called in write date [" + System.currentTimeMillis() + "] offset [" + offset + "] length [" + count + "] ts [" + SendStream.this.mTs + "]");
                }
                int lOffset = offset;
                if (SendStream.this.mSkipHeader) {
                    sLogger.info("AMR header skipped");
                    lOffset += "#!AMR\n".length();
                    SendStream.this.mSkipHeader = false;
                }
                while (lOffset + SendStream.this.mFrameSize <= offset + count) {
                    RtpPacket packet = JOrtpFactory.instance().createRtpPacket(SendStream.this.mFrameSize + 1);
                    System.arraycopy(buffer, lOffset, packet.getBytes(), packet.getDataOffset() + 1, SendStream.this.mFrameSize);
                    packet.getBytes()[packet.getDataOffset()] = -16;
                    try {
                        SendStream.this.mSession.sendPacket(packet, SendStream.this.mTs);
                    }
                    catch (RtpException e) {
                        sLogger.error("Fail to send RTP packet", e);
                    }
                    SendStream sendStream = SendStream.this;
                    sendStream.mTs = sendStream.mTs + 160;
                    lOffset += SendStream.this.mFrameSize;
                }
            }
            catch (Throwable e) {
                sLogger.error("Cannot write data", e);
            }
        }

        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        public void write(int arg0) throws IOException {
            sLogger.error("write(int arg0) not implemented");
        }
    };

    public SendStream(RtpSession session) {
        this.mSession = session;
        this.mRunning = false;
        this.mTs = 0;
    }

    public void stop() {
        try {
            this.isStarted = false;
            RecordControl recordControl = (RecordControl)this.mPlayer.getControl("RecordControl");
            recordControl.commit();
            this.mOutput.close();
            this.mPlayer.close();
        }
        catch (Throwable e) {
            sLogger.error("InterruptedException in SendStream !", e);
        }
    }

    public void start() {
        try {
            this.mPlayer = Manager.createPlayer((String)"capture://audio?encoding=audio/amr&updateMethod=time&updateThreshold=100&rate=12200&voipMode=true");
            this.mPlayer.addPlayerListener((PlayerListener)this);
            this.mPlayer.realize();
            RecordControl recordControl = (RecordControl)this.mPlayer.getControl("RecordControl");
            recordControl.setRecordStream(this.mOutput);
            recordControl.startRecord();
            AudioPathControl lPathCtr = (AudioPathControl)this.mPlayer.getControl("net.rim.device.api.media.control.AudioPathControl");
            lPathCtr.setAudioPath(0);
            this.mPlayer.prefetch();
            this.mPlayer.start();
            this.isStarted = true;
        }
        catch (Throwable e) {
            sLogger.error("Cannot start  send stream !", e);
        }
    }

    public void playerUpdate(Player arg0, String event, Object eventData) {
        if (sLogger.isLevelEnabled(28)) {
            sLogger.warn("Got event " + event + "[" + (eventData == null ? "" : eventData.toString()) + "]");
        }
    }

    public void muteMic(boolean value) {
        try {
            if (this.mPlayer != null) {
                if (value) {
                    this.mPlayer.stop();
                } else {
                    this.mPlayer.start();
                }
            }
            sLogger.info("Mic " + (value ? "muted" : "unmuted"));
        }
        catch (Throwable e) {
            sLogger.error("Cannot " + (value ? "mute" : "unmute") + " mic", e);
        }
    }

    public boolean isMicMuted() {
        if (this.mPlayer != null) {
            return this.mPlayer.getState() != 400;
        }
        return false;
    }

    public void enableSpeaker(boolean value) {
        if (this.mPlayer == null) {
            return;
        }
        AudioPathControl lPathCtr = (AudioPathControl)this.mPlayer.getControl("net.rim.device.api.media.control.AudioPathControl");
        try {
            lPathCtr.setAudioPath(value ? 1 : 0);
            sLogger.info("Send stream has speaker is " + (lPathCtr.getAudioPath() == 1 ? "enabled" : "disabled"));
        }
        catch (Throwable e) {
            sLogger.error("Cannot " + (value ? "enable" : "disable") + " speaker", e);
        }
    }

    protected Player getPlayer() {
        return this.mPlayer;
    }
}

