/*
 * Link Monitor Applet
 * Copyright (C) 2004-2007 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include "lm-stock.h"
#include "lm-util.h"

/*** constants ***************************************************************/

static const GtkStockItem items[] = {
  /* translators: header capitalization */
  { LM_STOCK_SELECT_ALL, N_("Select _All"), 0, 0, NULL },
};

/*** implementation **********************************************************/

void
lm_stock_init (void)
{
  const struct
  {
    const char	*stock_id;
    const char	*icon_name;
  } icons[] = {
    { LM_STOCK_SELECT_ALL, "stock_select-all" }
  };
  GtkIconFactory *factory;
  GtkIconTheme *icon_theme;
  int i;

  factory = gtk_icon_factory_new();
  gtk_icon_factory_add_default(factory);
  icon_theme = gtk_icon_theme_get_default();

  for (i = 0; i < G_N_ELEMENTS(icons); i++)
    {
      GtkIconSet *icon_set;
      GtkIconSource *icon_source;

      icon_set = gtk_icon_set_new();
      icon_source = gtk_icon_source_new();
      gtk_icon_source_set_icon_name(icon_source, icons[i].icon_name);
      gtk_icon_set_add_source(icon_set, icon_source);
      gtk_icon_source_free(icon_source);

      gtk_icon_factory_add(factory, icons[i].stock_id, icon_set);
      gtk_icon_set_unref(icon_set);
    }

  g_object_unref(factory);

  gtk_stock_add_static(items, G_N_ELEMENTS(items));
}
