/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "lm-applet.h"

#include "lm-applet-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 33 "lm-applet.gob"

#include "config.h"
#include <string.h>
#include <panel-applet-gconf.h>
#include <eel/eel.h>
#include "lm-util.h"
#include "lm-preferences-dialog.h"
#include "lm-about-dialog.h"
#include "lm-icmp.h"
#include "lm-host-frontend.h"

#define ICON_PADDING			1

#define BAR_SPACING			3

#define CONF_HOSTS			"hosts"
#define CONF_DELAY			"delay"
#define CONF_TIMEOUT			"timeout"
#define CONF_SCALE			"scale"
#define CONF_PREFERENCES_WIDTH		"preferences_width"
#define CONF_PREFERENCES_HEIGHT		"preferences_height"

/* keep in sync with link-monitor-applet.schemas */
#define DEFAULT_PREFERENCES_WIDTH	-1
#define DEFAULT_PREFERENCES_HEIGHT	387

/* keep in sync with preferences.glade */
#define MIN_DELAY			1000
#define MIN_TIMEOUT			100
#define MIN_SCALE			1

#line 56 "lm-applet.c"
/* self casting macros */
#define SELF(x) LM_APPLET(x)
#define SELF_CONST(x) LM_APPLET_CONST(x)
#define IS_SELF(x) LM_IS_APPLET(x)
#define TYPE_SELF LM_TYPE_APPLET
#define SELF_CLASS(x) LM_APPLET_CLASS(x)

#define SELF_GET_CLASS(x) LM_APPLET_GET_CLASS(x)

/* self typedefs */
typedef LMApplet Self;
typedef LMAppletClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lm_applet_init (LMApplet * o) G_GNUC_UNUSED;
static void ___real_lm_applet_activate (LMApplet * self);
static void lm_applet_activate (LMApplet * self) G_GNUC_UNUSED;
static void ___real_lm_applet_activate_preferences (LMApplet * self);
static void lm_applet_activate_preferences (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_class_init (LMAppletClass * class) G_GNUC_UNUSED;
static gboolean lm_applet_factory_cb (PanelApplet * applet, const char * iid, gpointer data) G_GNUC_UNUSED;
static void lm_applet_destroy_h (GtkObject * object, gpointer user_data) G_GNUC_UNUSED;
static void lm_applet_reconfigure (LMApplet * self) G_GNUC_UNUSED;
static gboolean lm_applet_reconfigure_timeout_cb (gpointer data) G_GNUC_UNUSED;
static void lm_applet_change_background_h (PanelApplet * applet, PanelAppletBackgroundType type, GdkColor * color, GdkPixmap * pixmap, gpointer user_data) G_GNUC_UNUSED;
static gboolean lm_applet_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;
static void lm_applet_preferences_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_help_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_about_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_display_preferences_dialog (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_display_window (LMApplet * self, GType type, GtkWidget ** ptr) G_GNUC_UNUSED;
static void lm_applet_update (LMApplet * self) G_GNUC_UNUSED;
static GtkWidget * lm_applet_create_icon (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_update_applet (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_update_tooltip (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_sync_gconf_hosts (LMApplet * self) G_GNUC_UNUSED;
static LMHost * lm_applet_host_new (LMApplet * self, const char * name) G_GNUC_UNUSED;
static LMHost * lm_applet_add_host_internal (LMApplet * self, const char * name) G_GNUC_UNUSED;
static LMHost * lm_applet_replace_host_internal (LMApplet * self, LMHost * old, const char * new) G_GNUC_UNUSED;
static void lm_applet_reorder_hosts_internal (LMApplet * self, GSList * new_hosts) G_GNUC_UNUSED;
static void lm_applet_remove_host_internal (LMApplet * self, LMHost * host) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__activate(object,func,data)	lm_applet_connect__activate((object),(func),(data))
#define self_connect_after__activate(object,func,data)	lm_applet_connect_after__activate((object),(func),(data))
#define self_connect_data__activate(object,func,data,destroy_data,flags)	lm_applet_connect_data__activate((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_preferences(object,func,data)	lm_applet_connect__activate_preferences((object),(func),(data))
#define self_connect_after__activate_preferences(object,func,data)	lm_applet_connect_after__activate_preferences((object),(func),(data))
#define self_connect_data__activate_preferences(object,func,data,destroy_data,flags)	lm_applet_connect_data__activate_preferences((object),(func),(data),(destroy_data),(flags))

enum {
	ACTIVATE_SIGNAL,
	ACTIVATE_PREFERENCES_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_DELAY,
	PROP_TIMEOUT,
	PROP_SCALE,
	PROP_PREFERENCES_WIDTH,
	PROP_PREFERENCES_HEIGHT
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static PanelAppletClass *parent_class = NULL;

/* Short form macros */
#define self_get_delay lm_applet_get_delay
#define self_set_delay lm_applet_set_delay
#define self_get_timeout lm_applet_get_timeout
#define self_set_timeout lm_applet_set_timeout
#define self_get_scale lm_applet_get_scale
#define self_set_scale lm_applet_set_scale
#define self_get_preferences_width lm_applet_get_preferences_width
#define self_set_preferences_width lm_applet_set_preferences_width
#define self_get_preferences_height lm_applet_get_preferences_height
#define self_set_preferences_height lm_applet_set_preferences_height
#define self_activate lm_applet_activate
#define self_activate_preferences lm_applet_activate_preferences
#define self_factory_cb lm_applet_factory_cb
#define self_destroy_h lm_applet_destroy_h
#define self_reconfigure lm_applet_reconfigure
#define self_reconfigure_timeout_cb lm_applet_reconfigure_timeout_cb
#define self_change_background_h lm_applet_change_background_h
#define self_button_press_event_h lm_applet_button_press_event_h
#define self_preferences_cb lm_applet_preferences_cb
#define self_help_cb lm_applet_help_cb
#define self_about_cb lm_applet_about_cb
#define self_display_preferences_dialog lm_applet_display_preferences_dialog
#define self_display_window lm_applet_display_window
#define self_update lm_applet_update
#define self_create_icon lm_applet_create_icon
#define self_update_applet lm_applet_update_applet
#define self_update_tooltip lm_applet_update_tooltip
#define self_factory_main lm_applet_factory_main
#define self_sync_gconf_hosts lm_applet_sync_gconf_hosts
#define self_host_new lm_applet_host_new
#define self_add_host_internal lm_applet_add_host_internal
#define self_replace_host_internal lm_applet_replace_host_internal
#define self_reorder_hosts_internal lm_applet_reorder_hosts_internal
#define self_remove_host_internal lm_applet_remove_host_internal
#define self_add_host lm_applet_add_host
#define self_replace_host lm_applet_replace_host
#define self_reorder_hosts lm_applet_reorder_hosts
#define self_remove_host lm_applet_remove_host
GType
lm_applet_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMAppletClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_applet_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMApplet),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_applet_init,
			NULL
		};

		type = g_type_register_static (PANEL_TYPE_APPLET, "LMApplet", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMApplet *)g_object_new(lm_applet_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMApplet * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMApplet *
GET_NEW_VARG (const char *first, ...)
{
	LMApplet *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMApplet *)g_object_new_valist (lm_applet_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Applet::finalize"
	LMApplet *self G_GNUC_UNUSED = LM_APPLET (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
lm_applet_init (LMApplet * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Applet::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_APPLET,LMAppletPrivate);
}
#undef __GOB_FUNCTION__
#line 144 "lm-applet.gob"
static void 
lm_applet_class_init (LMAppletClass * class G_GNUC_UNUSED)
#line 234 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	g_type_class_add_private(class,sizeof(LMAppletPrivate));

	parent_class = g_type_class_ref (PANEL_TYPE_APPLET);

	object_signals[ACTIVATE_SIGNAL] =
		g_signal_new ("activate",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMAppletClass, activate),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PREFERENCES_SIGNAL] =
		g_signal_new ("activate_preferences",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMAppletClass, activate_preferences),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 132 "lm-applet.gob"
	class->activate = ___real_lm_applet_activate;
#line 138 "lm-applet.gob"
	class->activate_preferences = ___real_lm_applet_activate_preferences;
#line 264 "lm-applet.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_uint
		("delay" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MIN_DELAY /* minimum */,
		 G_MAXUINT /* maximum */,
		 MIN_DELAY /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DELAY,
		param_spec);
	param_spec = g_param_spec_uint
		("timeout" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MIN_TIMEOUT /* minimum */,
		 G_MAXUINT /* maximum */,
		 MIN_TIMEOUT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_TIMEOUT,
		param_spec);
	param_spec = g_param_spec_uint
		("scale" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MIN_SCALE /* minimum */,
		 G_MAXUINT /* maximum */,
		 MIN_SCALE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SCALE,
		param_spec);
	param_spec = g_param_spec_int
		("preferences_width" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 -1 /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_PREFERENCES_WIDTH /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PREFERENCES_WIDTH,
		param_spec);
	param_spec = g_param_spec_int
		("preferences_height" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 -1 /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_PREFERENCES_HEIGHT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PREFERENCES_HEIGHT,
		param_spec);
    }
 {
#line 145 "lm-applet.gob"

    GtkBindingSet *binding_set;

    binding_set = gtk_binding_set_by_class(class);

    gtk_binding_entry_add_signal(binding_set, GDK_Return, 0, "activate", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, 0, "activate", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, 0, "activate", 0);

    gtk_binding_entry_add_signal(binding_set, GDK_Return, GDK_MOD1_MASK, "activate-preferences", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, GDK_MOD1_MASK, "activate-preferences", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, GDK_MOD1_MASK, "activate-preferences", 0);
  
#line 342 "lm-applet.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Applet::set_property"
{
	LMApplet *self G_GNUC_UNUSED;

	self = LM_APPLET (object);

	switch (property_id) {
	case PROP_DELAY:
		{
#line 72 "lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_DELAY, self->delay = g_value_get_uint(VAL), NULL);
    
#line 365 "lm-applet.c"
		}
		break;
	case PROP_TIMEOUT:
		{
#line 83 "lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_TIMEOUT, self->timeout = g_value_get_uint(VAL), NULL);
    
#line 374 "lm-applet.c"
		}
		break;
	case PROP_SCALE:
		{
#line 94 "lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_SCALE, self->scale = g_value_get_uint(VAL), NULL);
    
#line 383 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_WIDTH:
		{
#line 105 "lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_PREFERENCES_WIDTH, self->preferences_width = g_value_get_int(VAL), NULL);
    
#line 392 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_HEIGHT:
		{
#line 116 "lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_PREFERENCES_HEIGHT, self->preferences_height = g_value_get_int(VAL), NULL);
    
#line 401 "lm-applet.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Applet::get_property"
{
	LMApplet *self G_GNUC_UNUSED;

	self = LM_APPLET (object);

	switch (property_id) {
	case PROP_DELAY:
		{
#line 76 "lm-applet.gob"

      g_value_set_uint(VAL, self->delay);
    
#line 434 "lm-applet.c"
		}
		break;
	case PROP_TIMEOUT:
		{
#line 87 "lm-applet.gob"

      g_value_set_uint(VAL, self->timeout);
    
#line 443 "lm-applet.c"
		}
		break;
	case PROP_SCALE:
		{
#line 98 "lm-applet.gob"

      g_value_set_uint(VAL, self->scale);
    
#line 452 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_WIDTH:
		{
#line 109 "lm-applet.gob"

      g_value_set_int(VAL, self->preferences_width);
    
#line 461 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_HEIGHT:
		{
#line 120 "lm-applet.gob"

      g_value_set_int(VAL, self->preferences_height);
    
#line 470 "lm-applet.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 76 "lm-applet.gob"
guint 
lm_applet_get_delay (LMApplet * self)
#line 489 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_delay"
{
#line 70 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "delay", &val, NULL); return val;
}}
#line 496 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 72 "lm-applet.gob"
void 
lm_applet_set_delay (LMApplet * self, guint val)
#line 502 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_delay"
{
#line 70 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "delay", val, NULL);
}}
#line 509 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 87 "lm-applet.gob"
guint 
lm_applet_get_timeout (LMApplet * self)
#line 515 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_timeout"
{
#line 81 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "timeout", &val, NULL); return val;
}}
#line 522 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 83 "lm-applet.gob"
void 
lm_applet_set_timeout (LMApplet * self, guint val)
#line 528 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_timeout"
{
#line 81 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "timeout", val, NULL);
}}
#line 535 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 98 "lm-applet.gob"
guint 
lm_applet_get_scale (LMApplet * self)
#line 541 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_scale"
{
#line 92 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "scale", &val, NULL); return val;
}}
#line 548 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 94 "lm-applet.gob"
void 
lm_applet_set_scale (LMApplet * self, guint val)
#line 554 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_scale"
{
#line 92 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "scale", val, NULL);
}}
#line 561 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 109 "lm-applet.gob"
gint 
lm_applet_get_preferences_width (LMApplet * self)
#line 567 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_preferences_width"
{
#line 103 "lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "preferences_width", &val, NULL); return val;
}}
#line 574 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 105 "lm-applet.gob"
void 
lm_applet_set_preferences_width (LMApplet * self, gint val)
#line 580 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_preferences_width"
{
#line 103 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "preferences_width", val, NULL);
}}
#line 587 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 120 "lm-applet.gob"
gint 
lm_applet_get_preferences_height (LMApplet * self)
#line 593 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_preferences_height"
{
#line 114 "lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "preferences_height", &val, NULL); return val;
}}
#line 600 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 116 "lm-applet.gob"
void 
lm_applet_set_preferences_height (LMApplet * self, gint val)
#line 606 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_preferences_height"
{
#line 114 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "preferences_height", val, NULL);
}}
#line 613 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 132 "lm-applet.gob"
static void 
lm_applet_activate (LMApplet * self)
#line 619 "lm-applet.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 132 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 132 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 631 "lm-applet.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 132 "lm-applet.gob"
static void 
___real_lm_applet_activate (LMApplet * self G_GNUC_UNUSED)
#line 647 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::activate"
{
#line 134 "lm-applet.gob"
	
    self_display_preferences_dialog(self);
  }}
#line 655 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 138 "lm-applet.gob"
static void 
lm_applet_activate_preferences (LMApplet * self)
#line 661 "lm-applet.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 138 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 138 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 673 "lm-applet.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PREFERENCES_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 138 "lm-applet.gob"
static void 
___real_lm_applet_activate_preferences (LMApplet * self G_GNUC_UNUSED)
#line 689 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::activate_preferences"
{
#line 140 "lm-applet.gob"
	
    self_display_preferences_dialog(self);
  }}
#line 697 "lm-applet.c"
#undef __GOB_FUNCTION__


#line 159 "lm-applet.gob"
static gboolean 
lm_applet_factory_cb (PanelApplet * applet, const char * iid, gpointer data)
#line 704 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::factory_cb"
{
#line 161 "lm-applet.gob"
	
    Self *self = SELF(applet);
    static const BonoboUIVerb menu_verbs[] = {
      BONOBO_UI_VERB("LinkMonitorPreferences", self_preferences_cb),
      BONOBO_UI_VERB("LinkMonitorHelp", self_help_cb),
      BONOBO_UI_VERB("LinkMonitorAbout", self_about_cb),
      BONOBO_UI_VERB_END
    };
    GSList *gconf_hosts;
    GSList *l;

    if (strcmp(iid, "OAFIID:GNOME_LinkMonitorApplet"))
      return FALSE;

    GDK_THREADS_ENTER();

    lm_shell->applets = g_slist_append(lm_shell->applets, self);

    panel_applet_set_flags(applet, PANEL_APPLET_EXPAND_MINOR);
    panel_applet_add_preferences(applet, "/schemas/apps/link-monitor-applet/prefs", NULL);
    panel_applet_setup_menu_from_file(applet, DATADIR, "GNOME_LinkMonitorApplet.xml", NULL, menu_verbs, applet);

    self->delay = panel_applet_gconf_get_int(applet, CONF_DELAY, NULL);
    if (self->delay < MIN_DELAY)
      self->delay = MIN_DELAY;

    self->timeout = panel_applet_gconf_get_int(applet, CONF_TIMEOUT, NULL);
    if (self->timeout < MIN_TIMEOUT)
      self->timeout = MIN_TIMEOUT;

    self->scale = panel_applet_gconf_get_int(applet, CONF_SCALE, NULL);
    if (self->scale < MIN_SCALE)
      self->scale = MIN_SCALE;

    self->preferences_width = panel_applet_gconf_get_int(applet, CONF_PREFERENCES_WIDTH, NULL);
    if (! self->preferences_width)
      self->preferences_width = DEFAULT_PREFERENCES_WIDTH;

    self->preferences_height = panel_applet_gconf_get_int(applet, CONF_PREFERENCES_HEIGHT, NULL);
    if (! self->preferences_height)
      self->preferences_height = DEFAULT_PREFERENCES_HEIGHT;

    selfp->tooltip_status_size_group = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
    selfp->tooltip_flag_size_group = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);

    gconf_hosts = panel_applet_gconf_get_list(applet, CONF_HOSTS, GCONF_VALUE_STRING, NULL);
    LM_LIST_FOREACH(l, gconf_hosts)
      self_add_host_internal(self, l->data);
    eel_g_slist_free_deep(gconf_hosts);

    self_update(self);

    g_object_connect(self,
		     "signal::destroy", self_destroy_h, NULL,
		     "signal::button-press-event", self_button_press_event_h, NULL,
		     "signal::change-orient", self_reconfigure, NULL,
		     "signal::change-size", self_reconfigure, NULL,
		     "signal::change-background", self_change_background_h, NULL,
		     NULL);

    gtk_widget_show(GTK_WIDGET(self));

    GDK_THREADS_LEAVE();

    return TRUE;
  }}
#line 775 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 233 "lm-applet.gob"
static void 
lm_applet_destroy_h (GtkObject * object, gpointer user_data)
#line 781 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::destroy_h"
{
#line 235 "lm-applet.gob"
	
    Self *self = SELF(object);

    lm_shell->applets = g_slist_remove(lm_shell->applets, self);

    if (selfp->reconfigure_timeout_id)
      g_source_remove(selfp->reconfigure_timeout_id);

    lm_g_object_slist_free(self->hosts);

    g_object_unref(selfp->tooltip_status_size_group);
    g_object_unref(selfp->tooltip_flag_size_group);

    if (selfp->preferences_dialog)
      gtk_widget_destroy(selfp->preferences_dialog);
    if (selfp->about_dialog)
      gtk_widget_destroy(selfp->about_dialog);

    gtk_widget_destroy(GTK_WIDGET(object));
  }}
#line 806 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 256 "lm-applet.gob"
static void 
lm_applet_reconfigure (LMApplet * self)
#line 812 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reconfigure"
#line 256 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 256 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 819 "lm-applet.c"
{
#line 258 "lm-applet.gob"
	
    if (selfp->reconfigure_timeout_id)
      /* cancel the previously queued reconfigure */
      g_source_remove(selfp->reconfigure_timeout_id);

    /* do not flood the panel with reconfigures, queue it */
    selfp->reconfigure_timeout_id = g_timeout_add(10, self_reconfigure_timeout_cb, self);
  }}
#line 830 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 267 "lm-applet.gob"
static gboolean 
lm_applet_reconfigure_timeout_cb (gpointer data)
#line 836 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reconfigure_timeout_cb"
{
#line 269 "lm-applet.gob"
	
    Self *self = data;
    GSList *l;

    GDK_THREADS_ENTER();

    self_update_applet(self);
    LM_LIST_FOREACH(l, self->hosts)
      {
	LMHostFrontend *host = l->data;
	lm_host_frontend_configure_applet_progress_bar(host);
      }

    GDK_THREADS_LEAVE();

    return FALSE;		/* remove source */
  }}
#line 858 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 288 "lm-applet.gob"
static void 
lm_applet_change_background_h (PanelApplet * applet, PanelAppletBackgroundType type, GdkColor * color, GdkPixmap * pixmap, gpointer user_data)
#line 864 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::change_background_h"
{
#line 294 "lm-applet.gob"
	
    GtkRcStyle *rc_style;

    /* reset style */
    gtk_widget_set_style(GTK_WIDGET(applet), NULL);
    rc_style = gtk_rc_style_new();
    gtk_widget_modify_style(GTK_WIDGET(applet), rc_style);
    gtk_rc_style_unref(rc_style);

    switch (type)
      {
      case PANEL_NO_BACKGROUND:
	break;

      case PANEL_COLOR_BACKGROUND:
	gtk_widget_modify_bg(GTK_WIDGET(applet), GTK_STATE_NORMAL, color);
	break;

      case PANEL_PIXMAP_BACKGROUND:
	{
	  GtkStyle *style;

	  style = gtk_style_copy(GTK_WIDGET(applet)->style);
	  if (style->bg_pixmap[GTK_STATE_NORMAL])
	    g_object_unref(style->bg_pixmap[GTK_STATE_NORMAL]);
	  style->bg_pixmap[GTK_STATE_NORMAL] = g_object_ref(pixmap);
	  gtk_widget_set_style(GTK_WIDGET(applet), style);
	  g_object_unref(style);
	}
	break;
      }
  }}
#line 901 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 327 "lm-applet.gob"
static gboolean 
lm_applet_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 907 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::button_press_event_h"
{
#line 331 "lm-applet.gob"
	
    if (event->button == 1)
      {
	self_activate(SELF(widget));
	return TRUE;		/* do not propagate event */
      }

    return FALSE;		/* propagate event */
  }}
#line 921 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 341 "lm-applet.gob"
static void 
lm_applet_preferences_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 927 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::preferences_cb"
{
#line 345 "lm-applet.gob"
	
    Self *self = user_data;

    self_activate_preferences(self);
  }}
#line 937 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 351 "lm-applet.gob"
static void 
lm_applet_help_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 943 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::help_cb"
{
#line 355 "lm-applet.gob"
	
    lm_display_help(NULL);
  }}
#line 951 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 359 "lm-applet.gob"
static void 
lm_applet_about_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 957 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::about_cb"
{
#line 363 "lm-applet.gob"
	
    Self *self = user_data;

    self_display_window(self, LM_TYPE_ABOUT_DIALOG, &selfp->about_dialog);
  }}
#line 967 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 369 "lm-applet.gob"
static void 
lm_applet_display_preferences_dialog (LMApplet * self)
#line 973 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::display_preferences_dialog"
#line 369 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 369 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 980 "lm-applet.c"
{
#line 371 "lm-applet.gob"
	
    self_display_window(self, LM_TYPE_PREFERENCES_DIALOG, &selfp->preferences_dialog);
  }}
#line 986 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 375 "lm-applet.gob"
static void 
lm_applet_display_window (LMApplet * self, GType type, GtkWidget ** ptr)
#line 992 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::display_window"
#line 375 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 375 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 375 "lm-applet.gob"
	g_return_if_fail (type != 0);
#line 375 "lm-applet.gob"
	g_return_if_fail (ptr != NULL);
#line 1003 "lm-applet.c"
{
#line 379 "lm-applet.gob"
	
    GObjectClass *class;

    if (*ptr)
      {
	gtk_window_present(GTK_WINDOW(*ptr));
	return;
      }

    class = g_type_class_ref(type);
    if (g_object_class_find_property(class, "applet"))
      *ptr = g_object_new(type, "applet", self, NULL);
    else
      *ptr = g_object_new(type, NULL);
    g_type_class_unref(class);

    eel_add_weak_pointer(ptr);
    gtk_widget_show(*ptr);
  }}
#line 1025 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 399 "lm-applet.gob"
static void 
lm_applet_update (LMApplet * self)
#line 1031 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::update"
#line 399 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 399 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1038 "lm-applet.c"
{
#line 401 "lm-applet.gob"
	
    self_update_applet(self);
    self_update_tooltip(self);
  }}
#line 1045 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 406 "lm-applet.gob"
static GtkWidget * 
lm_applet_create_icon (LMApplet * self)
#line 1051 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::create_icon"
#line 406 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
#line 406 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (GtkWidget * )0);
#line 1058 "lm-applet.c"
{
#line 408 "lm-applet.gob"
	
    GdkPixbuf *pixbuf;
    int size;
    GdkPixbuf *scaled;
    GtkWidget *icon;

    pixbuf = lm_pixbuf_new(GNOMEPIXMAPSDIR G_DIR_SEPARATOR_S "link-monitor-applet.png");

    size = panel_applet_get_size(PANEL_APPLET(self)) - (ICON_PADDING * 2);
    scaled = gdk_pixbuf_scale_simple(pixbuf, size, size, GDK_INTERP_BILINEAR);
    g_object_unref(pixbuf);

    icon = gtk_image_new_from_pixbuf(scaled);
    g_object_unref(scaled);

    return icon;
  }}
#line 1078 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 426 "lm-applet.gob"
static void 
lm_applet_update_applet (LMApplet * self)
#line 1084 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::update_applet"
#line 426 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 426 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1091 "lm-applet.c"
{
#line 428 "lm-applet.gob"
	
    GSList *l;
    GtkWidget *box;
    GtkWidget *icon;
    GtkWidget *old_box;

    switch (panel_applet_get_orient(PANEL_APPLET(self)))
      {
      case PANEL_APPLET_ORIENT_UP:
      case PANEL_APPLET_ORIENT_DOWN:
	box = gtk_hbox_new(FALSE, BAR_SPACING);
	break;

      case PANEL_APPLET_ORIENT_LEFT:
      case PANEL_APPLET_ORIENT_RIGHT:
	box = gtk_vbox_new(FALSE, BAR_SPACING);
	break;

      default:
	g_assert_not_reached();
	break;
      }

    icon = self_create_icon(self);
    gtk_box_pack_start(GTK_BOX(box), icon, FALSE, FALSE, 0);
    gtk_widget_show(icon);

    LM_LIST_FOREACH(l, self->hosts)
      {
	LMHostFrontend *host = l->data;
	GtkWidget *parent;

	parent = gtk_widget_get_parent(host->applet_progress_bar);
	if (parent)
	  gtk_container_remove(GTK_CONTAINER(parent), host->applet_progress_bar);

	gtk_box_pack_start(GTK_BOX(box), host->applet_progress_bar, FALSE, FALSE, 0);
	gtk_widget_show(host->applet_progress_bar);
      }

    old_box = gtk_bin_get_child(GTK_BIN(self));
    if (old_box)
      gtk_container_remove(GTK_CONTAINER(self), old_box);

    gtk_container_add(GTK_CONTAINER(self), box);
    gtk_widget_show(box);
  }}
#line 1141 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 476 "lm-applet.gob"
static void 
lm_applet_update_tooltip (LMApplet * self)
#line 1147 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::update_tooltip"
#line 476 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 476 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1154 "lm-applet.c"
{
#line 478 "lm-applet.gob"
	
    GSList *l;

    if (self->hosts)
      {
	GtkWidget *vbox;

	vbox = gtk_vbox_new(TRUE, 6);

	LM_LIST_FOREACH(l, self->hosts)
	  {
	    LMHostFrontend *host = l->data;
	    GtkWidget *parent;

	    parent = gtk_widget_get_parent(host->tooltip);
	    if (parent)
	      gtk_container_remove(GTK_CONTAINER(parent), host->tooltip);

	    gtk_box_pack_start(GTK_BOX(vbox), host->tooltip, TRUE, TRUE, 0);
	    gtk_widget_show(host->tooltip);
	  }

	lm_tooltips_set_tip_widget(lm_shell->tooltips, GTK_WIDGET(self), vbox);
	gtk_widget_show(vbox);
      }
    else
      lm_tooltips_set_tip(lm_shell->tooltips, GTK_WIDGET(self), _("No host is being monitored."));
  }}
#line 1185 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 507 "lm-applet.gob"
int 
lm_applet_factory_main (void)
#line 1191 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::factory_main"
{
#line 509 "lm-applet.gob"
	
    return panel_applet_factory_main("OAFIID:GNOME_LinkMonitorApplet_Factory",
				     TYPE_SELF,
				     self_factory_cb,
				     NULL);
  }}
#line 1202 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 516 "lm-applet.gob"
static void 
lm_applet_sync_gconf_hosts (LMApplet * self)
#line 1208 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::sync_gconf_hosts"
#line 516 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 516 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1215 "lm-applet.c"
{
#line 518 "lm-applet.gob"
	
    GSList *gconf_hosts = NULL;
    GSList *l;

    LM_LIST_FOREACH(l, self->hosts)
      gconf_hosts = g_slist_append(gconf_hosts, LM_HOST(l->data)->name);

    panel_applet_gconf_set_list(PANEL_APPLET(self),
				CONF_HOSTS,
				GCONF_VALUE_STRING,
				gconf_hosts,
				NULL);

    g_slist_free(gconf_hosts);
  }}
#line 1233 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 534 "lm-applet.gob"
static LMHost * 
lm_applet_host_new (LMApplet * self, const char * name)
#line 1239 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::host_new"
#line 534 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 534 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 534 "lm-applet.gob"
	g_return_val_if_fail (name != NULL, (LMHost * )0);
#line 1248 "lm-applet.c"
{
#line 536 "lm-applet.gob"
	
    LMHostFrontend *host;

    host = lm_host_frontend_new(self, name, lm_shell_get_unique_host_id(lm_shell));
    gtk_size_group_add_widget(selfp->tooltip_status_size_group, host->tooltip_status_box);
    gtk_size_group_add_widget(selfp->tooltip_flag_size_group, host->tooltip_flag);

    return LM_HOST(host);
  }}
#line 1260 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 546 "lm-applet.gob"
static LMHost * 
lm_applet_add_host_internal (LMApplet * self, const char * name)
#line 1266 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::add_host_internal"
#line 546 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 546 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 546 "lm-applet.gob"
	g_return_val_if_fail (name != NULL, (LMHost * )0);
#line 1275 "lm-applet.c"
{
#line 548 "lm-applet.gob"
	
    LMHost *host;

    host = self_host_new(self, name);
    self->hosts = g_slist_append(self->hosts, host);

    self_update(self);

    return host;
  }}
#line 1288 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 559 "lm-applet.gob"
static LMHost * 
lm_applet_replace_host_internal (LMApplet * self, LMHost * old, const char * new)
#line 1294 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::replace_host_internal"
#line 559 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 559 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 559 "lm-applet.gob"
	g_return_val_if_fail (old != NULL, (LMHost * )0);
#line 559 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_HOST (old), (LMHost * )0);
#line 559 "lm-applet.gob"
	g_return_val_if_fail (new != NULL, (LMHost * )0);
#line 1307 "lm-applet.c"
{
#line 563 "lm-applet.gob"
	
    GSList *elem;
    LMHost *new_host;

    elem = g_slist_find(self->hosts, old);
    g_assert(elem != NULL);

    new_host = self_host_new(self, new);

    g_object_unref(old);
    elem->data = new_host;

    self_update(self);

    return new_host;
  }}
#line 1326 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 580 "lm-applet.gob"
static void 
lm_applet_reorder_hosts_internal (LMApplet * self, GSList * new_hosts)
#line 1332 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reorder_hosts_internal"
#line 580 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 580 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1339 "lm-applet.c"
{
#line 582 "lm-applet.gob"
	
    lm_g_object_slist_free(self->hosts);
    self->hosts = lm_g_object_slist_copy(new_hosts);

    self_update(self);
  }}
#line 1348 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 589 "lm-applet.gob"
static void 
lm_applet_remove_host_internal (LMApplet * self, LMHost * host)
#line 1354 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::remove_host_internal"
#line 589 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 589 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 589 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 589 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1365 "lm-applet.c"
{
#line 591 "lm-applet.gob"
	
    GSList *elem;

    elem = g_slist_find(self->hosts, host);
    g_assert(elem != NULL);

    self->hosts = g_slist_delete_link(self->hosts, elem);
    g_object_unref(host);

    self_update(self);
  }}
#line 1379 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 603 "lm-applet.gob"
LMHost * 
lm_applet_add_host (LMApplet * self, const char * name)
#line 1385 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::add_host"
#line 603 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 603 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 603 "lm-applet.gob"
	g_return_val_if_fail (name != NULL, (LMHost * )0);
#line 1394 "lm-applet.c"
{
#line 605 "lm-applet.gob"
	
    LMHost *host;

    host = self_add_host_internal(self, name);
    self_sync_gconf_hosts(self);

    return host;
  }}
#line 1405 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 614 "lm-applet.gob"
LMHost * 
lm_applet_replace_host (LMApplet * self, LMHost * old, const char * new)
#line 1411 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::replace_host"
#line 614 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 614 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 614 "lm-applet.gob"
	g_return_val_if_fail (old != NULL, (LMHost * )0);
#line 614 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_HOST (old), (LMHost * )0);
#line 614 "lm-applet.gob"
	g_return_val_if_fail (new != NULL, (LMHost * )0);
#line 1424 "lm-applet.c"
{
#line 618 "lm-applet.gob"
	
    LMHost *new_host;

    new_host = self_replace_host_internal(self, old, new);
    self_sync_gconf_hosts(self);

    return new_host;
  }}
#line 1435 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 627 "lm-applet.gob"
void 
lm_applet_reorder_hosts (LMApplet * self, GSList * new_hosts)
#line 1441 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reorder_hosts"
#line 627 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 627 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1448 "lm-applet.c"
{
#line 629 "lm-applet.gob"
	
    self_reorder_hosts_internal(self, new_hosts);
    self_sync_gconf_hosts(self);
  }}
#line 1455 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 634 "lm-applet.gob"
void 
lm_applet_remove_host (LMApplet * self, LMHost * host)
#line 1461 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::remove_host"
#line 634 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 634 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 634 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 634 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1472 "lm-applet.c"
{
#line 636 "lm-applet.gob"
	
    self_remove_host_internal(self, host);
    self_sync_gconf_hosts(self);
  }}
#line 1479 "lm-applet.c"
#undef __GOB_FUNCTION__
