# Link Monitor Applet
# Copyright (C) 2004-2007 Jean-Yves Lefort <jylefort@brutele.be>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

dnl AC_GDK_PIXBUF_LOADER(SAMPLE_IMAGE, MIME_TYPE, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl
AC_DEFUN([AC_GDK_PIXBUF_LOADER],
[success=yes

PKG_CHECK_MODULES(GDK_PIXBUF, [gdk-pixbuf-2.0],, [success=no])

if test $success = yes; then
	ac_save_CFLAGS="$CFLAGS"
	ac_save_LIBS="$LIBS"
	CFLAGS="$CFLAGS $GDK_PIXBUF_CFLAGS"
	LIBS="$LIBS $GDK_PIXBUF_LIBS"

	AC_MSG_CHECKING([if GTK+ can load [$2] images])

	AC_RUN_IFELSE([
#include <gdk-pixbuf/gdk-pixbuf.h>

int main() {
  g_type_init();
  if (gdk_pixbuf_new_from_file("[$1]", NULL))
    exit(0);
  else
    exit(1);
}
],, [success=no])

	AC_MSG_RESULT([$success])

	CFLAGS="$ac_save_CFLAGS"
	LIBS="$ac_save_LIBS"
fi

if test $success = yes; then
	ifelse([$3],, :, [$3])
else
	ifelse([$4],, :, [$4])
fi])
