/* Generated by GOB (v2.0.11) on Tue Feb  1 15:49:53 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include "lm-applet.h"

#include "lm-applet-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 43 "lm-applet.gob"

#include <string.h>
#include <panel-applet-gconf.h>
#include <eel/eel.h>
#include "lm-util.h"
#include "lm-preferences.h"
#include "lm-sockets.h"
#include "lm-icmp.h"

#define ICON_PADDING			1

#define BAR_SPACING			3
#define BAR_THICKNESS			6

#define CONF_HOSTS			"hosts"
#define CONF_DELAY			"delay"
#define CONF_TIMEOUT			"timeout"
#define CONF_SCALE			"scale"
#define CONF_PREFERENCES_WIDTH		"preferences_width"
#define CONF_PREFERENCES_HEIGHT		"preferences_height"

#define KEY_PROGRESS_BAR		"lm-applet:progress-bar"

/* keep in sync with link-monitor-applet.schemas */
#define DEFAULT_PREFERENCES_WIDTH	-1
#define DEFAULT_PREFERENCES_HEIGHT	387

/* keep in sync with preferences.glade */
#define MIN_SCALE			1

  LMApplet *lm_applet = NULL;

  typedef struct
  {
    GIOChannel		*channel;
    const LMSocket	*sock;
    LMApplet		*applet;
    unsigned int	source_id;
  } WatchInfo;

#line 66 "lm-applet.c"
/* self casting macros */
#define SELF(x) LM_APPLET(x)
#define SELF_CONST(x) LM_APPLET_CONST(x)
#define IS_SELF(x) LM_IS_APPLET(x)
#define TYPE_SELF LM_TYPE_APPLET
#define SELF_CLASS(x) LM_APPLET_CLASS(x)

#define SELF_GET_CLASS(x) LM_APPLET_GET_CLASS(x)

/* self typedefs */
typedef LMApplet Self;
typedef LMAppletClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lm_applet_init (LMApplet * o) G_GNUC_UNUSED;
static void ___real_lm_applet_activate (LMApplet * self);
static void lm_applet_activate (LMApplet * self) G_GNUC_UNUSED;
static void ___real_lm_applet_activate_preferences (LMApplet * self);
static void lm_applet_activate_preferences (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_class_init (LMAppletClass * class) G_GNUC_UNUSED;
static void ___10_lm_applet_finalize (GObject * object) G_GNUC_UNUSED;
static gboolean lm_applet_factory_cb (PanelApplet * applet, const char * iid, gpointer data) G_GNUC_UNUSED;
static gboolean lm_applet_socket_read_cb (GIOChannel * source, GIOCondition condition, gpointer data) G_GNUC_UNUSED;
static void lm_applet_reconfigure (LMApplet * self) G_GNUC_UNUSED;
static gboolean lm_applet_reconfigure_timeout_cb (gpointer data) G_GNUC_UNUSED;
static gboolean lm_applet_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;
static void lm_applet_preferences_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_help_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_about_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_configure (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_sync_gconf_hosts (LMApplet * self) G_GNUC_UNUSED;
static unsigned int lm_applet_get_unique_seq (LMApplet * self) G_GNUC_UNUSED;
static LMHost * lm_applet_add_host_internal (LMApplet * self, const char * name) G_GNUC_UNUSED;
static LMHost * lm_applet_replace_host_internal (LMApplet * self, LMHost * old, const char * new) G_GNUC_UNUSED;
static void lm_applet_reorder_hosts_internal (LMApplet * self, GSList * new_hosts) G_GNUC_UNUSED;
static void lm_applet_remove_host_internal (LMApplet * self, LMHost * host) G_GNUC_UNUSED;
static void lm_applet_host_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void lm_applet_configure_progress_bar (LMApplet * self, LMHost * host) G_GNUC_UNUSED;
static void lm_applet_update_progress_bar (LMApplet * self, LMHost * host) G_GNUC_UNUSED;
static void lm_applet_update_tooltip (LMApplet * self) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__activate(object,func,data)	lm_applet_connect__activate((object),(func),(data))
#define self_connect_after__activate(object,func,data)	lm_applet_connect_after__activate((object),(func),(data))
#define self_connect_data__activate(object,func,data,destroy_data,flags)	lm_applet_connect_data__activate((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_preferences(object,func,data)	lm_applet_connect__activate_preferences((object),(func),(data))
#define self_connect_after__activate_preferences(object,func,data)	lm_applet_connect_after__activate_preferences((object),(func),(data))
#define self_connect_data__activate_preferences(object,func,data,destroy_data,flags)	lm_applet_connect_data__activate_preferences((object),(func),(data),(destroy_data),(flags))

enum {
	ACTIVATE_SIGNAL,
	ACTIVATE_PREFERENCES_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_HOSTS,
	PROP_DELAY,
	PROP_TIMEOUT,
	PROP_SCALE,
	PROP_PREFERENCES_WIDTH,
	PROP_PREFERENCES_HEIGHT
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static PanelAppletClass *parent_class = NULL;

/* Short form macros */
#define self_get_hosts lm_applet_get_hosts
#define self_set_hosts lm_applet_set_hosts
#define self_get_delay lm_applet_get_delay
#define self_set_delay lm_applet_set_delay
#define self_get_timeout lm_applet_get_timeout
#define self_set_timeout lm_applet_set_timeout
#define self_get_scale lm_applet_get_scale
#define self_set_scale lm_applet_set_scale
#define self_get_preferences_width lm_applet_get_preferences_width
#define self_set_preferences_width lm_applet_set_preferences_width
#define self_get_preferences_height lm_applet_get_preferences_height
#define self_set_preferences_height lm_applet_set_preferences_height
#define self_activate lm_applet_activate
#define self_activate_preferences lm_applet_activate_preferences
#define self_factory_cb lm_applet_factory_cb
#define self_socket_read_cb lm_applet_socket_read_cb
#define self_reconfigure lm_applet_reconfigure
#define self_reconfigure_timeout_cb lm_applet_reconfigure_timeout_cb
#define self_button_press_event_h lm_applet_button_press_event_h
#define self_preferences_cb lm_applet_preferences_cb
#define self_help_cb lm_applet_help_cb
#define self_about_cb lm_applet_about_cb
#define self_configure lm_applet_configure
#define self_factory_main lm_applet_factory_main
#define self_sync_gconf_hosts lm_applet_sync_gconf_hosts
#define self_get_unique_seq lm_applet_get_unique_seq
#define self_add_host_internal lm_applet_add_host_internal
#define self_replace_host_internal lm_applet_replace_host_internal
#define self_reorder_hosts_internal lm_applet_reorder_hosts_internal
#define self_remove_host_internal lm_applet_remove_host_internal
#define self_host_notify_h lm_applet_host_notify_h
#define self_configure_progress_bar lm_applet_configure_progress_bar
#define self_update_progress_bar lm_applet_update_progress_bar
#define self_update_tooltip lm_applet_update_tooltip
#define self_add_host lm_applet_add_host
#define self_replace_host lm_applet_replace_host
#define self_reorder_hosts lm_applet_reorder_hosts
#define self_remove_host lm_applet_remove_host
GType
lm_applet_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMAppletClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_applet_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMApplet),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_applet_init,
			NULL
		};

		type = g_type_register_static (PANEL_TYPE_APPLET, "LMApplet", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMApplet *)g_object_new(lm_applet_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMApplet * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMApplet *
GET_NEW_VARG (const char *first, ...)
{
	LMApplet *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMApplet *)g_object_new_valist (lm_applet_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Applet::finalize"
	LMApplet *self G_GNUC_UNUSED = LM_APPLET (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 208 "lm-applet.gob"
	___10_lm_applet_finalize(obj_self);
#line 231 "lm-applet.c"
#line 88 "lm-applet.gob"
	if(self->_priv->hosts) { lm_g_object_slist_free ((gpointer) self->_priv->hosts); self->_priv->hosts = NULL; }
#line 234 "lm-applet.c"
}
#undef __GOB_FUNCTION__

static void 
lm_applet_init (LMApplet * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Applet::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,LMAppletPrivate);
}
#undef __GOB_FUNCTION__
#line 193 "lm-applet.gob"
static void 
lm_applet_class_init (LMAppletClass * class G_GNUC_UNUSED)
#line 248 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	g_type_class_add_private(class,sizeof(LMAppletPrivate));

	parent_class = g_type_class_ref (PANEL_TYPE_APPLET);

	object_signals[ACTIVATE_SIGNAL] =
		g_signal_new ("activate",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMAppletClass, activate),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PREFERENCES_SIGNAL] =
		g_signal_new ("activate_preferences",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMAppletClass, activate_preferences),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 181 "lm-applet.gob"
	class->activate = ___real_lm_applet_activate;
#line 187 "lm-applet.gob"
	class->activate_preferences = ___real_lm_applet_activate_preferences;
#line 208 "lm-applet.gob"
	g_object_class->finalize = ___finalize;
#line 280 "lm-applet.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("hosts" /* name */,
		 NULL /* nick */,
		 _("The list of hosts") /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_HOSTS,
		param_spec);
	param_spec = g_param_spec_uint
		("delay" /* name */,
		 NULL /* nick */,
		 _("The amount of time to wait between sending each echo request to a particular host") /* blurb */,
		 LM_HOST_MIN_DELAY /* minimum */,
		 G_MAXUINT /* maximum */,
		 LM_HOST_MIN_DELAY /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DELAY,
		param_spec);
	param_spec = g_param_spec_uint
		("timeout" /* name */,
		 NULL /* nick */,
		 _("The delay after which a host is considered dead if no reply was received") /* blurb */,
		 LM_HOST_MIN_TIMEOUT /* minimum */,
		 G_MAXUINT /* maximum */,
		 LM_HOST_MIN_TIMEOUT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_TIMEOUT,
		param_spec);
	param_spec = g_param_spec_uint
		("scale" /* name */,
		 NULL /* nick */,
		 _("The round-trip time a full bar represents") /* blurb */,
		 MIN_SCALE /* minimum */,
		 G_MAXUINT /* maximum */,
		 MIN_SCALE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SCALE,
		param_spec);
	param_spec = g_param_spec_int
		("preferences_width" /* name */,
		 NULL /* nick */,
		 _("The width of the preferences dialog") /* blurb */,
		 -1 /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_PREFERENCES_WIDTH /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PREFERENCES_WIDTH,
		param_spec);
	param_spec = g_param_spec_int
		("preferences_height" /* name */,
		 NULL /* nick */,
		 _("The height of the preferences dialog") /* blurb */,
		 -1 /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_PREFERENCES_HEIGHT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PREFERENCES_HEIGHT,
		param_spec);
    }
 {
#line 194 "lm-applet.gob"

    GtkBindingSet *binding_set;

    binding_set = gtk_binding_set_by_class(class);
    
    gtk_binding_entry_add_signal(binding_set, GDK_Return, 0, "activate", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, 0, "activate", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, 0, "activate", 0);

    gtk_binding_entry_add_signal(binding_set, GDK_Return, GDK_MOD1_MASK, "activate-preferences", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, GDK_MOD1_MASK, "activate-preferences", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, GDK_MOD1_MASK, "activate-preferences", 0);
  
#line 365 "lm-applet.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Applet::set_property"
{
	LMApplet *self G_GNUC_UNUSED;

	self = LM_APPLET (object);

	switch (property_id) {
	case PROP_HOSTS:
		{
#line 89 "lm-applet.gob"
self->_priv->hosts = g_value_get_pointer (VAL);
#line 386 "lm-applet.c"
		}
		break;
	case PROP_DELAY:
		{
#line 97 "lm-applet.gob"

      GSList *l;

      selfp->delay = g_value_get_uint(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_DELAY, selfp->delay, NULL);
      LM_LIST_FOREACH(l, selfp->hosts)
	lm_host_set_delay(l->data, selfp->delay);
    
#line 400 "lm-applet.c"
		}
		break;
	case PROP_TIMEOUT:
		{
#line 116 "lm-applet.gob"

      GSList *l;

      selfp->timeout = g_value_get_uint(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_TIMEOUT, selfp->timeout, NULL);
      LM_LIST_FOREACH(l, selfp->hosts)
	lm_host_set_timeout(l->data, selfp->timeout);
    
#line 414 "lm-applet.c"
		}
		break;
	case PROP_SCALE:
		{
#line 135 "lm-applet.gob"

      GSList *l;

      selfp->scale = g_value_get_uint(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_SCALE, selfp->scale, NULL);
      LM_LIST_FOREACH(l, selfp->hosts)
	self_update_progress_bar(self, l->data);
    
#line 428 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_WIDTH:
		{
#line 154 "lm-applet.gob"

      selfp->preferences_width = g_value_get_int(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_PREFERENCES_WIDTH, selfp->preferences_width, NULL);
    
#line 438 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_HEIGHT:
		{
#line 169 "lm-applet.gob"

      selfp->preferences_height = g_value_get_int(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_PREFERENCES_HEIGHT, selfp->preferences_height, NULL);
    
#line 448 "lm-applet.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Applet::get_property"
{
	LMApplet *self G_GNUC_UNUSED;

	self = LM_APPLET (object);

	switch (property_id) {
	case PROP_HOSTS:
		{
#line 89 "lm-applet.gob"
g_value_set_pointer (VAL, self->_priv->hosts);
#line 479 "lm-applet.c"
		}
		break;
	case PROP_DELAY:
		{
#line 106 "lm-applet.gob"

      g_value_set_uint(VAL, selfp->delay);
    
#line 488 "lm-applet.c"
		}
		break;
	case PROP_TIMEOUT:
		{
#line 125 "lm-applet.gob"

      g_value_set_uint(VAL, selfp->timeout);
    
#line 497 "lm-applet.c"
		}
		break;
	case PROP_SCALE:
		{
#line 144 "lm-applet.gob"

      g_value_set_uint(VAL, selfp->scale);
    
#line 506 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_WIDTH:
		{
#line 159 "lm-applet.gob"

      g_value_set_int(VAL, selfp->preferences_width);
    
#line 515 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_HEIGHT:
		{
#line 174 "lm-applet.gob"

      g_value_set_int(VAL, selfp->preferences_height);
    
#line 524 "lm-applet.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 89 "lm-applet.gob"
gpointer 
lm_applet_get_hosts (LMApplet * self)
#line 543 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_hosts"
{
#line 89 "lm-applet.gob"
		gpointer val; g_object_get (G_OBJECT (self), "hosts", &val, NULL); return val;
}}
#line 550 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 89 "lm-applet.gob"
void 
lm_applet_set_hosts (LMApplet * self, gpointer val)
#line 556 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_hosts"
{
#line 89 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "hosts", val, NULL);
}}
#line 563 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 106 "lm-applet.gob"
guint 
lm_applet_get_delay (LMApplet * self)
#line 569 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_delay"
{
#line 92 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "delay", &val, NULL); return val;
}}
#line 576 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 97 "lm-applet.gob"
void 
lm_applet_set_delay (LMApplet * self, guint val)
#line 582 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_delay"
{
#line 92 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "delay", val, NULL);
}}
#line 589 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 125 "lm-applet.gob"
guint 
lm_applet_get_timeout (LMApplet * self)
#line 595 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_timeout"
{
#line 111 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "timeout", &val, NULL); return val;
}}
#line 602 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 116 "lm-applet.gob"
void 
lm_applet_set_timeout (LMApplet * self, guint val)
#line 608 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_timeout"
{
#line 111 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "timeout", val, NULL);
}}
#line 615 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 144 "lm-applet.gob"
guint 
lm_applet_get_scale (LMApplet * self)
#line 621 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_scale"
{
#line 130 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "scale", &val, NULL); return val;
}}
#line 628 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 135 "lm-applet.gob"
void 
lm_applet_set_scale (LMApplet * self, guint val)
#line 634 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_scale"
{
#line 130 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "scale", val, NULL);
}}
#line 641 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 159 "lm-applet.gob"
gint 
lm_applet_get_preferences_width (LMApplet * self)
#line 647 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_preferences_width"
{
#line 149 "lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "preferences_width", &val, NULL); return val;
}}
#line 654 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 154 "lm-applet.gob"
void 
lm_applet_set_preferences_width (LMApplet * self, gint val)
#line 660 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_preferences_width"
{
#line 149 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "preferences_width", val, NULL);
}}
#line 667 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 174 "lm-applet.gob"
gint 
lm_applet_get_preferences_height (LMApplet * self)
#line 673 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_preferences_height"
{
#line 164 "lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "preferences_height", &val, NULL); return val;
}}
#line 680 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 169 "lm-applet.gob"
void 
lm_applet_set_preferences_height (LMApplet * self, gint val)
#line 686 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_preferences_height"
{
#line 164 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "preferences_height", val, NULL);
}}
#line 693 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 181 "lm-applet.gob"
static void 
lm_applet_activate (LMApplet * self)
#line 699 "lm-applet.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 181 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 181 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 711 "lm-applet.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 181 "lm-applet.gob"
static void 
___real_lm_applet_activate (LMApplet * self G_GNUC_UNUSED)
#line 727 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::activate"
{
#line 183 "lm-applet.gob"
	
    lm_preferences_display();
  }}
#line 735 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 187 "lm-applet.gob"
static void 
lm_applet_activate_preferences (LMApplet * self)
#line 741 "lm-applet.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 187 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 187 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 753 "lm-applet.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PREFERENCES_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 187 "lm-applet.gob"
static void 
___real_lm_applet_activate_preferences (LMApplet * self G_GNUC_UNUSED)
#line 769 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::activate_preferences"
{
#line 189 "lm-applet.gob"
	
    lm_preferences_display();
  }}
#line 777 "lm-applet.c"
#undef __GOB_FUNCTION__


#line 208 "lm-applet.gob"
static void 
___10_lm_applet_finalize (GObject * object G_GNUC_UNUSED)
#line 784 "lm-applet.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "LM:Applet::finalize"
#line 208 "lm-applet.gob"
	g_return_if_fail (object != NULL);
#line 208 "lm-applet.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 794 "lm-applet.c"
{
#line 210 "lm-applet.gob"
	
    Self *self = SELF(object);
    GSList *l;

    LM_LIST_FOREACH(l, selfp->watches)
      {
	WatchInfo *info = l->data;

	g_source_remove(info->source_id);
	g_io_channel_unref(info->channel);
	g_free(info);
      }
    g_slist_free(selfp->watches);

    if (selfp->reconfigure_timeout_id)
      g_source_remove(selfp->reconfigure_timeout_id);
    
    PARENT_HANDLER(object);
  }}
#line 816 "lm-applet.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 230 "lm-applet.gob"
static gboolean 
lm_applet_factory_cb (PanelApplet * applet, const char * iid, gpointer data)
#line 823 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::factory_cb"
#line 230 "lm-applet.gob"
	g_return_val_if_fail (applet != NULL, (gboolean )0);
#line 230 "lm-applet.gob"
	g_return_val_if_fail (PANEL_IS_APPLET (applet), (gboolean )0);
#line 230 "lm-applet.gob"
	g_return_val_if_fail (iid != NULL, (gboolean )0);
#line 832 "lm-applet.c"
{
#line 234 "lm-applet.gob"
	
    if (! strcmp(iid, "OAFIID:GNOME_LinkMonitorApplet"))
      {
	Self *self = SELF(applet);
	const BonoboUIVerb menu_verbs[] = {
	  BONOBO_UI_VERB("LinkMonitorPreferences", self_preferences_cb),
	  BONOBO_UI_VERB("LinkMonitorHelp", self_help_cb),
	  BONOBO_UI_VERB("LinkMonitorAbout", self_about_cb),
	  BONOBO_UI_VERB_END
	};
	GSList *gconf_hosts;
	GSList *l;
	gpointer applet_pointer = &lm_applet;

	GDK_THREADS_ENTER();

	lm_applet = self;
	g_object_add_weak_pointer(G_OBJECT(self), applet_pointer);
	
	panel_applet_set_flags(applet, PANEL_APPLET_EXPAND_MINOR);
	panel_applet_add_preferences(applet, "/schemas/apps/link-monitor-applet/prefs", NULL);
	panel_applet_setup_menu_from_file(applet, DATADIR, "GNOME_LinkMonitorApplet.xml", NULL, menu_verbs, applet);

	LM_LIST_FOREACH(l, lm_sockets_get())
          {
	    const LMSocket *sock = l->data;

	    if (! sock->init_error)
	      {
		WatchInfo *info;
		
		info = g_new(WatchInfo, 1);
		info->channel = g_io_channel_unix_new(sock->desc);
		info->sock = sock;
		info->applet = self;

		info->source_id = g_io_add_watch_full(info->channel, G_PRIORITY_HIGH, G_IO_IN, self_socket_read_cb, info, NULL);
		selfp->watches = g_slist_append(selfp->watches, info);
	      }
	  }

	selfp->delay = panel_applet_gconf_get_int(applet, CONF_DELAY, NULL);
	if (selfp->delay < LM_HOST_MIN_DELAY)
	  selfp->delay = LM_HOST_MIN_DELAY;
      
	selfp->timeout = panel_applet_gconf_get_int(applet, CONF_TIMEOUT, NULL);
	if (selfp->timeout < LM_HOST_MIN_TIMEOUT)
	  selfp->timeout = LM_HOST_MIN_TIMEOUT;

	selfp->scale = panel_applet_gconf_get_int(applet, CONF_SCALE, NULL);
	if (selfp->scale < MIN_SCALE)
	  selfp->scale = MIN_SCALE;

	selfp->preferences_width = panel_applet_gconf_get_int(applet, CONF_PREFERENCES_WIDTH, NULL);
	if (! selfp->preferences_width)
	  selfp->preferences_width = DEFAULT_PREFERENCES_WIDTH;

	selfp->preferences_height = panel_applet_gconf_get_int(applet, CONF_PREFERENCES_HEIGHT, NULL);
	if (! selfp->preferences_height)
	  selfp->preferences_height = DEFAULT_PREFERENCES_HEIGHT;

	gconf_hosts = panel_applet_gconf_get_list(applet, CONF_HOSTS, GCONF_VALUE_STRING, NULL);
	LM_LIST_FOREACH(l, gconf_hosts)
	  self_add_host_internal(self, l->data);
	eel_g_slist_free_deep(gconf_hosts);

	self_configure(self);
	self_update_tooltip(self);

	g_object_connect(self,
			 "signal::button-press-event", self_button_press_event_h, NULL,
			 "signal::change-orient", self_reconfigure, NULL,
			 "signal::change-size", self_reconfigure, NULL,
			 NULL);

	gtk_widget_show(GTK_WIDGET(self));

	GDK_THREADS_LEAVE();

	return TRUE;
      }

    return FALSE;
  }}
#line 919 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 319 "lm-applet.gob"
static gboolean 
lm_applet_socket_read_cb (GIOChannel * source, GIOCondition condition, gpointer data)
#line 925 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::socket_read_cb"
#line 319 "lm-applet.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 930 "lm-applet.c"
{
#line 323 "lm-applet.gob"
	
    WatchInfo *info = data;
    LMICMPReply reply;

    GDK_THREADS_ENTER();

    if (lm_icmp_receive(info->sock, &reply))
      {
	GSList *l;

	LM_LIST_FOREACH(l, info->applet->_priv->hosts)
          {
	    LMHost *host = l->data;
	  
	    if (lm_host_get_seq(host) == reply.seq)
	      {
		if (reply.echo_reply)
		  lm_host_set_roundtrip_time(host, reply.roundtrip_time);
		else
		  lm_host_set_error(host, reply.description);
	      }
	  }
      }

    GDK_THREADS_LEAVE();
    
    return TRUE;		/* keep source */
  }}
#line 961 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 352 "lm-applet.gob"
static void 
lm_applet_reconfigure (LMApplet * self)
#line 967 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reconfigure"
#line 352 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 352 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 974 "lm-applet.c"
{
#line 354 "lm-applet.gob"
	
    if (selfp->reconfigure_timeout_id)
      /* cancel the previously queued reconfigure */
      g_source_remove(selfp->reconfigure_timeout_id);

    /* do not flood the panel with reconfigures, queue it */
    selfp->reconfigure_timeout_id = g_timeout_add(10, self_reconfigure_timeout_cb, self);
  }}
#line 985 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 363 "lm-applet.gob"
static gboolean 
lm_applet_reconfigure_timeout_cb (gpointer data)
#line 991 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reconfigure_timeout_cb"
#line 363 "lm-applet.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 996 "lm-applet.c"
{
#line 365 "lm-applet.gob"
	
    Self *self = data;
    GSList *l;

    GDK_THREADS_ENTER();

    self_configure(self);
    LM_LIST_FOREACH(l, selfp->hosts)
      {
	self_configure_progress_bar(self, l->data);
	self_update_progress_bar(self, l->data);
      }
    
    GDK_THREADS_LEAVE();

    return FALSE;		/* remove source */
  }}
#line 1016 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 383 "lm-applet.gob"
static gboolean 
lm_applet_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 1022 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::button_press_event_h"
#line 383 "lm-applet.gob"
	g_return_val_if_fail (widget != NULL, (gboolean )0);
#line 383 "lm-applet.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (widget), (gboolean )0);
#line 383 "lm-applet.gob"
	g_return_val_if_fail (event != NULL, (gboolean )0);
#line 1031 "lm-applet.c"
{
#line 387 "lm-applet.gob"
	
    if (event->button == 1 && event->type == GDK_2BUTTON_PRESS)
      {
	self_activate(SELF(widget));
	return TRUE;		/* do not propagate event */
      }

    return FALSE;		/* propagate event */
  }}
#line 1043 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 397 "lm-applet.gob"
static void 
lm_applet_preferences_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 1049 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::preferences_cb"
#line 397 "lm-applet.gob"
	g_return_if_fail (user_data != NULL);
#line 1054 "lm-applet.c"
{
#line 401 "lm-applet.gob"
	
    Self *self = user_data;

    self_activate_preferences(self);
  }}
#line 1062 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 407 "lm-applet.gob"
static void 
lm_applet_help_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 1068 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::help_cb"
#line 407 "lm-applet.gob"
	g_return_if_fail (user_data != NULL);
#line 1073 "lm-applet.c"
{
#line 411 "lm-applet.gob"
	
    lm_display_help(NULL);
  }}
#line 1079 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 415 "lm-applet.gob"
static void 
lm_applet_about_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 1085 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::about_cb"
#line 415 "lm-applet.gob"
	g_return_if_fail (user_data != NULL);
#line 1090 "lm-applet.c"
{
#line 419 "lm-applet.gob"
	
    Self *self = user_data;
    static const char *authors[] = { "Jean-Yves Lefort <jylefort@brutele.be>", NULL };
    static const char *documenters[] = { "Jean-Yves Lefort <jylefort@brutele.be>", NULL };
    GdkPixbuf *logo;

    if (selfp->about)
      {
	gtk_window_present(GTK_WINDOW(selfp->about));
	return;
      }

    logo = lm_pixbuf_new(GNOMEPIXMAPSDIR G_DIR_SEPARATOR_S "link-monitor-applet.png");
    selfp->about = gnome_about_new(_("Link Monitor"),
				   VERSION,
				   "Copyright \302\251 2004, 2005 Jean-Yves Lefort",
				   _("The Link Monitor displays the round-trip time to one or more hosts."),
				   authors,
				   documenters,
				   _("Jean-Yves Lefort <jylefort@brutele.be>"),
				   logo);
    g_object_unref(logo);

    g_object_add_weak_pointer(G_OBJECT(selfp->about), (gpointer *) &selfp->about);
    gtk_widget_show(selfp->about);
  }}
#line 1119 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 446 "lm-applet.gob"
static void 
lm_applet_configure (LMApplet * self)
#line 1125 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::configure"
#line 446 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 446 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1132 "lm-applet.c"
{
#line 448 "lm-applet.gob"
	
    GSList *l;
    GtkWidget *child;

    /* ref the progress bars to keep them alive when we'll remove the box */
    LM_LIST_FOREACH(l, selfp->hosts)
      {
	LMHost *host = l->data;
	GtkWidget *progress_bar;

	progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
	g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

	g_object_ref(progress_bar);
	gtk_object_sink(GTK_OBJECT(progress_bar));
      }
  
    child = gtk_bin_get_child(GTK_BIN(self));
    if (child)
      gtk_container_remove(GTK_CONTAINER(self), child);

    if (selfp->hosts)
      {
	switch (panel_applet_get_orient(PANEL_APPLET(self)))
	  {
	  case PANEL_APPLET_ORIENT_UP:
	  case PANEL_APPLET_ORIENT_DOWN:
	    child = gtk_hbox_new(FALSE, BAR_SPACING);
	    break;
	    
	  case PANEL_APPLET_ORIENT_LEFT:
	  case PANEL_APPLET_ORIENT_RIGHT:
	    child = gtk_vbox_new(FALSE, BAR_SPACING);
	    break;
      
	  default:
	    g_return_if_reached();
	  }

	LM_LIST_FOREACH(l, selfp->hosts)
          {
	    LMHost *host = l->data;
	    GtkWidget *progress_bar;

	    progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
	    g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

	    gtk_box_pack_start(GTK_BOX(child), progress_bar, FALSE, FALSE, 0);
	    gtk_widget_show(progress_bar);

	    g_object_unref(progress_bar);
	  }
      }
    else
      {
	GdkPixbuf *pixbuf;
	
	pixbuf = lm_pixbuf_new(GNOMEPIXMAPSDIR G_DIR_SEPARATOR_S "link-monitor-applet.png");
	if (pixbuf)
	  {
	    int size;
	    GdkPixbuf *scaled;

	    size = panel_applet_get_size(PANEL_APPLET(self)) - (ICON_PADDING * 2);
	    scaled = gdk_pixbuf_scale_simple(pixbuf, size, size, GDK_INTERP_BILINEAR);
	    g_object_unref(pixbuf);
	  
	    child = gtk_image_new_from_pixbuf(scaled);
	    g_object_unref(scaled);
	  }
	else			/* use label as fallback */
	  {
	    child = gtk_label_new(_("<span size=\"small\">Link Monitor</span>"));
	    gtk_label_set_use_markup(GTK_LABEL(child), TRUE);
	  }
      }

    gtk_container_add(GTK_CONTAINER(self), child);
    gtk_widget_show(child);
  }}
#line 1215 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 529 "lm-applet.gob"
int 
lm_applet_factory_main (void)
#line 1221 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::factory_main"
{
#line 531 "lm-applet.gob"
	
    return panel_applet_factory_main("OAFIID:GNOME_LinkMonitorApplet_Factory",
				     TYPE_SELF,
				     self_factory_cb,
				     NULL);
  }}
#line 1232 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 538 "lm-applet.gob"
static void 
lm_applet_sync_gconf_hosts (LMApplet * self)
#line 1238 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::sync_gconf_hosts"
#line 538 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 538 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1245 "lm-applet.c"
{
#line 540 "lm-applet.gob"
	
    GSList *gconf_hosts = NULL;
    GSList *l;

    LM_LIST_FOREACH(l, selfp->hosts)
      gconf_hosts = g_slist_append(gconf_hosts, g_strdup(lm_host_get_name(l->data)));

    panel_applet_gconf_set_list(PANEL_APPLET(self),
				CONF_HOSTS,
				GCONF_VALUE_STRING,
				gconf_hosts,
				NULL);
    eel_g_slist_free_deep(gconf_hosts);
  }}
#line 1262 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 555 "lm-applet.gob"
static unsigned int 
lm_applet_get_unique_seq (LMApplet * self)
#line 1268 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_unique_seq"
#line 555 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (unsigned int )0);
#line 555 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (unsigned int )0);
#line 1275 "lm-applet.c"
{
#line 557 "lm-applet.gob"
	
    unsigned int seq = 0;
    GSList *l;
    
  loop:
    LM_LIST_FOREACH(l, selfp->hosts)
      if (lm_host_get_seq(l->data) == seq)
	{
	  seq++;
	  goto loop;
	}

    return seq;
  }}
#line 1292 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 572 "lm-applet.gob"
static LMHost * 
lm_applet_add_host_internal (LMApplet * self, const char * name)
#line 1298 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::add_host_internal"
#line 572 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 572 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 572 "lm-applet.gob"
	g_return_val_if_fail (name != NULL, (LMHost * )0);
#line 1307 "lm-applet.c"
{
#line 574 "lm-applet.gob"
	
    LMHost *host;
    GtkWidget *progress_bar;
    GtkWidget *child;

    host = lm_host_new(name, self_get_unique_seq(self), selfp->delay, selfp->timeout);

    progress_bar = gtk_progress_bar_new();
    g_object_set_data(G_OBJECT(host), KEY_PROGRESS_BAR, progress_bar);

    selfp->hosts = g_slist_append(selfp->hosts, host);
    g_signal_connect(host, "notify", G_CALLBACK(self_host_notify_h), self);

    self_configure_progress_bar(self, host);
    self_update_progress_bar(self, host);
    self_update_tooltip(self);

    child = gtk_bin_get_child(GTK_BIN(self));
    if (child && GTK_IS_BOX(child))
      {
	gtk_box_pack_start(GTK_BOX(child), progress_bar, FALSE, FALSE, 0);
	gtk_widget_show(progress_bar);
      }
    else
      self_configure(self);

    return host;
  }}
#line 1338 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 603 "lm-applet.gob"
static LMHost * 
lm_applet_replace_host_internal (LMApplet * self, LMHost * old, const char * new)
#line 1344 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::replace_host_internal"
#line 603 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 603 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 603 "lm-applet.gob"
	g_return_val_if_fail (old != NULL, (LMHost * )0);
#line 603 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_HOST (old), (LMHost * )0);
#line 603 "lm-applet.gob"
	g_return_val_if_fail (new != NULL, (LMHost * )0);
#line 1357 "lm-applet.c"
{
#line 607 "lm-applet.gob"
	
    GSList *elem;
    unsigned int seq;
    GtkWidget *progress_bar;
    LMHost *new_host;

    elem = g_slist_find(selfp->hosts, old);
    g_return_val_if_fail(elem != NULL, NULL);

    seq = self_get_unique_seq(self);

    progress_bar = g_object_get_data(G_OBJECT(old), KEY_PROGRESS_BAR);
    g_return_val_if_fail(GTK_IS_PROGRESS_BAR(progress_bar), NULL);

    g_object_unref(old);

    new_host = lm_host_new(new, seq, selfp->delay, selfp->timeout);
    g_object_set_data(G_OBJECT(new_host), KEY_PROGRESS_BAR, progress_bar);

    elem->data = new_host;
    g_signal_connect(new_host, "notify", G_CALLBACK(self_host_notify_h), self);

    self_update_progress_bar(self, new_host);
    self_update_tooltip(self);
    
    return new_host;
  }}
#line 1387 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 635 "lm-applet.gob"
static void 
lm_applet_reorder_hosts_internal (LMApplet * self, GSList * new_hosts)
#line 1393 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reorder_hosts_internal"
#line 635 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 635 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1400 "lm-applet.c"
{
#line 637 "lm-applet.gob"
	
    GSList *l;

    lm_g_object_slist_free(selfp->hosts);
    selfp->hosts = lm_g_object_slist_copy(new_hosts);

    self_update_tooltip(self);
    self_configure(self);
    
    LM_LIST_FOREACH(l, selfp->hosts)
      self_update_progress_bar(self, l->data);
  }}
#line 1415 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 650 "lm-applet.gob"
static void 
lm_applet_remove_host_internal (LMApplet * self, LMHost * host)
#line 1421 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::remove_host_internal"
#line 650 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 650 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 650 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 650 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1432 "lm-applet.c"
{
#line 652 "lm-applet.gob"
	
    GSList *elem;
    GtkWidget *progress_bar;

    elem = g_slist_find(selfp->hosts, host);
    g_return_if_fail(elem != NULL);

    progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
    g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

    selfp->hosts = g_slist_delete_link(selfp->hosts, elem);
    g_object_unref(host);
    gtk_widget_destroy(progress_bar);

    self_update_tooltip(self);
    if (! selfp->hosts)
      self_configure(self);
  }}
#line 1453 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 671 "lm-applet.gob"
static void 
lm_applet_host_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data)
#line 1459 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::host_notify_h"
#line 671 "lm-applet.gob"
	g_return_if_fail (object != NULL);
#line 671 "lm-applet.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 671 "lm-applet.gob"
	g_return_if_fail (pspec != NULL);
#line 671 "lm-applet.gob"
	g_return_if_fail (user_data != NULL);
#line 1470 "lm-applet.c"
{
#line 675 "lm-applet.gob"
	
    LMHost *host = LM_HOST(object);
    const char *name = g_param_spec_get_name(pspec);
    Self *self = user_data;

    if (! strcmp(name, "alive") || ! strcmp(name, "roundtrip-time"))
      self_update_progress_bar(self, host);
    else if (! strcmp(name, "status"))
      self_update_tooltip(self);
  }}
#line 1483 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 686 "lm-applet.gob"
static void 
lm_applet_configure_progress_bar (LMApplet * self, LMHost * host)
#line 1489 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::configure_progress_bar"
#line 686 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 686 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 686 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 686 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1500 "lm-applet.c"
{
#line 688 "lm-applet.gob"
	
    GtkWidget *progress_bar;

    progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
    g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

    switch (panel_applet_get_orient(PANEL_APPLET(self)))
      {
      case PANEL_APPLET_ORIENT_UP:
      case PANEL_APPLET_ORIENT_DOWN:
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_BOTTOM_TO_TOP);
	gtk_widget_set_size_request(progress_bar, BAR_THICKNESS, -1);
	break;
	  
      case PANEL_APPLET_ORIENT_LEFT:
      case PANEL_APPLET_ORIENT_RIGHT:
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_LEFT_TO_RIGHT);
	gtk_widget_set_size_request(progress_bar, -1, BAR_THICKNESS);
	break;
      
      default:
	g_return_if_reached();
      }
  }}
#line 1527 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 713 "lm-applet.gob"
static void 
lm_applet_update_progress_bar (LMApplet * self, LMHost * host)
#line 1533 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::update_progress_bar"
#line 713 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 713 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 713 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 713 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1544 "lm-applet.c"
{
#line 715 "lm-applet.gob"
	
    GtkWidget *progress_bar;

    progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
    g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

    if (lm_host_get_alive(host))
      {
	double fraction;

	fraction = lm_host_get_roundtrip_time(host) / selfp->scale;
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress_bar), CLAMP(fraction, 0.0, 1.0));
	gtk_widget_modify_bg(progress_bar, GTK_STATE_NORMAL, NULL);
      }
    else
      {
	const GdkColor color = { 0, 0xFFFF, 0x0000, 0x0000 }; /* red */
      
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress_bar), 0);
	gtk_widget_modify_bg(progress_bar, GTK_STATE_NORMAL, &color);
      }
  }}
#line 1569 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 738 "lm-applet.gob"
static void 
lm_applet_update_tooltip (LMApplet * self)
#line 1575 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::update_tooltip"
#line 738 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 738 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1582 "lm-applet.c"
{
#line 740 "lm-applet.gob"
	
    GString *tip;
    GSList *l;

    tip = g_string_new(NULL);
    LM_LIST_FOREACH(l, selfp->hosts)
      {
	LMHost *host = l->data;
	const char *name;
	const char *ip;
	const char *status;

	if (*tip->str)
	  g_string_append_c(tip, '\n');

	name = lm_host_get_name(host);
	ip = lm_host_get_ip(host);
	status = lm_host_get_status(host);

	if (ip && strcmp(ip, name))
	  g_string_append_printf(tip, "\342\200\242 %s (%s): %s", name, ip, status);
	else
	  g_string_append_printf(tip, "\342\200\242 %s: %s", name, status);
      }

    if (! *tip->str)
      g_string_assign(tip, _("No host is being monitored."));
  
    lm_set_tooltip(GTK_WIDGET(self), tip->str);
    g_string_free(tip, TRUE);
  }}
#line 1616 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 772 "lm-applet.gob"
LMHost * 
lm_applet_add_host (LMApplet * self, const char * name)
#line 1622 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::add_host"
#line 772 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 772 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 772 "lm-applet.gob"
	g_return_val_if_fail (name != NULL, (LMHost * )0);
#line 1631 "lm-applet.c"
{
#line 774 "lm-applet.gob"
	
    LMHost *host;

    host = self_add_host_internal(self, name);
    self_sync_gconf_hosts(self);

    return host;
  }}
#line 1642 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 783 "lm-applet.gob"
LMHost * 
lm_applet_replace_host (LMApplet * self, LMHost * old, const char * new)
#line 1648 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::replace_host"
#line 783 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 783 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 783 "lm-applet.gob"
	g_return_val_if_fail (old != NULL, (LMHost * )0);
#line 783 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_HOST (old), (LMHost * )0);
#line 783 "lm-applet.gob"
	g_return_val_if_fail (new != NULL, (LMHost * )0);
#line 1661 "lm-applet.c"
{
#line 787 "lm-applet.gob"
	
    LMHost *new_host;

    new_host = self_replace_host_internal(self, old, new);
    self_sync_gconf_hosts(self);

    return new_host;
  }}
#line 1672 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 796 "lm-applet.gob"
void 
lm_applet_reorder_hosts (LMApplet * self, GSList * new_hosts)
#line 1678 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reorder_hosts"
#line 796 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 796 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1685 "lm-applet.c"
{
#line 798 "lm-applet.gob"
	
    self_reorder_hosts_internal(self, new_hosts);
    self_sync_gconf_hosts(self);
  }}
#line 1692 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 803 "lm-applet.gob"
void 
lm_applet_remove_host (LMApplet * self, LMHost * host)
#line 1698 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::remove_host"
#line 803 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 803 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 803 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 803 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1709 "lm-applet.c"
{
#line 805 "lm-applet.gob"
	
    self_remove_host_internal(self, host);
    self_sync_gconf_hosts(self);
  }}
#line 1716 "lm-applet.c"
#undef __GOB_FUNCTION__
