/*
 * $Id: lm-host.h,v 1.2 2004/07/15 23:22:02 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LM_HOST_H
#define _LM_HOST_H

#include <glib-object.h>

#define LM_TYPE_HOST		(lm_host_get_type())
#define LM_HOST(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), LM_TYPE_HOST, LMHost))
#define LM_HOST_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), LM_TYPE_HOST, LMHostClass))
#define LM_IS_HOST(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), LM_TYPE_HOST))
#define LM_IS_HOST_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), LM_TYPE_HOST))
#define LM_HOST_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), LM_TYPE_HOST, LMHostClass))

/* keep in sync with preferences.glade */
#define LM_HOST_MIN_DELAY	1000
#define LM_HOST_MIN_TIMEOUT	100

typedef struct _LMHostPrivate LMHostPrivate;

typedef struct
{
  GObject		object;

  LMHostPrivate		*priv;
} LMHost;

typedef struct
{
  GObjectClass		parent_class;
} LMHostClass;

GType lm_host_get_type (void);

const char *lm_host_get_name (LMHost *host);
const char *lm_host_get_ip (LMHost *host);
unsigned int lm_host_get_seq (LMHost *host);
gboolean lm_host_get_alive (LMHost *host);
const char *lm_host_get_status (LMHost *host);

void lm_host_set_delay (LMHost *host, unsigned int delay);
unsigned int lm_host_get_delay (LMHost *host);

void lm_host_set_timeout (LMHost *host, unsigned int timeout);
unsigned int lm_host_get_timeout (LMHost *host);

void lm_host_set_roundtrip_time (LMHost *host, double roundtrip_time);
double lm_host_get_roundtrip_time (LMHost *host);

void lm_host_set_error (LMHost *host, const char *error);
const char *lm_host_get_error (LMHost *host);

LMHost *lm_host_new (const char *name,
		     unsigned int seq,
		     unsigned int delay,
		     unsigned int timeout);

#endif /* _LM_HOST_H */
