LINGOT - Afinador de instrumentos musicales

Escrito por:
  Ibn Cereijo Graa <comominimo@hotpop.com>
  Jairo Chapela Martnez <jairocm@wanadoo.es>

Copyright (C) 2004, 2005 Ibn Cereijo Graa, Jairo Chapela martnez,
		   Graciano Carrillo Pousa.

Descripcin
===========

	Lingot es un afinador de instrumentos musicales, preciso, fcil de usar
y altamente configurable. Originalmente concebido para afinar guitarras elc-
tricas, su configurabilidad le da un carcter ms general (la afinacin de otro
tipo de instrumentos todava no ha sido testada).

	Simula el aspecto de un afinador analgico con una aguja que indica la
desviacin respecto a una nota dada, encontrada automticamente como la nota 
ms cercana a la frecuencia estimada, indicando dicha nota y frecuencia.

	La nota ser encontrada de forma automtica, no teniendo un modo de
funcionamiento manual (indicar manualmente la nota que queremos afinar), para
mantener la generalidad.

	Recomendamos usar el afinador conjuntamente con un mezclador para 
seleccionar la fuente de grabacin y los niveles de seal.

Requisitos
==========

	* Tarjeta de sonido.
	* Kernel linux con soporte para audio (OSS).
	* librera GTK+ 2.0.
	
Instalacin
===========

	Consulta el archivo INSTALL

Parmetros de entrada
=====================

	lingot [-c configuracion]

busca en el directorio ~/.lingot/ un archivo llamado {configuracion}.conf

por ejemplo:

	lingot -c bass

Tomar la configuracin del archivo ~/.lingot/bass.conf, esto es til para
mantener varias configuraciones correspondientes a varios instrumentos.

Archivo de configuracin
========================

	Al lanzarse por primera vez se crear el archivo de configuracin:
~/.lingot/lingot.conf

Las opciones se pueden cambiar tambin en el GUI, y recomendamos cambiarlas
desde esta interfaz. Sus valores por defecto estn optimizados para afinar
guitarra elctrica, para otros instrumentos debe ser retocado (es buena idea
guardar un archivo de configuracin por cada instrumento, y utilizar la 
opcin -c para cargar una configuracin u otra).

Con la finalidad de mantener la mxima configurabilidad, el usuario dispone de
multitud de opciones, y la comprensin total del efecto de las mismas requiere 
conocimientos de procesado de seal, a continuacin se intentar explicar el
efecto de cada una, pero si no se comprende el resultado lo mejor es no 
cambiarlas. No se descarta en futuras versiones reducir el nmero de opciones
para hacer el afinador ms manejable.


Describimos las opciones que encontraremos en este archivo, y recomendamos su
manipulacin en funcin de la precisin de afinado obtenida y la potencia de
clculo requerida.

AUDIO_DEV (dispositivo de sonido)

	 Dispositivo de audio seleccionado.

SAMPLE_RATE (frecuencia de muestreo)

	 Frecuencia a la que ser muestreada la seal de entrada por la tarjeta
	 de sonido. No todas las tarjetas soportan cualquier valor para esta 
	 opcin, y recomendamos escoger una de las opciones que proporciona
	 el GUI:

	  8000 Hz
	 11025 Hz
	 22050 Hz
	 44100 Hz

	 Podremos encontrar una frecuencia efectiva de muestreo submltiplo de 
	 la que pongamos aqu mediante el factor de sobremuestreo.

	 Para seleccionar una frecuencia de muestreo debemos tener en cuenta la
	 frecuencia mxima que queramos afinar en nuestro instrumento, y poner
	 la frecuencia efectiva de muestreo (ya dividida por el factor de 
	 sobremuestreo) al menos al doble de esa frecuencia (criterio de 
	 Nyquist). Todas las componentes frecuenciales por encima de la mitad
	 de la frecuencia de muestreo efectiva sern filtradas y no aparecern
	 en el espectro.

	 Se expresa como un numero entero, en herzios.

OVERSAMPLING (factor de sobremuestreo)

 	 Indica el factor por el que se va a diezmar la seal muestreada, 
	 consiguiendo una frecuencia de muestreo efectiva equivalente a la de
	 muestreo real de la tarjeta de sonido dividido por este factor.

	 Por ejemplo, para conseguir una frecuencia de muestreo efectiva de 
         4 KHz (podemos afinar tonos de hasta 2 KHz) pondremos una frecuencia 
	 de muestreo de 8 KHz y un factor de sobremuestreo de 2.

	 Debe ser un numero entero. Adimensional.

ROOT_FREQUENCY_ERROR (error de la nota de referencia LA)

	 Cuando queremos afinar con un cierto error de desplazamiento en
	 frecuencia. Esto es til cuando queremos adaptar la afinacin del
	 instrumento a la de una grabacin que tiene una afinacin desplazada.

	 Por ejemplo, si escuchamos que un LA en una grabacin se encuentra
	 un cuarto de tono por encima del que debera ser (440 Hz), pondremos
	 un error del 50% (el error se expresa en porcentaje 
	 de semitonos). 

	 Se expresa como un nmero real en tanto por uno (0.5 expresa un error
	 del 50%). 
	 
FFT_SIZE (tamao FFT)

	 Un valor elevado proporciona mayor precisin, sobre todo mayor 
	 precisin de enganche con la frecuencia deseada, pero supone mayor
	 potencia de clculo.

	 Debe tenerse en cuenta antes de subir este valor innecesariamente 
	 el intervalo temporal de clculo que implica: tener un buffer de 4096
	 muestras para la FFT con una frecuencia de muestreo efectiva de 8 KHz
	 implica que cada transformada necesita valores temporales de los 
	 ltimos 512 ms, as pues no tiene sentido poner una ventana temporal
	 menor. Este parmetro influye en la respuesta temporal del afinador.

	 Veamos un ejemplo ms extremo:

	 Supongamos que tenemos un instrumento capaz de generar frecuencias 
	 bajas (< 200 Hz), y por tanto ponemos una frecuencia de muestreo de
	 400 Hz (frecuencia de 8 KHz y factor de sobremuestreo de 20). Con el
	 fin de obtener la mxima precisin inicial establecemos 4096 muestras 
	 para el buffer de FFT, esto implicar que la ventana temporal mnima 
	 debe ser 10.24 segundos, es decir, en cada afinacin tenemos sonidos 
  	 de hasta hace 10.24 segundos contaminando la afinacin, dicho en otras
	 palabras, tendremos que esperar 10.24 segundos entre nota y nota para
	 no interferir.

	 Ntese que el espectro slo muestra 256 muestras, y para valores altos
	 de este parmetro puede cuadrar la frecuencia fundamental encontrada
	 fuera del campo de visin (de momento no est implementado un visor
	 que se desplace en frecuencia)

	 Debe ser un numero entero potencia de 2.
	 
TEMPORAL_WINDOW (ventana temporal)

	 Indica la cantidad de seal en tiempo que se usa para aproximar la
	 frecuencia final. Cuanto mayor sea este valor, ms preciso ser el
	 resultado, pero de respuesta ms lenta y ms contaminada por notas
	 anteriores.

	 Como regla prctica diremos que si tenemos una ventana temporal de 1 
	 segundo, debemos esperar 1 segundo entre nota y nota para obtener la 
	 afinacin. As pues, este parmetro repercute directamente en la 
	 respuesta dinmica del afinador.

	 La ventana temporal en muestras (obtenida como la multilpicacin de su
	 duracin en segundos y la frecuencia efectiva de muestreo) debe ser
	 mayor que el buffer de FFT.

	 Se expresa como un nmero real, en segundos.

NOISE_THRESHOLD (umbral de ruido)

 	 Para no afinar ruido establecemos un umbral distinguiendo lo que es 
	 ruido y lo que es seal. Establzcase empricamente y aydese de un
	 mezclador para los niveles de potencia.

	 Es un nmero real expresado en dB.

CALCULATION_RATE (frecuencia de clculo)

	 Cuantos ms clculos por segundo mayor sensacin dinmica nos dar el
	 afinador, pero necesitar mayor potencia de clculo.

VISUALIZATION_RATE (frecuencia de visualizacin)

	 Tiene impacto en la sensacin de dinamismo conseguida, pero menos en
	 la potencia de clculo necesaria.

	 No tiene sentido que la frecuencia de clculo sea mayor que la de 
	 visualizacin.

PEAK_NUMBER (nmero de picos)

	 Para la identificacin del pico fundamental debemos tener en cuenta,
	 en funcin de las caractersticas del timbre generado por el 
	 instrumento, el nmero de picos armnicos (en frecuencias mltiplos de
	 la fundamental) que pueden superar en magnitud al pico fundamental 
	 (hasta la relacin sealada en la siguiente opcin).

PEAK_REJECTION_RELATION (relacin de rechazo de picos)

	 Cualquier pico cuya magnitud tenga con la magnitud del pico mximo una
	 relacin mayor que la sealada ser descartado (caractersticas del
	 timbre del instrumento).

	 Es un nmero real expresado en dB.

PEAK_ORDER (orden de pico)

	 Nmero de muestras necesarias para considerar un pico como tal. La 
	 correcta afinacin de este parmetro depender del tipo de timbre del
	 instrumento, y ms de la resolucin espectral obtenida mediante la
	 frecuencia efectiva de muestreo y el tamao de FFT, ntese que 
	 considerar N muestras en la FFT implica un intervalo frecuencial 
	 variable dependiendo de aquellos parmetros.

DFT_NUMBER (nmero de DFTs)

	 Tras encontrar el pico mximo en la FFT se hacen un cierto nmero de
	 DFTs localizadas en frecuencia para cercar ms la frecuencia 
	 aproximada antes de lanzar la aproximacin final por mtodo iterativo
	 (Newton-Raphson).

	 Cuantas ms DFTs ms precisin de enganche tenemos, pero ms potencia
	 de clculo necesitamos.

DFT_SIZE (tamao de las DFTs)

	 Tamao en muestras de las DFTs, cuanto mayor sea, ms precisin de
	 enganche, pero mayor potencia de clculo necesaria.


Funcionamiento
==============

	Consulta la documentacin tcnica.

