#!/usr/bin/perl -w

# Copyright (C) 2005  J. Santiago Hirschfeld <jsantiagoh@yahoo.com.ar>
#
# This program is free software; 
# you can redistribute it and/or modify it under the same terms as Perl itself.

use strict;
use File::Find qw(find);
use Gtk2::GladeXML;
use Gtk2::SimpleList;
use DBI;
use MP3::Info; 
use Ogg::Vorbis::Header::PurePerl;
use Data::Dumper;

my $VERSION		= 0.1;
my $BASE_DIR		= "./";
my $PLAYLIST_FILE	= $BASE_DIR . "playlist.m3u";
my $DATABASE 		= $BASE_DIR . "database";
my $PLAY_COMMAND	= "beep-media-player";
my $PLAY_ARGS		= "-p";
my $GLADE_FILE		= $BASE_DIR . 'limusina.glade';

my $extensiones = "mp3|ogg";

# Comprobar que el directorio exista
if ( (!-d "$BASE_DIR")  ) {
    print "Directorio no existe!\n";
    print " * Creando Directorio base...\n";
    mkdir("$BASE_DIR");
    print " * Directorio base creado\n";
}

# Conexin a la base de datos
my $database = DBI->connect( "dbi:SQLite:musica.db" ) or 
    die "No puedo conectarme: $DBI::errstr";

# Crea la tabla correspondiente en la base de datos si no existe
if ( !table_exists($database,'musica') ) { 
    db_crear();
}

my $db_agregar_registro = $database->prepare("INSERT INTO musica
			(archivo, titulo, artista, album, genero,
			duracion, pista, anio, comentario)
			VALUES (?,?,?,?,?,?,?,?,?)");

print "Iniciando Limusina $VERSION\n";

Gtk2->init;

my $main_window = Gtk2::GladeXML->new($GLADE_FILE);
$main_window->signal_autoconnect_from_package('main');
gtk_inicializar();
Gtk2->main;


################################################################################
#
#	Funciones
#
################################################################################


###
#   table_exists($db,$table)
#   comprueba si una tabla ($table) existe en una base de datos ($db), sacado
#   de http://www.perlmonks.com/?node_id=284436
################################################################################
sub table_exists {
    my $db = shift;
    my $table = shift;
    my @tables = $db->tables('','','','TABLE');
    if (@tables) {
        for (@tables) {
            next unless $_;
            return 1 if $_ eq $table
        }
    }
    else {
        eval {
            local $db->{PrintError} = 0;
            local $db->{RaiseError} = 1;
            $db->do(qq{SELECT * FROM $table WHERE 1 = 0 });
        };
        return 1 unless $@;
    }
    return 0;
}

###
#  db_crear()
################################################################################
sub db_crear {
    $database->do("CREATE TABLE musica (ekey INTEGER PRIMARY KEY,
		    archivo		VARCHAR(30),
		    titulo		VARCHAR(30),
		    artista		VARCHAR(30),
		    album		VARCHAR(30),
		    genero		VARCHAR(30),
		    duracion	DATE,
		    rating		INTEGER,
		    pista		INTEGER,
		    anio		INTEGER,
		    comentario	TEXT,
		    reproducir	BOOLEAN)");
}

###
#  save_playlist ($playlist_file, @archivos)
#  Grabar la lista seleccionada para ser reproducida en formato m3u
################################################################################
sub save_playlist {
    my ($playlist, @archivos) = @_;
    open (PLAYLIST, ">$playlist") or die "$!: $playlist";
    foreach my $archivo(sort @archivos) {
	print PLAYLIST "$archivo\n";
    }
    close(PLAYLIST);
}

###
#  cargar_playlist( $playlist_file)
################################################################################
sub cargar_playlist {
    my $pf = shift;
    my $playlist_widget = $main_window->get_widget('treeview_playlist');
    open (PLAYLIST, "<$pf") or die "$!: $pf";
    while (<PLAYLIST>) {
	chomp;
	my $archivo = $_;
	my %temp_hash = informacion_archivo($archivo);
	push @{$playlist_widget->{data}}, [ $temp_hash{Titulo},
				     $temp_hash{Artista},
				     $temp_hash{Album},
				     $archivo ];
    }
    close(PLAYLIST);
}

###
#  informacion_archivo($archivo)
################################################################################
sub informacion_archivo {
    my $archivo = shift;
    return if ($archivo eq '');

    my %file_tag;

    # Por ahora identifico el archivo solamente determinando la extensin,
    # cambiar eso para usar un magicfile o algo parecido
    $archivo =~ m/.*\.(\w+)$/i;
    my $extension = $1;
    
    if (lc($extension) eq 'mp3') {
	# MP3
	my $tag  = get_mp3tag($archivo);
	$file_tag{titulo}  	= $tag->{TITLE};
	$file_tag{artista} 	= $tag->{ARTIST};
	$file_tag{album}   	= $tag->{ALBUM};
	$file_tag{genero}  	= $tag->{GENRE};
	$file_tag{anio}	 	= $tag->{YEAR};
	$file_tag{pista}	= $tag->{TRACKNUM};
	$file_tag{duracion} 	= 0;
	$file_tag{comentario} 	= '';
    } elsif (lc($extension) eq 'ogg') {
	# OGG
	my $tag = Ogg::Vorbis::Header::PurePerl->new($archivo);
	#$file_tag{titulo}  	= $tag->comment('TITLE');
	#$file_tag{artista} 	= $tag->comment('ARTIST');
	#$file_tag{album}   	= $tag->comment('ALBUM');
	#$file_tag{genero}  	= $tag->comment('GENRE');
	#$file_tag{anio}	 	= $tag->comment('DATE');
	#$file_tag{pista}	= $tag->comment('TRACKNUMBER');

	# Si, esta es una solucin muy mugrienta, pero como no se como tomar el
	# primer valor del array que me devuelve $ogg, voy a tener que seguir
	# haciendolo asi
	my @aux = $tag->comment('TITLE');
	$file_tag{titulo}  	= $aux[0];
	@aux = $tag->comment('ARTIST');
	$file_tag{artista} 	= $aux[0];
	@aux = $tag->comment('ALBUM');
	$file_tag{album}   	= $aux[0];
	@aux = $tag->comment('GENRE');
	$file_tag{genero}  	= $aux[0];
	@aux = $tag->comment('DATE');
	$file_tag{anio}	 	= $aux[0];
	@aux = $tag->comment('TRACKNUMBER');
	$file_tag{pista}	= $aux[0];
	$file_tag{duracion} 	= 0;
	$file_tag{comentario} 	= '';
    }
    
    $file_tag{titulo} = 'Desconocido' if ($file_tag{titulo} eq '');
    $file_tag{album} = 'Desconocido' if ($file_tag{album} eq '');
    $file_tag{artista} = 'Desconocido' if ($file_tag{artista} eq '');
    $file_tag{genero}= 'Desconocido' if ($file_tag{genero} eq '');
    
    return %file_tag;
}

###
#  agregar_archivo()
#  Llamada por File::Find::find en on_agregar_directorio
#  si encuentra un archivo que coincide con las extensiones, lo agrega a
#  la lista
################################################################################
sub agregar_archivo {
    my $archivo = $File::Find::name;
    if ( $archivo =~ /($extensiones)$/i) {
	my %file_tag = informacion_archivo($archivo);
	
	$db_agregar_registro->execute(	
					$archivo,
					$file_tag{titulo},
					$file_tag{artista},
					$file_tag{album},
					$file_tag{genero},
					$file_tag{duracion},
					$file_tag{pista},
					$file_tag{anio},	
					$file_tag{comentario}
				    );
    }
}

###
#  MarcarReproduccion(@nombres_archivo)
#  Marca de la base de datos el flag de reproducir de los archivos dados en
#  @archivos
################################################################################
sub MarcarReproduccion {
    my @archivos = @_;
    my $cadena_sql;
    $cadena_sql = "UPDATE musica 
		SET reproducir = 1 
		WHERE ( ";
    
    $cadena_sql .= "archivo=\"$archivos[0]\"";
    foreach my $i (1..$#archivos) {
	$cadena_sql .= ") OR ( archivo=\"$archivos[$i]\"";
    }
    $cadena_sql .= ")";
    $database->do($cadena_sql);
}

###
#  DesmarcarReproduccion(@nombres_archivo)
#  Desmarca de la base de datos el flag de reproducir de los archivos dados en
#  @archivos
################################################################################
sub DesmarcarReproduccion {
    my @archivos = @_;
    foreach my $archivo (@archivos) {
    $database->do("UPDATE musica 
		SET reproducir = 0 
		WHERE archivo=\"$archivo\"");
    }
}

################################################################################
#
#  Funciones de la interfaz grfica
#
################################################################################

###
#  gtk_inicializar
#  Funcin de inicializacin de la ventana principal
################################################################################
sub gtk_inicializar {

    #Inicializar lista de canciones
    my $treeview = $main_window->get_widget('treeview_canciones');
    my $widget= Gtk2::SimpleList->new_from_treeview($treeview, (  
						#' R '		=> 'bool',
						'Titulo'	=> 'text',
						'Artista' 	=> 'text',
						'Album'		=> 'text',
						'Archivo'	=> 'text',
					    ));
    $widget->get_selection->set_mode ('multiple');
    #$cambio_columna_id = $songlist_widget->get_model->signal_connect(
    #			'row-changed' => \&on_treeview_canciones_row_mod);
    #			'has-child-toggled' => \&on_treeview_canciones_row_mod);

    #Inicializar lista de Artistas
    $treeview = $main_window->get_widget('treeview_filtro_sup');
    $widget= Gtk2::SimpleList->new_from_treeview($treeview,
							'filtro_sup' => 'text');
    $widget->get_selection->set_mode ('multiple');
    $widget->get_selection->signal_connect(
			changed => \&on_treeview_filtro_sup_cursor_changed);

    ##Inicializar lista de Albums
    $treeview = $main_window->get_widget('treeview_filtro_inf');
    $widget= Gtk2::SimpleList->new_from_treeview($treeview,
							'filtro_inf' => 'text');
    $widget->get_selection->set_mode('multiple');
    $widget->get_selection->signal_connect(
			changed => \&on_treeview_filtro_inf_cursor_changed);

    ##Inicializar lista de Seleccin de Playlist
    $treeview = $main_window->get_widget('treeview_playlist');
    $widget= Gtk2::SimpleList->new_from_treeview($treeview, (  
						#' R '		=> 'bool',
						'Titulo'	=> 'text',
						'Artista' 	=> 'text',
						'Album'		=> 'text',
						'Archivo'	=> 'text',
					    ));
    $widget->get_selection->set_mode('multiple');


    # Horizontal Paned Window
    $widget= $main_window->get_widget('panel_horizontal');
    $widget->set_position(200);
    
    # Vertical Paned Window
    $widget= $main_window->get_widget('panel_artista_album');
    $widget->set_position(250);
    
    # Vertical Paned Window
    $widget= $main_window->get_widget('panel_temas_lista');
    $widget->set_position(250);

    $widget= $main_window->get_widget('combobox_filtro_sup');
    $widget->set_active(0);
    
    $widget= $main_window->get_widget('combobox_filtro_inf');
    $widget->set_active(1);
    
    $widget= $main_window->get_widget('combobox_buscar');
    $widget->set_active(0);

    actualizar_lista_filtro_sup();
    actualizar_playlist();
}

###
#  actualizar_lista_filtro_sup()
################################################################################
sub actualizar_lista_filtro_sup {
    print " ! actualizar_lista_filtro_sup\n";
    my $widget_lista_sup= $main_window->get_widget('treeview_filtro_sup');
    my $widget_filtro_sup = $main_window->get_widget('combobox_filtro_sup');
    my @combo_filtro = ('artista','album','genero','anio','rating');

    @{$widget_lista_sup->{data}} = (); 

    my $indice = $widget_filtro_sup->get_active();
    
    # referencia a un array que contiene arrays con los datos
    my $filas = $database->selectall_arrayref("SELECT DISTINCT 
			    $combo_filtro[$indice] 
			    FROM musica
			    ORDER BY $combo_filtro[$indice]"); 
    
    foreach my $fila ( @{$filas} ) {	
	push @{$widget_lista_sup->{data}} ,$fila ;
    }

}

###
#  actualizar_lista_filtro_inf()
################################################################################
sub actualizar_lista_filtro_inf {
    print (" ! actualizar_lista_filtro_inf\n");
    # Widget de la lista del filtro superior
    my $widget_lista_sup= $main_window->get_widget('treeview_filtro_sup');
    my @valores_sup= $widget_lista_sup->get_selected_indices();
    if ($#valores_sup == -1) {
	print "No hay valores seleccionados en la lista superior\n";
	return;
    }

    my $widget_lista_inf= $main_window->get_widget('treeview_filtro_inf');
    my $widget_filtro_sup = $main_window->get_widget('combobox_filtro_sup');
    my $widget_filtro_inf  = $main_window->get_widget('combobox_filtro_inf');
    my @combo_filtro = ('artista','album','genero','anio','rating');

    @{$widget_lista_inf->{data}} = ();

    # Indice del combo superior, accedo a la categoria con
    #   $combo_filtro[$indice_sup]
    my $indice_sup = $widget_filtro_sup->get_active();
    # Indice del combo inferior, accedo a la categoria con
    #   $combo_filtro[$indice_inf]
    my $indice_inf = $widget_filtro_inf->get_active();

    # Valores seleccionados en el filtro superior

    # este array contiene las palabritas del filtro superior
    my @array_valores_sup = @{$widget_lista_sup->{data}}[@valores_sup];

    #Categoria del filtro superior
    my $cat_sup = $combo_filtro[$indice_sup];

    my $cadena_select = "SELECT DISTINCT $combo_filtro[$indice_inf] 
			    FROM musica WHERE ";

    # Columna de la lista (solo una)--------------------------
    #                                                        V
    # Fila de la lista-----------------------------------    V
    #                                                   V    V
    $cadena_select .= "($cat_sup = \"$array_valores_sup[0]->[0]\")";

    foreach my $columna (1..$#array_valores_sup) {
	$cadena_select .= "OR 
			($cat_sup = \"$array_valores_sup[$columna]->[0]\")";
    }

    $cadena_select .= " ORDER BY $combo_filtro[$indice_inf]";


    my $filas = $database->selectall_arrayref($cadena_select);
    
    foreach my $fila ( @{$filas} ) {	
	push @{$widget_lista_inf->{data}} ,$fila ;
    }

    $widget_lista_inf->get_selection->select_all();
}

###
#  actualizar_lista_canciones()
################################################################################
sub actualizar_lista_canciones {
    print (" ! actualizar_lista_canciones()\n");
    
    my $widget_lista_canciones = $main_window->get_widget('treeview_canciones');
    my @combo_filtro = ('artista','album','genero','anio','rating');
    
    # NO VOY A HACER LAS COSAS ASI TODAVIA
    # Bloquear la seal de cambio en fila del modelo de la lista de canciones
    #$widget_lista_canciones->signal_handler_block(
    #			    $widget_lista_canciones->{$cambio_columna_id});
    
    my $widget_filtro_sup   = $main_window->get_widget('combobox_filtro_sup');
    my $widget_filtro_inf   = $main_window->get_widget('combobox_filtro_inf');
    my $widget_combo_buscar = $main_window->get_widget('combobox_buscar');
    my $widget_lista_sup= $main_window->get_widget('treeview_filtro_sup');
    my $widget_lista_inf= $main_window->get_widget('treeview_filtro_inf');
    my $widget_entry_buscar    = $main_window->get_widget('entry_buscar');
    
    # Categorias seleccionadas en los combos superior e inferior
    my $cat_sup = $combo_filtro[$widget_filtro_sup->get_active()];
    my $cat_inf = $combo_filtro[$widget_filtro_inf->get_active()];

    # Array de Valores filtro superiores
    my @valores_sup = $widget_lista_sup->get_selected_indices();
    # Array de Valores filtro inferiores
    my @valores_inf = $widget_lista_inf->get_selected_indices();

    @{$widget_lista_canciones->{data}} = ();

    my $cadena_buscar = $widget_entry_buscar->get_text();

    #my $cadena_sup = ${$widget_lista_sup->{data}}[$valores_sup[0]][0];
    #my $cadena_inf = ${$widget_lista_inf->{data}}[$valores_inf[0]][0];

    #################################################
    # Mejorar esto urgente por que este cdigo apesta
    #################################################
    
    # Inicio de la cadena de select de bsqueda
    my $cadena_select = "SELECT titulo,artista,album,archivo	
		FROM musica WHERE ( "; 

    # Recorrer cada uno de los valores del filtro superior, el 0 indica que es
    # la primer columna de la lista la que me interesa (osea la nica)
    my @array_valores = @{$widget_lista_sup->{data}}[@valores_sup];
    $cadena_select.=
		"($cat_sup = \"$array_valores[0]->[0]\")";
    foreach my $i (1..$#array_valores) {
	$cadena_select .= 
	    "OR ($cat_sup = \"$array_valores[$i]->[0]\") ";
    }
    
    
    # Esta es la parte donde me fijo que las canciones que van a mostrarse
    # correspondan con el segundo filtro que puse
    if ($#valores_inf == 0) {
	$cadena_select .= " ) AND ( " ;
	@array_valores = @{$widget_lista_inf->{data}}[@valores_inf];
	$cadena_select .= "($cat_inf = \"$array_valores[0]->[0]\")";
	foreach my $i (1..$#array_valores) {
	    $cadena_select .= 
		"OR ($cat_inf = \"$array_valores[$i]->[0]\") ";
	}
    }

    # Ahora agregar la parte de seleccin del entry de arriba de la lista de
    # canciones
    my @combo_titulos = ('titulo','artista','album','genero','anio','rating');
    my $cat_buscar = $combo_titulos[$widget_combo_buscar->get_active()];
    $cadena_select .= " ) AND ( 
	    $cat_buscar LIKE \"\%$cadena_buscar\%\" )";
    
    # bien, con todo el select listo, quiero ver que filitas tengo
    my $filas = $database->selectall_arrayref($cadena_select);
		
    
    # Ya tengo todas las filas, ahora, agregalas, pero antes... debloqueame la
    # seal de columna cambiada de ac por que me hace pelota todo.
    foreach my $fila ( @{$filas} ) {	
	push @{$widget_lista_canciones->{data}} , ( $fila );
    }

    # Listo, ahora conectala denuevo
    #$widget_lista_canciones->signal_handler_block(
    #			    $widget_lista_canciones->{$cambio_columna_id});
}

###
#  actualizar_playlist()
################################################################################
sub actualizar_playlist {
    print(" ! actualizar_playlist()\n");
    my $widget_playlist = $main_window->get_widget('treeview_playlist');
    my $filas = $database->selectall_arrayref("SELECT 
		titulo,artista,album,archivo	
		FROM musica WHERE reproducir ");

    @{$widget_playlist->{data}} = ();
    
    foreach my $fila ( @{$filas} ) {	
	push @{$widget_playlist->{data}} , ( $fila );
    }
}


################################################################################
#
#	Callbacks de la interfaz grfica
#
################################################################################

###
#  on_combobox_filtro_sup_changed()
################################################################################
sub on_combobox_filtro_sup_changed {
    print("on_combobox_filtro_sup_changed()\n");
    actualizar_lista_filtro_sup();
}

###
#  on_combobox_filtro_inf_changed()
################################################################################
sub on_combobox_filtro_inf_changed {
    print("on_combobox_filtro_inf_changed()\n");
    actualizar_lista_filtro_inf();
}

###
#  on_treeview_filtro_sup_cursor_changed();
################################################################################
sub on_treeview_filtro_sup_cursor_changed {
    my $self = shift;
    print("on_treeview_filtro_sup_changed()\n");
    actualizar_lista_filtro_inf();
}

### 
#  on_treeview_filtro_inf_cursor_changed
################################################################################
sub on_treeview_filtro_inf_cursor_changed {
    print("on_treeview_filtro_inf_changed()\n");
    actualizar_lista_canciones();
}

### 
#  on_treeview_canciones_row_mod(	Gtk2::TreeView,
#  					Gtk2::TreePath,
#  					Gtk2::TreeViewColumn)
#  
#  Llamado cuando se modifica un valor en la lista de canciones 
################################################################################
sub on_treeview_canciones_row_mod {
#    print("on_treeview_canciones_row_mod()\n");
#    #my ($treemodel,$treepath,$treeiter) = @_;
#    my  ($treeview,$treepath,$treeviewcolumn) = @_;
#    
#    my @indices = $treeview->get_selected_indices();
#    my $archivo = ${$treeview->{data}}[$indices[0]][3];
#    my $estado  = ${$treeview->{data}}[$indices[0]][0];
#    $estado = ( $estado == 0 ) ? 1 : 0;
#    ${$treeview->{data}}[$indices[0]][0] = $estado;
#    $database->do("UPDATE musica 
#		SET reproducir = $estado 
#		WHERE archivo=\"$archivo\"");
#	    
#    
#    actualizar_playlist();
#
}

###
#  on_entry_buscar_changed()
################################################################################
sub on_entry_buscar_changed {
    actualizar_lista_canciones();
}

###
#  on_on_toolbutton_agregar_dir_clicked($button)
#  Click en botn de agregar directorio en la barra de herramientas superior
################################################################################
sub on_toolbutton_agregar_dir_clicked {
    my $self = shift;
    
    # Dialogo selector de directorios
    my $selector = Gtk2::FileChooserDialog->new('Agregar directorio de msica',
			undef,
			'GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER',
			( 'Cancelar' => 'GTK_RESPONSE_CANCEL', 
			'Abrir' => 'GTK_RESPONSE_ACCEPT')
		    );
    my $respuesta = $selector->run();
    my $archivo = '';
    if ($respuesta eq 'accept') {
	$archivo = $selector->get_filename();
    } else {
	$selector->destroy();
	return;
    }
    $selector->destroy();

    # Buscar Archivos dentro de directorio seleccionado y agregarlos a la base
    # de datos 
    File::Find::find( \&agregar_archivo, $archivo );

    actualizar_lista_filtro_sup();
} 

sub on_toolbutton_agregar_temas_clicked {
    my $widget_lista_canciones = $main_window->get_widget('treeview_canciones');
    my @i_canciones = $widget_lista_canciones->get_selected_indices();
    
    if (@i_canciones == 0) {
	my $max = scalar(@{$widget_lista_canciones->{data}})-1;
	@i_canciones = (0 .. $max);
    }
    
    my @archivos;
    
    foreach ( @i_canciones ) {
	push @archivos, ${$widget_lista_canciones->{data}}[$_][3];
    }
    
    MarcarReproduccion(@archivos);
    actualizar_playlist();
}

sub on_toolbutton_quitar_clicked {
    my $widget_playlist = $main_window->get_widget('treeview_playlist');
    my @i_canciones = $widget_playlist->get_selected_indices();
    my @archivos;
    
    foreach ( @i_canciones ) {
	push @archivos, ${$widget_playlist->{data}}[$_][3];
    }
    
    DesmarcarReproduccion(@archivos);
    actualizar_playlist();
}

sub on_toolbutton_actualizar_clicked {
    actualizar_playlist();
}

sub on_toolbutton_limpiar_clicked {
    $database->do("UPDATE musica SET reproducir = 0");
    actualizar_playlist();
}

sub on_toolbutton_reproducir_clicked {
    my $self = shift;
    my $playlist_widget = $main_window->get_widget('treeview_playlist');
    my @playlist = ();
    foreach my $tema (@{$playlist_widget->{data}}) {
	push @playlist,$tema->[3];
    }

    save_playlist($PLAYLIST_FILE,@playlist);
    system($PLAY_COMMAND,$PLAY_ARGS,$PLAYLIST_FILE,'&');
}

###
#  on_menu_acerca_de_activate(nose)
################################################################################
sub on_menu_acerca_de_activate {
    my $dialogo_acerca_de = $main_window->get_widget('about_dialog');
    $dialogo_acerca_de->show_all();
}

###
#  on_okbutton_about_clicked($button)
################################################################################
sub on_okbutton_about_clicked {
    my $self= shift;
    $self->get_toplevel->hide;
}

###
#  gtk_main_quit
#  Salir del Programa
################################################################################
sub gtk_main_quit
{
    $database->disconnect();
    Gtk2->main_quit;
}
