/* libunwind - a platform-independent unwind library
   Copyright (C) 2001-2002 Hewlett-Packard Co
	Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 2.1 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public
License.  */

/* This illustrates the basics of using the unwind interface for
   exception handling.  */

#include <stdio.h>
#include <stdlib.h>
#include <unwind.h>

#define panic(args...)				\
	{ fprintf (stderr, args); exit (-1); }

int true = 1;

static void
raise_exception (void *addr)
{
  unw_cursor_t cursor;
  unw_word_t ip, rp;
  ucontext_t uc;

  getcontext (&uc);
  if (unw_init_local (&cursor, &uc) < 0)
    panic ("unw_init_local() failed!\n");

  /* unwind to frame b(): */
  if (unw_step (&cursor) < 0)
    panic ("unw_step() failed!\n");

  unw_get_reg (&cursor, UNW_REG_IP, &ip);
  unw_get_reg (&cursor, UNW_REG_RP, &rp);
  printf ("ip = %lx, rp = %lx\n", ip, rp);

  if (unw_set_reg (&cursor, UNW_REG_RP, (unw_word_t) addr) < 0)
    panic ("unw_set_reg() failed!\n");

  unw_resume (&cursor);	/* transfer control to exception handler */
}

static void
b (void *addr)
{
  printf ("b() calling raise_exception()\n");
  raise_exception (addr);
}

static int
a (void)
{
  b (&&handler);
  printf ("unexpected return from func()!\n");

  if (true)
    return -1;

 handler:
  printf ("exception handler: here we go...\n");
  return 0;
}

int
main (int argc, char **argv)
{
  if (a () == 0)
    printf ("test succeeded!\n");
  else
    printf ("bummer: test failed; try again?\n");
  return 0;
}
