/* libunwind - a platform-independent unwind library
   Copyright (C) 2001-2002 Hewlett-Packard Co
	Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 2.1 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public
License.  */

#include "rse.h"
#include "unwind_i.h"

int
__ia64_unw_init_remote (unw_cursor_t *cursor, unw_accessors_t *a)
{
  struct ia64_cursor *c = (struct ia64_cursor *) cursor;
  unw_word_t cfm, sol, bsp;
  int i;

  if (unw.first_time)
    {
      unw.first_time = 0;
      __ia64_unw_init ();
    }

  c->acc = *a;

  if (ia64_get (c, IA64_REG_LOC (UNW_IA64_SP), &c->sp) < 0)
    return -1;

  c->psp = c->sp;

  c->cfm_loc = IA64_REG_LOC (UNW_IA64_AR_PFS);

  if (ia64_get (c, c->cfm_loc, &cfm) < 0)
    return -1;

  if (ia64_get (c, IA64_REG_LOC (UNW_IA64_AR_BSP), &bsp) < 0)
    return -1;

  sol = (cfm >> 7) & 0x7f;
  c->bsp = (unsigned long) ia64_rse_skip_regs((unsigned long *) bsp, -sol);
  c->rbs_top = c->bsp;

  if (ia64_get (c, IA64_REG_LOC (UNW_IA64_BR + 0), &c->ip) < 0)
    return -1;

  if (ia64_get (c, IA64_REG_LOC (UNW_IA64_PR), &c->pr) < 0)
    return -1;

  c->top_rnat_loc =	IA64_REG_LOC (UNW_IA64_AR_RNAT);
  c->bsp_loc =		IA64_REG_LOC (UNW_IA64_AR_BSP);
  c->bspstore_loc =	IA64_REG_LOC (UNW_IA64_AR_BSP);
  c->pfs_loc =		IA64_REG_LOC (UNW_IA64_AR_PFS);
  c->rnat_loc =		IA64_REG_LOC (UNW_IA64_AR_RNAT);
  c->rp_loc =		IA64_REG_LOC (UNW_IA64_BR + 0);
  c->pri_unat_loc =	0;	/* no primary UNaT location */
  c->unat_loc =		IA64_REG_LOC (UNW_IA64_AR_UNAT);
  c->pr_loc =		IA64_REG_LOC (UNW_IA64_PR);
  c->lc_loc =		IA64_REG_LOC (UNW_IA64_AR_LC);
  c->fpsr_loc =		IA64_REG_LOC (UNW_IA64_AR_FPSR);

  c->r4_loc = IA64_REG_LOC (UNW_IA64_GR + 4);
  c->r5_loc = IA64_REG_LOC (UNW_IA64_GR + 5);
  c->r6_loc = IA64_REG_LOC (UNW_IA64_GR + 6);
  c->r7_loc = IA64_REG_LOC (UNW_IA64_GR + 7);

  c->nat4_loc = IA64_REG_LOC (UNW_IA64_NAT + 4);
  c->nat5_loc = IA64_REG_LOC (UNW_IA64_NAT + 5);
  c->nat6_loc = IA64_REG_LOC (UNW_IA64_NAT + 6);
  c->nat7_loc = IA64_REG_LOC (UNW_IA64_NAT + 7);

  c->b1_loc = IA64_REG_LOC (UNW_IA64_BR + 1);
  c->b2_loc = IA64_REG_LOC (UNW_IA64_BR + 2);
  c->b3_loc = IA64_REG_LOC (UNW_IA64_BR + 3);
  c->b4_loc = IA64_REG_LOC (UNW_IA64_BR + 4);
  c->b5_loc = IA64_REG_LOC (UNW_IA64_BR + 5);

  c->f2_loc = IA64_FPREG_LOC (UNW_IA64_FR + 2);
  c->f3_loc = IA64_FPREG_LOC (UNW_IA64_FR + 3);
  c->f4_loc = IA64_FPREG_LOC (UNW_IA64_FR + 4);
  c->f5_loc = IA64_FPREG_LOC (UNW_IA64_FR + 5);
  for (i = 16; i <= 31; ++i)
    c->fr_loc[i - 16] = IA64_FPREG_LOC (UNW_IA64_FR + i);

  c->flags = 0;

  return __ia64_unw_find_save_locs (c);
}

weak_alias (__ia64_unw_init_remote, unw_init_remote)
