/* window.h: Prototypes and declarations for window.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RUIN_WINDOW_H
#define RUIN_WINDOW_H

#include <curses.h>
#include <glib.h>
#include <libguile.h>
#include <signal.h>
#include <stdio.h>

#include "util.h"
#include "xml.h"

#define RUIN_WINDOW_SCM_HASH_SIZE	256

#define RUIN_WINDOW_FONT_HEIGHT_ENV "RUIN_FONT_HEIGHT"
#define RUIN_WINDOW_FONT_WIDTH_ENV "RUIN_FONT_WIDTH"
#define RUIN_WINDOW_DPI_ENV "RUIN_DPI"

#define RUIN_WINDOW_DEFAULT_FONT_HEIGHT 16
#define RUIN_WINDOW_DEFAULT_FONT_WIDTH   8
#define RUIN_WINDOW_DEFAULT_DPI         96

typedef struct _ruin_window_render_state_t {
  enum ruin_xml_dialect dialect;
  int active_pseudo_elements;
} ruin_window_render_state_t;

typedef struct _ruin_window_t {
  WINDOW *window;
  FILE *log;

  int font_height;
  int font_width;
  int dpi;

  int width;
  int height;

  long internal_id;

  struct _ruin_util_hash *ids;
  struct _ruin_util_hash *internal_ids;

  SCM cascade;
  SCM selection_context;
  struct _ruin_window_render_state_t *render_state;

  GList *root_boxes;
  
  short render_requested;
} ruin_window_t;

typedef struct _ruin_windows_t {
  GHashTable *windows;
  SCM xul_agent_css;
  SCM xhtml_agent_css;

  struct _ruin_window_t *current_window;
} ruin_windows_t;

ruin_window_t *ruin_window_new (WINDOW *, FILE *);
void ruin_window_clear (ruin_window_t *);
void ruin_window_free (ruin_window_t *);

ruin_windows_t *ruin_windows_new ();
void ruin_windows_free (ruin_windows_t *);

ruin_window_t *ruin_get_current_window ();
void ruin_set_current_window (ruin_window_t *);

ruin_window_t *ruin_window_get_current_window ();
void ruin_window_set_current_window (ruin_window_t *);

struct _ruin_node_t *ruin_window_lookup_scm (SCM elt);
ruin_window_t *ruin_window_lookup_window (SCM elt);

/* Because I'm a moron and can't figure out how else to prototype this... */
void ruin_util_log (ruin_window_t *, char *, ...);
void ruin_window_signal_handler_SIGWINCH (int, siginfo_t *, void *);

#endif /* RUIN_WINDOW_H */
