/* text.h: Prototypes and declarations for text.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

#include "box.h"

typedef struct _ruin_layout_text_fragment
{
  int char_width;
  int real_width;
  int break_required;
  char *content_ptr;
} ruin_layout_text_fragment;

typedef struct _ruin_layout_text_analysis
{
  GList *fragments;
} ruin_layout_text_analysis;

typedef struct _ruin_layout_text_context
{
  int first_letter;
  int first_line;

  int first_on_line;
  int last_in_region;
  GList *width_constraints;
} ruin_layout_text_context;

typedef struct _ruin_layout_text_line_width_constraint 
{
  int width;
  int extent;
} ruin_layout_text_line_width_constraint;

ruin_layout_text_analysis *ruin_layout_text_analyze
(ruin_inline_box_t *, ruin_layout_text_context *);

void ruin_layout_text_analysis_free (ruin_layout_text_analysis *, int);
