/* util.h: Prototypes and declarations for util.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef RUIN_TEST_UTIL_H
#define RUIN_TEST_UTIL_H

#include <glib.h>
#include <libguile.h>

#include "../parse.h"
#include "../window.h"

typedef struct {
  ruin_window_t *window;
  ruin_node_t *node;
} box_generation_fixture;

typedef struct _box_generation_fixture_component_t {
  struct _box_generation_fixture_component_t *parent;
  enum ruin_parse_node_type node_type;
} box_generation_fixture_component_t;

typedef struct _component_fixture_generation_context {
  struct _component_fixture_generation_strategy *strategy;
  GHashTable *component_box_map;
  ruin_window_t *window;
} component_fixture_generation_context;

typedef struct _component_fixture_generation_strategy {
  ruin_box_t *(*root_box_constructor)
    (component_fixture_generation_context *, gconstpointer);
  ruin_box_t *(*box_constructor)
    (component_fixture_generation_context *, gconstpointer);
} component_fixture_generation_strategy;

typedef struct _box_generation_element_fixture_component_t {
  struct _box_generation_fixture_component_t base;

  GHashTable *style;
} box_generation_element_fixture_component_t;

typedef struct _box_generation_text_fixture_component_t {
  struct _box_generation_fixture_component_t base;

  char *content;
} box_generation_text_fixture_component_t;

typedef struct _box_fixture {
  ruin_window_t *window;
  ruin_box_t *viewport_box;
  ruin_box_t *root_box;
} box_fixture;

typedef struct _box_layout_fixture_component_t {
  enum ruin_layout_box_type type;
  struct _box_layout_fixture_component_t *parent;
  struct _box_layout_fixture_component_t *containing_block;

  GHashTable *style;
  char *content_ptr;
} box_layout_fixture_component_t;

typedef struct _box_layout_marker_fixture_component_t {
  box_layout_fixture_component_t base;
  
  enum ruin_layout_list_style_type style;
  int ordinal;
  int length;
} box_layout_marker_fixture_component_t;

typedef struct _render_fixture_component_t {
  box_layout_fixture_component_t *layout;

  int top;
  int left;

  int width;
  int height;

  int padding_top;
  int padding_left;
  int padding_bottom;
  int padding_right;

  int margin_top;
  int margin_left;
  int margin_bottom;
  int margin_right;

  int letter_spacing;
  int word_spacing;
} render_fixture_component_t;

box_generation_element_fixture_component_t *
box_generation_element_fixture_component_new 
(GHashTable *, box_generation_fixture_component_t *);

box_generation_text_fixture_component_t *
box_generation_text_fixture_component_new 
(char *, box_generation_fixture_component_t *);

box_layout_fixture_component_t *box_layout_fixture_component_new
(GHashTable *, box_layout_fixture_component_t *, 
 box_layout_fixture_component_t *);

render_fixture_component_t *
render_fixture_component_new
(GHashTable *, render_fixture_component_t *, render_fixture_component_t *);

render_fixture_component_t *
marker_render_fixture_component_new
(GHashTable *, render_fixture_component_t *, render_fixture_component_t *);

void setup_box_layout_fixture (box_fixture *, gconstpointer);
void setup_box_layout_fixture_single (box_fixture *, gconstpointer);
void teardown_box_fixture (box_fixture *, gconstpointer);

void setup_render_fixture (box_fixture *, gconstpointer);
void setup_render_fixture_single (box_fixture *, gconstpointer);
void teardown_render_fixture (box_fixture *, gconstpointer);

void setup_window_fixture (ruin_window_t *, gconstpointer);
void teardown_window_fixture (ruin_window_t *, gconstpointer);

void setup_box_generation_fixture (box_generation_fixture *, gconstpointer);
void teardown_box_generation_fixture (box_generation_fixture *, gconstpointer);

ruin_node_element_t *mock_root_element (ruin_window_t *, GHashTable *);
ruin_node_element_t *mock_element (ruin_window_t *, SCM, GHashTable *);
ruin_node_text_t *mock_text_node (ruin_window_t *, SCM, char *);

#endif /* RUIN_TEST_UTIL_H */
