#include <glib.h>
#include <ncurses.h>
#include <stdio.h>
#include <stdlib.h>

#include "../box.h"
#include "../render.h"
#include "../scheme.h"
#include "../window.h"
#include "util.h"

void test_render_list_item_marker_circle (box_fixture *f, gconstpointer d)
{
  chtype ch = 0;

  ruin_render_render_tree (f->root_box);

  wmove (f->root_box->window->window, 0, 0);
  ch = winch (f->root_box->window->window);
  g_assert_cmpint ('o', ==, ch & A_CHARTEXT);
}

void test_render_list_item_marker_disc (box_fixture *f, gconstpointer d)
{
  chtype ch = 0;

  ruin_render_render_tree (f->root_box);

  wmove (f->root_box->window->window, 0, 0);
  ch = winch (f->root_box->window->window);
  g_assert_cmpint ('*', ==, ch & A_CHARTEXT);
}

int main (int argc, char *argv[])
{
  int ret = 0;
  FILE *dev_null = fopen ("/dev/null", "w+");
  SCREEN *screen = NULL;
  
  g_test_init (&argc, &argv, NULL);

  screen = newterm (NULL, dev_null, stdin);
  set_term (screen);
  start_color ();

  scm_init_guile ();
  ruin_init ();

  { render_fixture_component_t *c = marker_render_fixture_component_new
      (g_hash_table_new (g_str_hash, g_str_equal), NULL, NULL);    
    box_layout_marker_fixture_component_t *m = 
      (box_layout_marker_fixture_component_t *) c->layout;

    GList *render_components = g_list_append (NULL, c);

    m->style = RUIN_LAYOUT_LIST_STYLE_TYPE_CIRCLE;
    m->ordinal = 1;
    m->length = 1;

    c->layout->type = RUIN_LAYOUT_BOX_TYPE_MARKER;
    c->word_spacing = 2;
    c->height = 1;
    c->width = 1;

    g_test_add ("/render/list-item/marker/circle", 
		box_fixture, render_components, setup_render_fixture, 
		test_render_list_item_marker_disc, teardown_box_fixture);
  }

  { render_fixture_component_t *c = render_fixture_component_new
      (g_hash_table_new (g_str_hash, g_str_equal), NULL, NULL);
    GList *render_components = g_list_append (NULL, c);

    c->layout->type = RUIN_LAYOUT_BOX_TYPE_MARKER;
    c->word_spacing = 2;
    c->height = 1;
    c->width = 1;

    g_test_add ("/render/list-item/marker/disc", 
		box_fixture, render_components, setup_render_fixture, 
		test_render_list_item_marker_disc, teardown_box_fixture);
  }

  ret = g_test_run ();

  endwin ();
  fclose (dev_null);

  return ret;
}
