#include <glib.h>
#include <ncurses.h>
#include <stdio.h>
#include <stdlib.h>

#include "../box.h"
#include "../css.h"
#include "../load.h"
#include "../parse.h"
#include "../scheme.h"
#include "../window.h"
#include "util.h"

typedef struct _marker_fixture_config {
  GHashTable *properties;
  enum ruin_layout_list_style_type style;
  int ordinal;
  int length;
} marker_fixture_config;

void setup_marker_box_layout_fixture (box_fixture *f, gconstpointer d)
{
  ruin_box_t *viewport_box = ruin_box_new 
    (RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK, NULL, NULL, f->window, NULL);
  marker_fixture_config *config = (marker_fixture_config *) d;
  
  f->window = ruin_window_new
    (newwin (10, 20, 0, 0), fopen ("/dev/null", "w+"));
  setup_window_fixture (f->window, d);

  f->root_box = (ruin_box_t *) ruin_marker_box_new 
    (RUIN_LAYOUT_BOX_TYPE_MARKER, NULL, viewport_box, f->window, 
     (ruin_node_t *) mock_root_element (f->window, config->properties), 
     config->style, config->ordinal, config->length);
}

void teardown_marker_box_layout_fixture (box_fixture *f, gconstpointer d)
{
  teardown_window_fixture (f->window, d);
  ruin_window_free (f->window);
}

void test_layout_list_item_marker_disc (box_fixture *f, gconstpointer d)
{
  ruin_layout_layout_elements (g_list_append (NULL, f->root_box));
  
  g_assert_cmpint (1, ==, f->root_box->height.used);
  g_assert_cmpint (1, ==, f->root_box->width.used);
}

int main (int argc, char *argv[])
{
  int ret = 0;
  FILE *dev_null = fopen ("/dev/null", "w+");

  g_test_init (&argc, &argv, NULL);

  GHashTable *simple_block = g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *list_item_outside_disc = 
    g_hash_table_new (g_str_hash, g_str_equal);

  marker_fixture_config simple_disc_marker_config;

  g_hash_table_insert (simple_block, "display", "block");
  
  g_hash_table_insert (list_item_outside_disc, "display", "list-item");
  g_hash_table_insert 
    (list_item_outside_disc, "list-style-position", "outside");
  g_hash_table_insert (list_item_outside_disc, "list-style-type", "disc");

  simple_disc_marker_config.properties = list_item_outside_disc;
  simple_disc_marker_config.style = RUIN_LAYOUT_LIST_STYLE_TYPE_DISC;
  simple_disc_marker_config.ordinal = 1;
  simple_disc_marker_config.length = 1;

  g_test_add ("/box/layout/list-item/marker/disc", box_fixture,
	      &simple_disc_marker_config, setup_marker_box_layout_fixture, 
	      test_layout_list_item_marker_disc,
	      teardown_box_fixture);

  newterm (NULL, dev_null, stdin);
  scm_init_guile ();
  ruin_init ();

  ret = g_test_run ();

  endwin ();
  fclose (dev_null);

  return ret;
}
