/* tables.h: Prototypes and declarations for tables.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RUIN_TABLES_H
#define RUIN_TABLES_H

#include <glib.h>

#include "box.h"
#include "parse.h"

typedef struct _ruin_layout_table {
  ruin_box_t *caption;
  ruin_box_t *node;
  GList *columns;
  GList *rows;
  int width;
} ruin_layout_table;

typedef struct _ruin_layout_table_column {
  ruin_box_t *node;
  GList *cells;
  int width;
} ruin_layout_table_column;

typedef struct _ruin_layout_table_row {
  ruin_box_t *node;
  GList *cells;
} ruin_layout_table_row;

typedef struct _ruin_layout_table_cell {
  ruin_box_t *node;
} ruin_layout_table_cell;

ruin_layout_table *ruin_layout_table_auto (ruin_box_t *);
ruin_layout_table *ruin_layout_table_fixed (ruin_box_t *);
void ruin_layout_table_free (ruin_layout_table *);

#endif /* RUIN_TABLES_H */
