/* modify.c: Default modification event handlers for libRUIN
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <libguile.h>
#include <ncurses.h>

#include "../layout.h"
#include "../render.h"
#include "../scheme.h"
#include "../window.h"

SCM_DEFINE (ruin_scm_default_handler_attr_modified, 
	    "ruin:default-attr-modified-handler", 1, 0, 0, (SCM event), 
	    "Default attribute modification handler.")
{
  /* char *ptr_str =
    scm_to_locale_string(scm_hashq_ref(win->scm_hash, target, SCM_EOL));
    ruin_element_t *tree = (ruin_element_t *) ruin_util_string_to_ptr(ptr_str);
  */
  /* ruin_generate_tree_parse_attrs(tree); */
  return SCM_BOOL_T;
}

SCM_DEFINE (ruin_scm_default_handler_dom_node_inserted, 
	    "ruin:default-node-insertion-handler", 1, 0, 0, (SCM event), 
	    "Default node insertion handler.")
{
  return SCM_BOOL_T;
}

SCM_DEFINE (ruin_scm_default_handler_dom_node_removed, 
	    "ruin:default-node-removal-handler", 1, 0, 0, (SCM event), 
	    "Default node removal handler.")
{
  return SCM_BOOL_T;
}

void _ruin_scm_modify_handlers_init (void)
{
  #include "modify.x"
}
