/* css.h: Prototypes and declarations for css.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RUIN_CSS_H
#define RUIN_CSS_H

#include "layout.h"
#include "parse.h"
#include "util.h"
#include "window.h"

enum _ruin_css_pseudo_element 
  {
    RUIN_CSS_PSEUDO_ELEMENT_BEFORE = 1,
    RUIN_CSS_PSEUDO_ELEMENT_AFTER = 2,
    RUIN_CSS_PSEUDO_ELEMENT_FIRST_LETTER = 4,
    RUIN_CSS_PSEUDO_ELEMENT_FIRST_LINE = 8
  };

#define RUIN_CSS_VALUE_AUTO -1
#define RUIN_CSS_VALUE_NONE -2

char *ruin_css_lookup (ruin_window_t *, ruin_node_t *, char *);
char *ruin_css_lookup_text_style 
(ruin_window_t *, ruin_node_text_t *, char *);
void ruin_css_add_named_style (SCM *, char *, char *, char *);
void ruin_css_add_style (SCM *, char *, char *);

enum ruin_layout_foreground_color ruin_css_match_foreground_color
(ruin_window_t *, char *);
enum ruin_layout_background_color ruin_css_match_background_color
(ruin_window_t *, char *, GList *);

void ruin_css_activate_pseudo_element 
(ruin_window_t *, enum _ruin_css_pseudo_element);
void ruin_css_deactivate_pseudo_element 
(ruin_window_t *, enum _ruin_css_pseudo_element);
int ruin_css_pseudo_element_is_active 
(ruin_window_t *, enum _ruin_css_pseudo_element);

int ruin_css_is_inherited (ruin_window_t *, char *);
char *ruin_css_initial_value (ruin_window_t *, char *);

ruin_length_t ruin_css_parse_size (char *);
ruin_length_t ruin_css_parse_spacing (char *);
void ruin_css_normalize_length 
(ruin_length_t *, ruin_length_t *, int, int, int);

#endif /* RUIN_CSS_H */
