/* win-fns.c: Window-management functions for the libRUIN Scheme API
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <libguile.h>

#include "../css.h"
#include "../layout.h"
#include "../parse.h"
#include "../util.h"
#include "../window.h"

extern ruin_windows_t *_ruin_windows;

SCM ruin_scm_api_window_focus (SCM);

SCM_DEFINE (ruin_scm_api_window_focus_next, "ruin:focus-next", 1, 0, 0,
	    (SCM selt), "Move the focus to the next element.")
{
  ruin_node_t *n = ruin_window_lookup_scm (selt);
  GList *tab_order_ptr = NULL;

  int i = 0, len = 0, call_next = FALSE;

  if (n == NULL)
    return SCM_BOOL_F;
  
  if (TRUE) /* (w->focused == NULL) */
    return SCM_BOOL_F;

  /* len = ruin_util_list_length(w->tab_order); */

  if (len == 0)
    return SCM_BOOL_F;

  /* tab_order_ptr = w->tab_order; */
  for (; i < len; i++) {
    ruin_node_t *t = (ruin_node_t *) tab_order_ptr->data;
    if (call_next)
      return ruin_scm_api_window_focus (t->node);
    /* else if (t == w->focused)
       call_next = TRUE; */
    tab_order_ptr = tab_order_ptr->next;
  }

  return NULL;
  /* return ruin_scm_api_window_focus
     (((ruin_element_t *) w->tab_order->data)->element); */
}

SCM_DEFINE (ruin_scm_api_window_focus_prev, "ruin:focus-prev", 1, 0, 0,
	    (SCM selt), "Move the focus to the previous element.")
{
  ruin_node_t *n = ruin_window_lookup_scm (selt);
  GList *tab_order_ptr = NULL;

  int i = 0, len = 0;

  if (n == NULL)
    return SCM_BOOL_F;
  
  if (TRUE) /* (w->focused == NULL) */
    return SCM_BOOL_F;

  /* len = ruin_util_list_length(w->tab_order); */

  if (len == 0)
    return SCM_BOOL_F;

  /* tab_order_ptr = w->tab_order; */
  for (; i < len; i++) {
    /* ruin_node_t *t = (ruin_node_t *) tab_order_ptr->data;
       if (t == w->focused) {
         if (elt != NULL)
	   return ruin_scm_api_window_focus(t->element);
         else return ruin_scm_api_window_focus
	   (((ruin_element_t *) tab_order_ptr->prev->data)->element);
       }
       else elt = t; 
    */
    tab_order_ptr = tab_order_ptr->next;
  }
  return SCM_BOOL_F;
}

SCM_DEFINE (ruin_scm_api_window_focus, "ruin:focus", 1, 0, 0,
	    (SCM selt), "Move the focus to the specified element.")
{
  ruin_node_t *n = ruin_window_lookup_scm (selt);

  if (n == NULL)
    return SCM_BOOL_F;
  
  /* Are we already focused? */
  
  if (TRUE) /* (w->focused == elt) */
    return SCM_BOOL_T;
  else {
    
    /* Are we in the list of focusable elements? */
    
    /* int found_it = FALSE;
    int tab_length = ruin_util_list_length(w->tab_order), i = 0;
    
    ruin_util_list *tab_order_ptr = w->tab_order;
    
    for (; i < tab_length; i++) {
      ruin_element_t *tmp = tab_order_ptr->data;
      if (tmp == elt) {
	found_it = TRUE;
	break;
      }	  
      tab_order_ptr = tab_order_ptr->next;
    }
    
    if (found_it) {
      ruin_element_t *old = w->focused;
      w->focused = elt;
      if (old != NULL) {
	ruin_util_log(w, "dispatching event sdom:event-dom-focus-out "
		      "on element '%s'\n", "FIXME");
	scm_call_4(scm_c_eval_string("sdom:dispatch-event"),
		   w->focused->element, 
		   scm_str2symbol("sdom:event-dom-focus-out"), 
		   SCM_EOL, SCM_EOL);
      }
      ruin_util_log(w, "dispatching event sdom:event-dom-focus-in on "
		    "element '%s'\n", "FIXME");
      scm_call_4(scm_c_eval_string("sdom:dispatch-event"),
		 w->focused->element, 
		 scm_str2symbol("sdom:event-dom-focus-in"), 
		 SCM_EOL, SCM_EOL);
    */
      /* ruin_scm_api_window_render(w->focused->element); */
    /* } */
  }
  return SCM_BOOL_F;
}

SCM_DEFINE (ruin_scm_api_window_render, "ruin:render", 1, 0, 0, (SCM selt),
	    "Render the window containing the specified element.")
{
  ruin_node_t *n = ruin_window_lookup_scm (selt);
  
  if (n == NULL)
    return SCM_BOOL_F;
  
  return SCM_BOOL_T;
}

void _ruin_scm_window_init_api (void)
{
  #include "win-fns.x"
}
