#include <curses.h>
#include <libguile.h>
#include <libruin.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

void atexit_handler() {
  raise (SIGTRAP);
}

int real_main(int argc, char *argv[]) {
  ruin_window_t *w = NULL;
  FILE *log = NULL;
  int i = 1;

  if (argc < 2) {
    printf("%s: Usage: %s [filename] [filename] ...", argv[0], argv[0]);
    return 1;
  }

  atexit(atexit_handler);

  initscr();
  start_color();
  cbreak();
  noecho();

  ruin_init();
  
  { char *logfilename = calloc(sizeof(char), strlen(argv[0]) + 5);
    snprintf(logfilename, strlen(argv[0]) + 5, "%s.log", argv[0]);
    log = fopen(logfilename, "w");
    free(logfilename);
  }

  w = ruin_window_new(stdscr, log);
  for (; i < argc; i++) {
    int ch;

    ruin_draw_file(w, argv[i]);
    while (ch = getch()) {
      if (ch == 'n') break;
      else ruin_input_send(w, ch);
    }
  } 
 
  pause();

  getch();
  endwin();

  return 0;
}

int main(int argc, char *argv[]) {
  scm_init_guile();
  real_main(argc, argv);
  return 0;
}
