/* scheme.h: Prototypes and declarations for scheme.c
 * Copyright (C) 2006 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef RUIN_SCHEME_H
#define RUIN_SCHEME_H

#include <libguile.h>

int ruin_scheme_scss_is_inherited(SCM);
char *ruin_scheme_sdom_get_dom_property(SCM, char *);
char *ruin_scheme_sdom_get_attribute(SCM, char *);
void ruin_scheme_init();

#if SCM_MAJOR_VERSION == 1 && SCM_MINOR_VERSION < 8
#define scm_from_int32 scm_int2num
#define scm_to_locale_string SCM_STRING_CHARS
#endif

#endif /* RUIN_SCHEME_H */
