/* scheme.c: Initializations for libRUIN's Scheme interface
 * Copyright (C) 2006 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <libguile.h>

#include "scheme.h"

static SCM ruin_scheme_scss_sip_p = SCM_EOL;
static SCM ruin_scheme_sdom_sgdp = SCM_EOL;
static SCM ruin_scheme_sdom_sga = SCM_EOL;

int ruin_scheme_scss_is_inherited(SCM prop) {
  return scm_call_1(ruin_scheme_scss_sip_p, prop) == SCM_BOOL_T ? 1 : 0; 
}

char *ruin_scheme_sdom_get_dom_property(SCM node, char *prop) {
  SCM sprop = scm_makfrom0str(prop);
  SCM ret = scm_call_2(ruin_scheme_sdom_sgdp, node, sprop);
  if (scm_string_p(ret) != SCM_BOOL_T)
    return NULL;
  return SCM_STRING_CHARS(ret);
}

char *ruin_scheme_sdom_get_attribute(SCM node, char *attr) {
  SCM sprop = scm_makfrom0str(attr);
  SCM ret = scm_call_2(ruin_scheme_sdom_sga, node, sprop);
  if (scm_string_p(ret) != SCM_BOOL_T)
    return NULL;
  return SCM_STRING_CHARS(ret);
}

void ruin_scheme_init() {
  ruin_scheme_scss_sip_p = scm_c_eval_string("scss:inherited?");
  ruin_scheme_sdom_sgdp = scm_c_eval_string("sdom:get-dom-property");
  ruin_scheme_sdom_sga = scm_c_eval_string("sdom:get-attribute");
}
