/* attr-fns.c: Attribute-munging functions for the libRUIN Scheme API
 * Copyright (C) 2006 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include <libguile.h>
#include <stdlib.h>
#include <string.h>

#include "attr-fns.h"
#include "../css.h"
#include "../layout.h"
#include "../render.h"
#include "../scheme.h"
#include "../util.h"
#include "../window.h"
#include "../xul.h"

extern ruin_windows_t *_ruin_windows;

SCM ruin_scm_attribute_invert_foreground_color(SCM color) {
  char *input_color;
  char *output_color;
  enum ruin_layout_foreground_color matched_color;
  extern const char *ruin_css_fg_color_hex[];

  SCM return_val;

  SCM_ASSERT(SCM_STRINGP(color), color, SCM_ARG1, 
	     "ruin:invert-foreground-color");

  input_color = scm_to_locale_string(color);
  matched_color = ruin_css_match_foreground_color(input_color);
  switch(matched_color) {
  case RUIN_LAYOUT_FG_COLOR_BLACK: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_WHITE] : "silver"; break;
  case RUIN_LAYOUT_FG_COLOR_RED: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_CYAN] : "teal"; break;
  case RUIN_LAYOUT_FG_COLOR_GREEN: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_MAGENTA] : "purple"; break;
  case RUIN_LAYOUT_FG_COLOR_YELLOW: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BLUE] : "navy"; break;
  case RUIN_LAYOUT_FG_COLOR_BLUE: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_YELLOW] : "olive"; break;
  case RUIN_LAYOUT_FG_COLOR_MAGENTA: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_GREEN] : "green"; break;
  case RUIN_LAYOUT_FG_COLOR_CYAN: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_RED] : "maroon"; break;
  case RUIN_LAYOUT_FG_COLOR_WHITE: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BLACK] : "black"; break;
  case RUIN_LAYOUT_FG_COLOR_BR_BLACK:
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BR_WHITE] : "white"; break;
  case RUIN_LAYOUT_FG_COLOR_BR_RED: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BR_CYAN] : "aqua"; break;
  case RUIN_LAYOUT_FG_COLOR_BR_GREEN: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BR_MAGENTA] : "fuschia"; 
    break;
  case RUIN_LAYOUT_FG_COLOR_BR_YELLOW: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BR_BLUE] : "blue"; break;
  case RUIN_LAYOUT_FG_COLOR_BR_BLUE: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BR_YELLOW] : "yellow"; break;
  case RUIN_LAYOUT_FG_COLOR_BR_MAGENTA: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BR_GREEN] : "lime"; break;
  case RUIN_LAYOUT_FG_COLOR_BR_CYAN: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BR_RED] : "red"; break;
  case RUIN_LAYOUT_FG_COLOR_BR_WHITE:
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_fg_color_hex[RUIN_LAYOUT_FG_COLOR_BR_BLACK] : "gray"; break;
  default: output_color = "silver";
  }

  return_val = scm_makfrom0str(output_color);
  if (input_color[0] == '#')
    return_val = scm_string_append(scm_cons(scm_makfrom0str("#"),
					    scm_cons(return_val, SCM_EOL)));
  return return_val;
}

SCM ruin_scm_attribute_invert_background_color(SCM color) {
  char *input_color;
  char *output_color;
  enum ruin_layout_background_color matched_color;
  extern const char *ruin_css_bg_color_hex[];

  SCM return_val;

  SCM_ASSERT(SCM_STRINGP(color), color, SCM_ARG1, 
	     "ruin:invert-background-color");

  input_color = scm_to_locale_string(color);
  matched_color = ruin_css_match_background_color(input_color, NULL);
  switch(matched_color) {
  case RUIN_LAYOUT_BG_COLOR_BLACK: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_bg_color_hex[RUIN_LAYOUT_BG_COLOR_WHITE] : "silver"; break;
  case RUIN_LAYOUT_BG_COLOR_RED: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_bg_color_hex[RUIN_LAYOUT_BG_COLOR_CYAN] : "teal"; break;
  case RUIN_LAYOUT_BG_COLOR_GREEN: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_bg_color_hex[RUIN_LAYOUT_BG_COLOR_MAGENTA] : "purple"; break;
  case RUIN_LAYOUT_BG_COLOR_YELLOW: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_bg_color_hex[RUIN_LAYOUT_BG_COLOR_BLUE] : "navy"; break;
  case RUIN_LAYOUT_BG_COLOR_BLUE: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_bg_color_hex[RUIN_LAYOUT_BG_COLOR_YELLOW] : "olive"; break;
  case RUIN_LAYOUT_BG_COLOR_MAGENTA: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_bg_color_hex[RUIN_LAYOUT_BG_COLOR_GREEN] : "green"; break;
  case RUIN_LAYOUT_BG_COLOR_CYAN: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_bg_color_hex[RUIN_LAYOUT_BG_COLOR_RED] : "maroon"; break;
  case RUIN_LAYOUT_BG_COLOR_WHITE: 
    output_color = (input_color[0] == '#') ? (char *)
      ruin_css_bg_color_hex[RUIN_LAYOUT_BG_COLOR_BLACK] : "black"; break;
  default: output_color = "black";
  }

  return_val = scm_makfrom0str(output_color);
  if (input_color[0] == '#')
    return_val = scm_string_append(scm_cons(scm_makfrom0str("#"),
					    scm_cons(return_val, SCM_EOL)));
  return return_val;
}
