/* css-fns.c: Style-management functions for the libRUIN Scheme API
 * Copyright (C) 2006 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include "css-fns.h"

#include <libguile.h>
#include <string.h>

#include "../css.h"
#include "../layout.h"
#include "../util.h"
#include "../window.h"

SCM ruin_scm_api_css_get_style(SCM node, SCM property) {
  ruin_element_t *elt = ruin_window_lookup_scm(node);
  if (elt != NULL) {
    char *style = NULL;
    style = ruin_css_lookup(elt, SCM_STRING_CHARS(property));
    return scm_mem2string(style, strlen(style));
  }
  return SCM_EOL;
}

SCM ruin_scm_api_css_set_style_x(SCM node, SCM property, SCM value) {
  ruin_element_t *elt = ruin_window_lookup_scm(node);
  if (elt != NULL) {
    ruin_layout_add_style(&elt->additional_attribute_style,
			  SCM_STRING_CHARS(property), SCM_STRING_CHARS(value));
    ruin_css_clear_style_cache(elt);
  }
  return SCM_EOL;
}
