#!/bin/bash

# nx_txt2c_varname=`echo $1 | awk '{ FS = "/"; print $NF }'`
nx_txt2c_varname=`echo $1 | sed -e 's;.*/\([^/]*\)$;\1;'`
nx_txt2c_varname=`echo $nx_txt2c_varname | sed -e 's;\..*;;'`
nx_txt2c_outname="$nx_txt2c_varname.c"
nx_txt2c_varname=`echo $nx_txt2c_varname | tr '-' '_'`

nx_txt2c_contents=`cat $1` 
# | tr -d '\n\t'`


nx_txt2c_prefix=`echo $1 | sed -e 's;^[^/]*$;;' -e 's;^\(.*/\)[^/]*$;\1;'`
nx_txt2c_prefix=`echo $nx_txt2c_prefix | sed -e 's;\(.\)/$;\1;'`

outfile="$nx_txt2c_prefix/$nx_txt2c_outname"
echo -n > $outfile

echo "/* $nx_txt2c_outname: Automatically generated by $0" >> $outfile
echo "   (You probably shouldn't edit this file by hand...) */" >> $outfile
echo >> $outfile
echo "char $nx_txt2c_varname[] = { " >> $outfile
echo -n "  " >> $outfile
i=0; temp=2
while [ true ]; do
    single_char="${nx_txt2c_contents:$i:1}"
    check_char1=`echo $single_char | tr '\n\r' a`
    check_char2=`echo $single_char | tr "'" b`
    check_char3=`echo $single_char | tr \\\\\\\\ c`
    # echo -n $check_char
    if [ -z "$single_char" ]; then
	break
    fi
    if [ "$check_char1" = "a" ]; then
	if [ "$check_char1" != "$single_char" ]; then
	    if [ "$single_char" != " " ]; then
		single_char="\\n"
		let temp=$temp+6
	    else
		let temp=$temp+5
	    fi
	else
	    let temp=$temp+5
	fi
    else 
	if [ "$check_char2" = "b" ]; then
	    if [ "$check_char2" != "$single_char" ]; then
		if [ "$single_char" != " " ]; then
		    single_char="\\'"
		    let temp=$temp+6
		else
		    let temp=$temp+5
		fi
	    else
		let temp=$temp+5
	    fi
	else
	    if [ "$check_char3" = "c" ]; then
		if [ "$check_char3" != "$single_char" ]; then
		    if [ "$single_char" != " " ]; then
			single_char="\\\\"
			let temp=$temp+6
		    else
			let temp=$temp+5
		    fi
		else
		    let temp=$temp+5
		fi
	    fi
	fi
	let temp=$temp+5
    fi
    echo -n "'$single_char', " >> $outfile

    if [ "$temp" -gt "74" ]; then
	echo >> $outfile
	echo -n "  " >> $outfile
	temp=2
    fi
    let i=$i+1
done
if [ "$temp" -gt "73" ]; then
    echo >> $outfile
    echo -n "  " >> $outfile
fi
echo "(char) 0" >> $outfile
echo "};" >> $outfile
