/* node-fns.c: Node-management functions for the libRUIN Scheme API
 * Copyright (C) 2005 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include "node-fns.h"

#include <libguile.h>
#include <string.h>

#include "../css.h"
#include "../window.h"

SCM ruin_scm_api_node_pseudo_element_handler(SCM pe, SCM doc, SCM node) {

  /* Here's how we're going to do pseudo-elements: The inline renderer will set
     a flag on the currently rendering ruin_element_t to indicate that a
     particular pseudo-element match should evaluate to true. When this handler
     is called, we find the first immediate inline child (if we're a block 
     element) or the first nested inline child (if we're an inline element),
     and look at the pseudo-element flag set for that element_t. */

  char *pelt_name = SCM_STRING_CHARS(pe);
  int i = 0, len = 0;

  ruin_element_t *t = NULL;

  ruin_window_t *w = ruin_window_lookup_scm(node);
  
  if (w == NULL)
    return SCM_BOOL_F;
  { SCM str = scm_hashq_ref(w->scm_hash, node, SCM_EOL);
    if (scm_string_p(str) == SCM_BOOL_T)
      t = (ruin_element_t *) ruin_util_string_to_ptr(SCM_STRING_CHARS(str));
    else return SCM_BOOL_F;
  }

  len = ruin_util_list_length(t->current_pseudo_elements);
  for (i = 0; i < len; i++) {
    char *e = ruin_util_list_peek_after(t->current_pseudo_elements, i);
    if (strcmp(e, pelt_name) == 0)
      return SCM_BOOL_T;
  }
  
  return SCM_BOOL_F;   
}
