/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "my_string.h"
#include "parserbase.h"

#include <string>
#include <cstring>
#include <map>
#include <fstream>
#include <iostream>

namespace cola {

template <class S, class T>
void ParserBase<S,T>::do_copy(T s)
{
	s.do_copy(&s);
}

template <class S, class T>
int ParserBase<S,T>::telllen(S const& filename, int &l)
{
	std::ifstream  *ifs = new std::ifstream(filename.c_str());
	for (;;) {
		ifs->get();
		if (ifs->eof())
			break;
		else
			l++;
		
	}

	delete ifs;
	return 0;	
}

template <class S, class T>
int ParserBase<S,T>::filein(S const& filename, T const& buf)
{
	std::ifstream  *ifs = new std::ifstream(filename.c_str());
	char c;
	
	for (int i = 0; ifs->get(c) && !ifs->eof(); i++) {
		(const_cast<T &>(buf))[i] = c;
	}

	delete ifs;
	return 0;	
}


template <class S, class T>
int ParserBase<S,T>::load_keywords(S const& filename, std::map<int, T> const& m)
{
	int filelen;
	telllen(filename, filelen);

	std::cout<<"filename="<<filename.c_str()<<std::endl;
	std::ifstream  *ifs = new std::ifstream(filename.c_str());
	//char *buf = new char[1024];//FIXME filelen];
	char buf[1024];//FIXME filelen];
	int i;
	do {
		
		ifs->getline(buf, '\n');

		T temps(buf);
		temps.chompnot();	
		std::cout << "temps=" << temps.c_str()<<std::endl;
		const_cast<std::map<int, T>& >(m).insert(std::pair<int,T>(i, temps));			
		if (ifs->eof()) 
			break;
				

	} while (++i);

	delete ifs;	

	return 0;

}
		
template <class S, class T>
int ParserBase<S,T>::load(S const& filename, S const& parsefilename, std::map<int, T> const& m, T const& buf)
{
	load_keywords(filename, m);

//	int filelen;
//	telllen(filename, filelen);

	filein(parsefilename, buf);

	return 0;

};

template <class S, class T>
int ParserBase<S,T>::parse(S const& filename, S const& parsefilename, int const& wordid)
{
	std::map<int, T> m;
	T buf;
	load(filename, parsefilename, m, buf);

	int j = 0;
	//	std::cout << "*** haystack=" << const_cast<T&>(buf).c_str() << std::endl; 
	for (unsigned int i = 0;i < m.size() /*FIXME: chop last line */; i++ ) {
		parse_for(m[i], j, buf);
	}

	return 0;

}

/*
 * Use const buf but keep in compiletime changes of the buf
 */
template <class S, class T>
int ParserBase<S,T>::parse_for(T const& fors, int &i, T const& buf)
{
	std::cout<<"fors substr i="<<i<<" str="<<const_cast<T &>(fors).c_str()<<std::endl;
	const_cast<T &>(fors).substr(i, const_cast<T &>(buf));

	return 0;
}

}

template class cola::ParserBase<std::string, cola::my_string<std::string> >;
template class std::map<int, cola::my_string<std::string> >;

