/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef _PARSER_H_
#define _PARSER_H_

#include "parserbase.h"

namespace cola {

template <class S, class T>
class Parser;


template <class S, class T> 
class Parser : public ParserBase<S,T> 
{

public:

	Parser() : _filename(""),_parsefilename("") {}
	Parser(Parser const& n) : _filename(n._filename), _parsefilename(n._parsefilename) { _wordid = n._wordid; }
	Parser(S const& fn, S const& parsefn, int wid);
	virtual ~Parser() {}

	int parse();
protected:

	static int _wordid;
	S const& _filename; 
	S const& _parsefilename;
public:
	Parser &operator=(Parser const& n)
	{ 
	const_cast<S&>(_filename) = const_cast<Parser&>(n)._filename; 
	const_cast<S&>(_parsefilename) = const_cast<Parser&>(n)._parsefilename; 
	_wordid = const_cast<Parser&>(n)._wordid; 
	return *this; }
	
};

template <class S, class T>
int Parser<S,T>::_wordid = 0; /* FIXME -1 and test */ 

}
#endif
