/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef _NETPTHREAD_H_
#define _NETPTHREAD_H_

#include <map>
#include <iostream>
#include <unistd.h>
#include "netbase.h"
#include "parser.h"

namespace cola {

template <class S, class T>
class NetPthread : public NetBase
{
public:
	NetPthread() {}
	NetPthread(NetPthread const& n) { this->_scheduler = n._scheduler; }
	virtual ~NetPthread() {}

	inline virtual int lock(pid_t pid) { _scheduler[pid] = -1; return 0; }
	inline virtual int get_status(pid_t pid) { return _scheduler[pid]; }
	inline virtual void set_status(pid_t pid, int s) { _scheduler[pid] = s; }

	
private:
	static std::map<pid_t, int> _scheduler;

public:

	virtual int fork(S const& loadfilename, S const& parsefilename, int const& wordid);
	virtual int parse(Parser<S,T> parser);
	virtual int waitforall();
public:
	NetPthread &operator=(NetPthread const& n) { _scheduler = n._scheduler; return *this; }
};

template <class S, class T>
typename
std::map<pid_t, int> NetPthread<S,T>::_scheduler = std::map<pid_t, int>(); 

}
#endif
