/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef _MYSTRING_H_
#define _MYSTRING_H_


#include<cstring>
#include <iostream>

namespace cola
{
template <class S> class my_string;

template <class T>
class my_stringbase // NOTE : this is a visitor to my_string
{
public:
	my_stringbase() {} 
	my_stringbase(char *buf) {}
	my_stringbase(my_stringbase const& s) {}
	virtual int substr(int& i, my_string<T> const& haystack) = 0;

	virtual int length(void) = 0; 
	virtual int size(void) = 0;
	virtual char *c_str() = 0;

public:
	char &operator[](int index); 
	my_stringbase& operator=(my_stringbase const& s); 
	
};

template <class S>
class my_string : public my_stringbase<S>
{

public:
	my_string<S>() : _string("\0") {}
	my_string<S>(char *buf) : _string(buf) {}
	my_string<S>(my_string<S> const& s);
	virtual ~my_string<S>() {}

private:

//my_string memento
//template <class T>
class my_string_paste
{
	public:
		my_string_paste() {}
		virtual ~my_string_paste() {}

	public:
		inline int do_copy(my_string<S> *s) { set_i(get_i()+1); return 0; /*(*s).do_copy(this);*/}		
		inline int get_i() { return _i; }
		inline void set_i(int j) { _i = j; }

//	private:
		static int _i;
};

public:

	inline virtual int substr(int& i, my_string<S> const& haystack)
	{
		return seek(*this, haystack, i);
	}
	inline virtual int length(void) { /*_string.length()*/ return std::strlen(_string.c_str()); }
	inline virtual int size(void) { return this->length(); }
	inline virtual char *c_str() { return const_cast<char *>(_string.c_str()); }
	//inline virtual my_string<S> get_string() { return _string; }
	char *chompnot();
	void do_copy(my_string<S> *s) { _mem.do_copy(this); }
private:
	virtual int seek(my_string<S> const& s, my_string<S> const& haystack, int& x);
private:
public:
	static my_string_paste _mem;
	S _string;	

public:
	char &operator[](int index) { return _string[index]; }
	my_string<S>& operator=(my_string<S> const& s) 
	{

//		if (*this == s)
//			return (my_string<S>)0;

		for (int i = 0; i < const_cast<my_string<S>& >(s).length(); i++) 
			(*this)[i] = const_cast<my_string<S>& >(s)[i];

		return *this;
	}	

};
template <class S>
typename my_string<S>::my_string_paste
my_string<S>::_mem = my_string_paste();

template <class S>
int my_string<S>::my_string_paste::_i = 0;
}
#endif
